/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.util.ObjectCache;
import org.geotools.util.WeakValueHashMap;

final class FixedSizeObjectCache
implements ObjectCache {
    private final int LIMIT;
    private final Map cache;
    private final Map locks;

    public FixedSizeObjectCache() {
        this(50);
    }

    public FixedSizeObjectCache(int initialSize) {
        this.LIMIT = initialSize;
        this.cache = Collections.synchronizedMap(new WeakValueHashMap(initialSize));
        this.locks = new HashMap(initialSize);
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public Object get(Object key) {
        return this.cache.get(key);
    }

    public Object peek(Object key) {
        return this.cache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLock(Object key) {
        ReentrantLock lock;
        Map map = this.locks;
        synchronized (map) {
            lock = (ReentrantLock)this.locks.get(key);
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(key, lock);
            }
        }
        try {
            lock.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUnLock(Object key) {
        Map map = this.locks;
        synchronized (map) {
            ReentrantLock lock = (ReentrantLock)this.locks.get(key);
            if (lock == null) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            if (lock.holds() == 0L) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            lock.release();
            if (lock.holds() == 0L) {
                this.locks.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean holdsLock(Object key) {
        Map map = this.locks;
        synchronized (map) {
            ReentrantLock lock = (ReentrantLock)this.locks.get(key);
            if (lock != null) {
                return lock.holds() != 0L;
            }
        }
        return false;
    }

    public void put(Object key, Object object) {
        if (this.cache.size() < this.LIMIT) {
            this.writeLock(key);
            this.cache.put(key, object);
            this.writeUnLock(key);
        }
    }
}

