/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;

public abstract class FunctionExpressionImpl
extends DefaultExpression
implements FunctionExpression {
    String name;
    List params;

    protected FunctionExpressionImpl(String name) {
        this.name = name;
        this.params = new ArrayList();
    }

    public short getType() {
        return 114;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getParameters() {
        return this.params;
    }

    public void setParameters(List params) {
        int paramsSize;
        if (params == null) {
            throw new NullPointerException("params can't be null");
        }
        int argCount = this.getArgCount();
        if (argCount != (paramsSize = params.size())) {
            throw new IllegalArgumentException("Expected " + argCount + " arguments, got " + paramsSize);
        }
        this.params = new ArrayList(params);
    }

    public Expression[] getArgs() {
        List params = this.getParameters();
        return params.toArray(new Expression[params.size()]);
    }

    public void setArgs(Expression[] args) {
        this.setParameters(Arrays.asList(args));
    }

    public abstract int getArgCount();

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("(");
        List params = this.getParameters();
        if (params != null) {
            Iterator it = params.iterator();
            while (it.hasNext()) {
                Expression exp = (Expression)it.next();
                sb.append("[");
                sb.append(exp);
                sb.append("]");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected org.opengis.filter.expression.Expression getExpression(int index) {
        org.opengis.filter.expression.Expression exp = (org.opengis.filter.expression.Expression)this.getParameters().get(index);
        return exp;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Function)) {
            return false;
        }
        Function other = (Function)obj;
        if (this.getName() == null && other.getName() != null || this.getName() != null && !this.getName().equalsIgnoreCase(other.getName())) {
            return false;
        }
        if (this.getParameters() == null && other.getClass() != null) {
            return false;
        }
        return this.getParameters() != null && ((Object)this.getParameters()).equals(other.getParameters());
    }
}

