/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.filter.FilterBuilder;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class FilterBuilder2 {
    FilterFactory ff;
    Stack stack = new Stack();

    void state(BuilderState state) {
        if (!this.stack.isEmpty()) {
            boolean replace;
            UndefinedState undefined;
            BuilderState current = (BuilderState)this.stack.peek();
            if (current.isComplete()) {
                Object value = this.build();
                UndefinedState undefined2 = new UndefinedState();
                if (value instanceof Filter) {
                    undefined2.add((Filter)value);
                } else if (value instanceof Expression) {
                    undefined2.add((Expression)value);
                } else {
                    throw new IllegalStateException("Unexpected value");
                }
                this.stack.push(undefined2);
                current = undefined2;
            }
            if (current instanceof UndefinedState && !(undefined = (UndefinedState)current).isEmpty() && (replace = state.init((UndefinedState)current))) {
                this.stack.pop();
            }
        }
        this.stack.push(state);
    }

    BuilderState state() {
        if (this.stack.isEmpty()) {
            this.stack.push(new UndefinedState());
        }
        BuilderState state = (BuilderState)this.stack.peek();
        return state;
    }

    BuilderState state2() {
        if (this.stack.size() > 2) {
            return null;
        }
        return (BuilderState)this.stack.get(this.stack.size() - 2);
    }

    public FilterBuilder2 literal(byte number) {
        return this.expression((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 literal(short number) {
        return this.expression((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 literal(int number) {
        return this.expression((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 literal(long number) {
        return this.expression((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 literal(double number) {
        return this.expression((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 literal(Object object) {
        return this.expression((Expression)this.ff.literal(object));
    }

    private FilterBuilder2 expression(Expression expression) {
        this.state().add(expression);
        this.simplify();
        return this;
    }

    public FilterBuilder2() {
        this(CommonFactoryFinder.getFilterFactory(null));
    }

    public FilterBuilder2(Hints hints) {
        this(CommonFactoryFinder.getFilterFactory(hints));
    }

    public FilterBuilder2(FilterFactory filterFactory) {
        this.ff = filterFactory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.ff = factory;
    }

    public void init() {
        this.stack.clear();
    }

    public Expression expr() {
        return (Expression)this.build();
    }

    public Filter filter() {
        return (Filter)this.build();
    }

    public Object build() {
        BuilderState state = this.state();
        return state.build();
    }

    private void simplify() {
        while (this.state().isComplete()) {
            BuilderState state = this.state();
            Object value = state.build();
            if (value instanceof Expression) {
                Expression expression = (Expression)value;
                this.state().add(expression);
                continue;
            }
            if (value instanceof Filter) {
                Filter filter = (Filter)value;
                this.state().add(filter);
                continue;
            }
            throw new IllegalStateException("Completed but did not produce a result");
        }
    }

    public FilterBuilder2 left(Expression left) {
        this.state().setLeftExpression(left);
        this.simplify();
        return this;
    }

    public void setLeft(Expression left) {
        this.state().setLeftExpression(left);
        this.simplify();
    }

    public FilterBuilder2 right(Expression right) {
        this.state().setRightExpression(right);
        this.simplify();
        return this;
    }

    public void setRight(Expression right) {
        this.state().setRightExpression(right);
        this.simplify();
    }

    public FilterBuilder2 expression(int position, Expression expr) {
        this.state().setExpression(position, expr);
        this.simplify();
        return this;
    }

    public void setExpression(int position, Expression expr) {
        this.state().setExpression(position, expr);
        this.simplify();
    }

    public FilterBuilder2 filter(Filter filter) {
        this.state().add(filter);
        this.simplify();
        return this;
    }

    FilterBuilder2 name(String name) {
        this.state().setName(name);
        return this;
    }

    FilterBuilder2 function() {
        this.state(new FunctionState());
        return this;
    }

    FilterBuilder2 function(String functionName) {
        this.state(new FunctionState());
        this.state().setName(functionName);
        return this;
    }

    public FilterBuilder2 add() {
        this.state(new AddState());
        return this;
    }

    public FilterBuilder2 add(Object number) {
        return this.add((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 add(int number) {
        return this.add((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 add(long number) {
        return this.add((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 add(double number) {
        return this.add((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 add(FilterBuilder2 build) {
        return this.add(build.expr());
    }

    public FilterBuilder2 add(Expression right) {
        this.state(new AddState());
        this.expression(right);
        return this;
    }

    public FilterBuilder2 subtract() {
        this.state(new SubtractState());
        return this;
    }

    public FilterBuilder2 subtract(Object number) {
        return this.subtract((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 subtract(long number) {
        return this.subtract((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 subtract(double number) {
        return this.subtract((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 subtract(FilterBuilder build) {
        return this.subtract(build.expr());
    }

    public FilterBuilder2 subtract(Expression right) {
        this.state(new SubtractState());
        this.expression(right);
        return this;
    }

    public FilterBuilder2 multiply() {
        this.state(new MultiplyState());
        return this;
    }

    public FilterBuilder2 multiply(Object number) {
        return this.multiply((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 multiply(long number) {
        return this.multiply((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 multiply(double number) {
        return this.multiply((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 multiply(FilterBuilder build) {
        return this.multiply(build.expr());
    }

    public FilterBuilder2 multiply(Expression right) {
        this.state(new MultiplyState());
        this.expression(right);
        return this;
    }

    public FilterBuilder2 divide() {
        this.state(new DivideState());
        return this;
    }

    public FilterBuilder2 divide(long number) {
        return this.divide((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 divide(double number) {
        return this.divide((Expression)this.ff.literal(number));
    }

    public FilterBuilder2 divide(FilterBuilder build) {
        return this.divide(build.expr());
    }

    public FilterBuilder2 divide(Expression right) {
        this.state(new DivideState());
        this.expression(right);
        return this;
    }

    public FilterBuilder2 and() {
        this.state(new AndState());
        return this;
    }

    public FilterBuilder2 and(FilterBuilder build) {
        return this.and(build.filter());
    }

    public FilterBuilder2 and(Filter right) {
        this.state(new AndState());
        this.filter(right);
        return this;
    }

    public FilterBuilder2 or() {
        this.state(new OrState());
        return this;
    }

    public FilterBuilder2 or(FilterBuilder build) {
        return this.or(build.filter());
    }

    public FilterBuilder2 or(Filter right) {
        this.state(new OrState());
        this.filter(right);
        return this;
    }

    class FunctionState
    extends BuilderState {
        List expressions;
        String name;

        FunctionState() {
            this.expressions = new ArrayList(1);
        }

        public boolean init(UndefinedState undefined) {
            this.name = undefined.name;
            this.expressions = undefined.expressions;
            return !undefined.expressions.isEmpty() || undefined.name != null;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void add(Expression expression) {
            this.expressions.add(expression);
        }

        public Object build() {
            if (this.name == null) {
                throw new IllegalStateException("Name required for function");
            }
            Function function = FilterBuilder2.this.ff.function(this.name, this.expressions.toArray(new Expression[this.expressions.size()]));
            FilterBuilder2.this.stack.pop();
            return function;
        }
    }

    class DivideState
    extends InfixState {
        DivideState() {
        }

        public Object build() {
            this.assertCompleted();
            FilterBuilder2.this.stack.pop();
            return FilterBuilder2.this.ff.divide(this.left, this.right);
        }
    }

    class MultiplyState
    extends InfixState {
        MultiplyState() {
        }

        public Object build() {
            this.assertCompleted();
            FilterBuilder2.this.stack.pop();
            return FilterBuilder2.this.ff.multiply(this.left, this.right);
        }
    }

    class AddState
    extends InfixState {
        AddState() {
        }

        public Object build() {
            this.assertCompleted();
            FilterBuilder2.this.stack.pop();
            return FilterBuilder2.this.ff.add(this.left, this.right);
        }
    }

    class SubtractState
    extends InfixState {
        public Object build() {
            this.assertCompleted();
            FilterBuilder2.this.stack.pop();
            return FilterBuilder2.this.ff.subtract(this.left, this.right);
        }
    }

    abstract class InfixState
    extends BuilderState {
        Expression left;
        Expression right;

        public InfixState() {
            this.left = null;
            this.right = null;
        }

        public String toString() {
            String name = this.getClass().getName();
            return "Infix[" + this.left + " " + name + " " + this.right + "]";
        }

        public boolean init(UndefinedState undefined) {
            if (undefined.expressions.size() == 0) {
                return true;
            }
            if (undefined.expressions.size() == 1) {
                this.left = undefined.getLeftExpression();
                return true;
            }
            if (undefined.expressions.size() == 2) {
                this.left = undefined.getLeftExpression();
                this.right = undefined.getRightExpression();
                return true;
            }
            this.left = (Expression)undefined.expressions.remove(0);
            this.right = (Expression)undefined.expressions.remove(0);
            return false;
        }

        public void setLeftExpression(Expression expr) {
            this.left = expr;
        }

        public void setRightExpression(Expression expr) {
            this.right = expr;
        }

        public void add(Expression expression) {
            if (this.left == null) {
                this.left = expression;
            } else if (this.right == null) {
                this.right = expression;
            } else {
                throw new IllegalStateException("Both left and right have been defined");
            }
        }

        public void add(Filter filter) {
            throw new IllegalStateException("Filter not expected");
        }

        public boolean isComplete() {
            return this.left != null && this.right != null;
        }

        protected void assertCompleted() throws IllegalStateException {
            if (this.left == null) {
                throw new IllegalStateException("Left expression required");
            }
            if (this.right == null) {
                throw new IllegalStateException("Right expression required");
            }
        }
    }

    class UndefinedState
    extends BuilderState {
        List expressions;
        List filters;
        public String name;

        public UndefinedState() {
            this.expressions = new ArrayList(2);
            this.filters = new ArrayList(2);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("Undefined[");
            if (this.name != null) {
                buf.append(this.name);
                buf.append("|");
            }
            if (!this.expressions.isEmpty()) {
                buf.append(this.expressions);
            }
            if (!this.filters.isEmpty()) {
                buf.append(this.filters);
            }
            buf.append("]");
            return buf.toString();
        }

        public void setName(String name) {
            this.name = name;
        }

        public void add(Expression expression) {
            this.expressions.add(expression);
        }

        public void add(Filter filter) {
            this.filters.add(filter);
        }

        public void setLeftExpression(Expression expression) {
            this.setExpression(0, expression);
        }

        public Expression getLeftExpression() {
            if (this.expressions.size() >= 1) {
                return (Expression)this.expressions.get(0);
            }
            return null;
        }

        public void setExpression(int position, Expression expression) {
            while (this.expressions.size() <= position) {
                this.expressions.add(null);
            }
            this.expressions.set(position, expression);
        }

        public boolean isEmpty() {
            return this.expressions.isEmpty() && this.filters.isEmpty() && this.name == null;
        }

        public Filter getLeftFilter() {
            if (this.filters.size() >= 1) {
                return (Filter)this.filters.get(0);
            }
            return null;
        }

        public Expression getRightExpression() {
            if (this.expressions.size() >= 2) {
                return (Expression)this.expressions.get(1);
            }
            return null;
        }

        public void setRightExpression(Expression expression) {
            this.setExpression(1, expression);
        }

        public Filter getRightFilter() {
            if (this.filters.size() >= 2) {
                return (Filter)this.filters.get(1);
            }
            return null;
        }

        public void setRightFilter(Filter filter) {
            if (this.filters.isEmpty()) {
                this.filters.add(null);
            }
            this.filters.set(1, filter);
        }

        public Object build() {
            if (this.expressions.size() == 1) {
                Expression value = (Expression)this.expressions.get(0);
                FilterBuilder2.this.stack.pop();
                return value;
            }
            if (this.filters.size() == 1) {
                Filter value = (Filter)this.filters.get(0);
                FilterBuilder2.this.stack.pop();
                return value;
            }
            throw new IllegalStateException("Undefined state");
        }
    }

    class NotState
    extends BuilderState {
        Filter filter;

        NotState() {
            this.filter = null;
        }

        public boolean init(UndefinedState undefined) {
            if (undefined.filters.size() == 1) {
                this.filter = (Filter)undefined.filters.get(0);
                return true;
            }
            return false;
        }

        public void add(Expression expression) {
            UndefinedState undefined = new UndefinedState();
            ((BuilderState)undefined).add(expression);
            FilterBuilder2.this.stack.push(undefined);
        }

        public void add(Filter filter) {
            if (filter == null) {
                throw new NullPointerException("Filter required");
            }
            if (this.filter == null) {
                this.filter = filter;
            } else {
                UndefinedState undefined = new UndefinedState();
                ((BuilderState)undefined).add(filter);
                FilterBuilder2.this.stack.push(undefined);
            }
        }

        public Object build() {
            Not value = FilterBuilder2.this.ff.not(this.filter);
            FilterBuilder2.this.stack.pop();
            return value;
        }
    }

    class OrState
    extends BuilderState {
        List filters;

        OrState() {
            this.filters = new ArrayList(2);
        }

        public boolean init(UndefinedState undefined) {
            this.filters = undefined.filters;
            return true;
        }

        public void add(Expression expression) {
            if (expression == null) {
                throw new NullPointerException("Expression required");
            }
            UndefinedState undefined = new UndefinedState();
            ((BuilderState)undefined).add(expression);
            FilterBuilder2.this.stack.push(undefined);
        }

        public void add(Filter filter) {
            if (filter == null) {
                throw new NullPointerException("Filter required");
            }
            if (filter instanceof Or) {
                Or or = (Or)filter;
                this.filters.addAll(or.getChildren());
            } else {
                this.filters.add(filter);
            }
        }

        public Object build() {
            if (this.filters.isEmpty()) {
                throw new IllegalStateException("No filters provided for AND");
            }
            if (this.filters.size() == 1) {
                return this.filters.get(0);
            }
            Or filter = FilterBuilder2.this.ff.or(this.filters);
            FilterBuilder2.this.stack.pop();
            return filter;
        }
    }

    class AndState
    extends BuilderState {
        List filters;

        AndState() {
            this.filters = new ArrayList(2);
        }

        public boolean init(UndefinedState undefined) {
            this.filters = undefined.filters;
            return true;
        }

        public void add(Expression expression) {
            if (expression == null) {
                throw new NullPointerException("Expression required");
            }
            UndefinedState undefined = new UndefinedState();
            ((BuilderState)undefined).add(expression);
            FilterBuilder2.this.stack.push(undefined);
        }

        public void add(Filter filter) {
            if (filter == null) {
                throw new NullPointerException("Filter required");
            }
            if (filter instanceof And) {
                And and = (And)filter;
                this.filters.addAll(and.getChildren());
            } else {
                this.filters.add(filter);
            }
        }

        public Object build() {
            if (this.filters.isEmpty()) {
                throw new IllegalStateException("No filters provided for AND");
            }
            if (this.filters.size() == 1) {
                return this.filters.get(0);
            }
            And filter = FilterBuilder2.this.ff.and(this.filters);
            FilterBuilder2.this.stack.pop();
            return filter;
        }
    }

    abstract class BuilderState {
        BuilderState() {
        }

        public boolean init(UndefinedState undefined) {
            return false;
        }

        public void setName(String name) {
            throw new IllegalStateException("Name not expected");
        }

        public void setLeftExpression(Expression expression) {
            this.add(expression);
        }

        public Expression getLeftExpression() {
            return null;
        }

        public void addFilter(Filter filter) {
            this.add(filter);
        }

        public void setRightExpression(Expression expression) {
            this.add(expression);
        }

        public Expression getRightExpression() {
            return null;
        }

        public void setExpression(int position, Expression expression) {
            throw new IllegalStateException("Expression " + position + " not expected");
        }

        public void add(Expression expression) {
            throw new IllegalStateException("Expression not expected");
        }

        public void add(Filter filter) {
            throw new IllegalStateException("Filter not expected");
        }

        public boolean isComplete() {
            return false;
        }

        public abstract Object build();
    }
}

