/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.Name;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.feature.type.TypeName;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.xml.Choice;
import org.opengis.feature.xml.ChoiceType;
import org.opengis.feature.xml.Sequence;
import org.opengis.feature.xml.SequenceType;
import org.opengis.filter.Filter;

public class Types {
    public static org.opengis.feature.type.Name[] names(ComplexType type) {
        ArrayList<org.opengis.feature.type.Name> names = new ArrayList<org.opengis.feature.type.Name>();
        for (AttributeDescriptor ad : type.attributes()) {
            names.add(ad.getName());
        }
        return names.toArray(new org.opengis.feature.type.Name[names.size()]);
    }

    public static org.opengis.feature.type.Name attributeName(String name) {
        if (name == null) {
            return null;
        }
        return new Name(name);
    }

    public static org.opengis.feature.type.Name attributeName(String namespace, String name) {
        return new Name(namespace, name);
    }

    public static org.opengis.feature.type.Name attributeName(org.opengis.feature.type.Name name) {
        return new Name(name.getNamespaceURI(), name.getLocalPart());
    }

    public static TypeName typeName(String name) {
        if (name == null) {
            return null;
        }
        return new TypeName(name);
    }

    public static TypeName typeName(String namespace, String name) {
        return new TypeName(namespace, name);
    }

    public static TypeName typeName(org.opengis.feature.type.Name name) {
        return new TypeName(name.getNamespaceURI(), name.getLocalPart());
    }

    public static org.opengis.feature.type.Name[] toNames(String[] names) {
        if (names == null) {
            return null;
        }
        org.opengis.feature.type.Name[] attributeNames = new org.opengis.feature.type.Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            attributeNames[i] = Types.attributeName(names[i]);
        }
        return attributeNames;
    }

    public static TypeName[] toTypeNames(String[] names) {
        if (names == null) {
            return null;
        }
        TypeName[] typeNames = new TypeName[names.length];
        for (int i = 0; i < names.length; ++i) {
            typeNames[i] = Types.typeName(names[i]);
        }
        return typeNames;
    }

    public static String[] fromNames(org.opengis.feature.type.Name[] attributeNames) {
        if (attributeNames == null) {
            return null;
        }
        String[] names = new String[attributeNames.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            names[i] = attributeNames[i].getLocalPart();
        }
        return names;
    }

    public static String[] fromTypeNames(TypeName[] typeNames) {
        if (typeNames == null) {
            return null;
        }
        String[] names = new String[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            names[i] = typeNames[i].getLocalPart();
        }
        return names;
    }

    public static PropertyDescriptor descriptor(ComplexType type, String name) {
        List match = Types.descriptors(type, name);
        if (match.isEmpty()) {
            return null;
        }
        return (PropertyDescriptor)match.get(0);
    }

    public static PropertyDescriptor descriptor(ComplexType type, String name, AttributeType actualType) {
        List match = Types.descriptors(type, name);
        if (match.isEmpty()) {
            Collection properties = type.getProperties();
            for (PropertyDescriptor desc : properties) {
                AttributeDescriptor attDesc;
                AttributeType attType;
                if (!(desc instanceof AttributeDescriptor) || !Types.isSuperType(actualType, attType = (attDesc = (AttributeDescriptor)desc).getType())) continue;
                return attDesc;
            }
            return null;
        }
        return (PropertyDescriptor)match.get(0);
    }

    public static PropertyDescriptor descriptor(ComplexType type, org.opengis.feature.type.Name name, AttributeType actualType) {
        List match = Types.descriptors(type, name);
        if (match.isEmpty()) {
            Collection properties = type.getProperties();
            for (PropertyDescriptor desc : properties) {
                AttributeDescriptor attDesc;
                AttributeType attType;
                if (!(desc instanceof AttributeDescriptor) || !Types.isSuperType(actualType, attType = (attDesc = (AttributeDescriptor)desc).getType())) continue;
                return attDesc;
            }
            return null;
        }
        return (PropertyDescriptor)match.get(0);
    }

    public static PropertyDescriptor descriptor(ComplexType type, String name, String namespace) {
        return Types.descriptor(type, (org.opengis.feature.type.Name)new Name(namespace, name));
    }

    public static PropertyDescriptor descriptor(ComplexType type, org.opengis.feature.type.Name name) {
        List match = Types.descriptors(type, name);
        if (match.isEmpty()) {
            return null;
        }
        return (PropertyDescriptor)match.get(0);
    }

    public static List descriptors(ComplexType type, String name) {
        AttributeType superType;
        if (name == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyDescriptor> match = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : type.getProperties()) {
            String localPart = descriptor.getName().getLocalPart();
            if (!name.equals(localPart)) continue;
            match.add(descriptor);
        }
        if (match.size() == 0 && (superType = type.getSuper()) instanceof ComplexType) {
            List superDescriptors = Types.descriptors((ComplexType)superType, name);
            match.addAll(superDescriptors);
        }
        return match;
    }

    public static List descriptors(ComplexType type, org.opengis.feature.type.Name name) {
        AttributeType superType;
        if (name == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyDescriptor> match = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : type.getProperties()) {
            org.opengis.feature.type.Name descriptorName = descriptor.getName();
            if (!name.equals(descriptorName)) continue;
            match.add(descriptor);
        }
        if (match.size() == 0 && (superType = type.getSuper()) instanceof ComplexType) {
            List superDescriptors = Types.descriptors((ComplexType)superType, name);
            match.addAll(superDescriptors);
        }
        return match;
    }

    public static boolean isSuperType(AttributeType type, AttributeType parent) {
        while (type.getSuper() != null) {
            if (!(type = type.getSuper()).equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static Object parse(AttributeType type, Object content) throws IllegalArgumentException {
        AttributeTypeImpl hack;
        Object parsed;
        if (type instanceof AttributeTypeImpl && (parsed = (hack = (AttributeTypeImpl)type).parse(content)) != null) {
            return parsed;
        }
        return content;
    }

    public static void validate(Attribute attribute) throws IllegalAttributeException {
        Types.validate(attribute, attribute.getValue());
    }

    public static void validate(Attribute attribute, Object attributeContent) throws IllegalAttributeException {
        Types.validate(attribute.getType(), attribute, attributeContent, false);
    }

    public static void validate(AttributeType type, Attribute attribute, Object attributeContent) throws IllegalAttributeException {
        Types.validate(type, attribute, attributeContent, false);
    }

    protected static void validate(AttributeType type, Attribute attribute, Object attributeContent, boolean isSuper) throws IllegalAttributeException {
        if (type == null) {
            throw new IllegalAttributeException("null type");
        }
        if (attributeContent == null) {
            if (!attribute.nillable()) {
                throw new IllegalAttributeException(type.getName() + " not nillable");
            }
            return;
        }
        if (type.isIdentified() && attribute.getID() == null) {
            throw new NullPointerException(type.getName() + " is identified, null id not accepted");
        }
        if (!isSuper) {
            Class<?> clazz = attributeContent.getClass();
            Class binding = type.getBinding();
            if (binding != null && !binding.isAssignableFrom(clazz)) {
                throw new IllegalAttributeException(clazz.getName() + " is not an acceptable class for " + type.getName() + " as it is not assignable from " + binding);
            }
        }
        if (type.getRestrictions() != null && type.getRestrictions().size() > 0) {
            final Attribute fatt = attribute;
            Attribute fake = new Attribute(){

                public AttributeDescriptor getDescriptor() {
                    return fatt.getDescriptor();
                }

                public PropertyDescriptor descriptor() {
                    return fatt.descriptor();
                }

                public org.opengis.feature.type.Name name() {
                    return fatt.name();
                }

                public AttributeType getType() {
                    return fatt.getType();
                }

                public boolean nillable() {
                    return fatt.nillable();
                }

                public String getID() {
                    return fatt.getID();
                }

                public Object getValue() {
                    return fatt.getValue();
                }

                public void setValue(Object newValue) throws IllegalArgumentException {
                    throw new UnsupportedOperationException("Modification is not supported");
                }

                public Object operation(org.opengis.feature.type.Name arg0, List arg1) {
                    throw new UnsupportedOperationException("Operation is not supported");
                }
            };
            for (Filter f : type.getRestrictions()) {
                if (f.evaluate((Object)fake)) continue;
                throw new IllegalAttributeException("Attribute instance (" + fake.getID() + ")" + "fails to pass filter: " + f);
            }
        }
        if (type.getSuper() != null) {
            Types.validate(type.getSuper(), attribute, attributeContent, true);
        }
    }

    public static void validate(ComplexAttribute attribute) throws IllegalArgumentException {
    }

    public static void validate(ComplexAttribute attribute, Collection content) throws IllegalArgumentException {
    }

    protected static void validate(ComplexType type, ComplexAttribute attribute, Collection content) throws IllegalAttributeException {
        Types.validate((AttributeType)type, (Attribute)attribute, content, false);
        if (content == null) {
            return;
        }
        Collection schema = type.attributes();
        int index = 0;
        for (Attribute att : content) {
            if (att == null) {
                throw new NullPointerException("Attribute at index " + index + " is null. Attributes " + "can't be null. Do you mean Attribute.get() == null?");
            }
            AttributeType attType = att.getType();
            boolean contains = false;
            for (AttributeDescriptor ad : schema) {
                if (!ad.getType().equals(attType)) continue;
                contains = true;
                break;
            }
            if (!contains) {
                throw new IllegalArgumentException("Attribute of type " + attType.getName() + " found at index " + index + " but this type is not allowed by this descriptor");
            }
            ++index;
        }
        if (type.attributes().isEmpty()) {
            if (!content.isEmpty()) {
                throw new IllegalAttributeException("Type indicates empty attribute collection, content does not");
            }
            return;
        }
        if (type instanceof SequenceType) {
            Types.validateSequence((SequenceType)type, attribute, content);
        } else if (type instanceof ChoiceType) {
            Types.validateChoice((ChoiceType)type, attribute, content);
        } else {
            Types.validateAll(type, attribute, content);
        }
        if (type.getSuper() != null) {
            Types.validate((ComplexType)type.getSuper(), attribute, content);
        }
    }

    private static void validateSequence(SequenceType type, ComplexAttribute att, Collection content) throws IllegalAttributeException {
        if (!(att instanceof Sequence)) {
            throw new IllegalAttributeException("Attribute must be instance of: " + Sequence.class.getName() + " for type instance of: " + SequenceType.class.getName());
        }
        if (!(content instanceof List)) {
            throw new IllegalAttributeException("Content must be instance of " + List.class.getName() + " for Sequence");
        }
        Types.processSequence((List)type.attributes(), (List)content);
    }

    private static void processSequence(List sequence, List content) throws IllegalAttributeException {
        Iterator ditr = sequence.iterator();
        ArrayList remaining = new ArrayList(content);
        do {
            AttributeDescriptor ad = (AttributeDescriptor)ditr.next();
            int occurences = 0;
            Iterator itr = remaining.iterator();
            while (itr.hasNext()) {
                Attribute a = (Attribute)itr.next();
                if (!ad.getName().equals(a.name())) break;
                ++occurences;
                itr.remove();
            }
            int min = ad.getMinOccurs();
            int max = ad.getMaxOccurs();
            if (occurences >= min && occurences <= max) continue;
            throw new IllegalAttributeException("Found " + occurences + " occurences of " + ad.getName() + " when between " + min + " and " + max + " expected");
        } while (ditr.hasNext());
        if (!remaining.isEmpty()) {
            throw new IllegalAttributeException("Extra content found beyond the specified in the schema: " + remaining);
        }
    }

    private static void validateChoice(ChoiceType type, ComplexAttribute att, Collection content) throws IllegalAttributeException {
        if (!(att instanceof Choice)) {
            throw new IllegalAttributeException("Attribute must be instance of: " + Choice.class.getName() + " for type instance of: " + ChoiceType.class.getName());
        }
        Types.processChoice((Set)type.attributes(), content);
    }

    private static void processChoice(Set choice, Collection content) throws IllegalAttributeException {
    }

    private static void validateAll(ComplexType type, ComplexAttribute att, Collection content) throws IllegalAttributeException {
        Types.processAll(type.attributes(), content);
    }

    private static void processAll(Collection all, Collection content) throws IllegalAttributeException {
        ArrayList remaining = new ArrayList(content);
        for (AttributeDescriptor ad : all) {
            int min = ad.getMinOccurs();
            int max = ad.getMaxOccurs();
            int occurences = 0;
            Iterator citr = remaining.iterator();
            while (citr.hasNext()) {
                Attribute a = (Attribute)citr.next();
                if (!a.name().equals(ad.getName())) continue;
                ++occurences;
                citr.remove();
            }
            if (occurences >= ad.getMinOccurs() && occurences <= ad.getMaxOccurs()) continue;
            throw new IllegalAttributeException("Found " + occurences + " of " + ad.getName() + " when type" + "specifies between " + min + " and " + max);
        }
        if (!remaining.isEmpty()) {
            throw new IllegalAttributeException("Extra content found beyond the specified in the schema: " + remaining);
        }
    }
}

