/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.Name;
import org.geotools.feature.type.TypeName;
import org.geotools.referencing.CRS;
import org.opengis.feature.type.AssociationDescriptor;
import org.opengis.feature.type.AssociationType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureCollectionType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;
import org.opengis.feature.type.Schema;
import org.opengis.feature.type.StructuralDescriptor;
import org.opengis.feature.type.TypeFactory;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class TypeBuilder {
    private TypeFactory factory;
    private String namespace;
    private String name;
    private Class binding;
    private InternationalString description;
    private boolean isIdentified;
    private boolean isAbstract;
    private Set restrictions;
    private PropertyType superType;
    private boolean isNillable;
    private Object defaultValue;
    private Map bindings;
    private Collection properties;
    private int minOccurs;
    private int maxOccurs;
    private org.opengis.feature.type.Name defaultGeom = null;
    private CoordinateReferenceSystem crs = null;
    private AttributeType referenceType;
    protected Collection members;
    private PropertyType propertyType;

    public TypeBuilder(TypeFactory factory) {
        this.factory = factory;
        this.init();
    }

    public TypeFactory getTypeFactory() {
        return this.factory;
    }

    public void setTypeFactory(TypeFactory factory) {
        this.factory = factory;
    }

    public void reset() {
        this.name = null;
        this.description = null;
        this.properties = this.newCollection(this.properties);
        this.members = this.newCollection(this.members);
        this.defaultGeom = null;
    }

    public void clear() {
        this.minOccurs = 1;
        this.maxOccurs = 1;
        this.isNillable = false;
    }

    public void init() {
        this.namespace = null;
        this.name = null;
        this.description = null;
        this.isIdentified = false;
        this.binding = null;
        this.isAbstract = false;
        this.restrictions = null;
        this.superType = null;
        this.properties = null;
        this.isNillable = true;
        this.minOccurs = 1;
        this.maxOccurs = 1;
        this.propertyType = null;
        this.defaultGeom = null;
        this.crs = null;
        this.referenceType = null;
    }

    public void init(PropertyDescriptor descriptor) {
        this.init();
        this.namespace = descriptor.getName().getNamespaceURI();
        this.name = descriptor.getName().getLocalPart();
        if (descriptor instanceof StructuralDescriptor) {
            StructuralDescriptor structure = (StructuralDescriptor)descriptor;
            this.minOccurs = structure.getMinOccurs();
            this.maxOccurs = structure.getMaxOccurs();
        }
        if (descriptor instanceof AttributeDescriptor) {
            AttributeDescriptor attribute = (AttributeDescriptor)descriptor;
            this.isNillable = attribute.isNillable();
            this.propertyType = attribute.getType();
        }
        if (descriptor instanceof AssociationDescriptor) {
            AssociationDescriptor association = (AssociationDescriptor)descriptor;
            this.propertyType = association.getType();
        }
    }

    public void init(PropertyType type) {
        this.init();
        if (type == null) {
            return;
        }
        this.namespace = type.getName().getNamespaceURI();
        this.name = type.getName().getLocalPart();
        this.description = type.getDescription();
        this.isAbstract = type.isAbstract();
        this.restrictions = null;
        this.restrictions().addAll(type.getRestrictions());
        if (type instanceof AssociationType) {
            AssociationType assType = (AssociationType)type;
            this.referenceType = assType.getReferenceType();
            this.superType = assType.getSuper();
        }
        if (type instanceof AttributeType) {
            AttributeType aType = (AttributeType)type;
            this.binding = aType.getBinding();
            this.isIdentified = aType.isIdentified();
            this.superType = aType.getSuper();
        }
        if (type instanceof GeometryType) {
            GeometryType geometryType = (GeometryType)type;
            this.crs = geometryType.getCRS();
        }
        if (type instanceof ComplexType) {
            ComplexType cType = (ComplexType)type;
            this.properties = null;
            this.properties = null;
            this.properties.addAll(cType.attributes());
        }
        if (type instanceof FeatureType) {
            FeatureType featureType = (FeatureType)type;
            this.defaultGeom = featureType.getDefaultGeometry().getName();
            this.crs = featureType.getCRS();
        }
    }

    public AttributeType attribute() {
        AttributeType type = this.factory.createAttributeType((org.opengis.feature.type.Name)this.typeName(), this.getBinding(), this.isIdentified(), this.isAbstract(), this.restrictions(), this.getSuper(), this.getDescription());
        this.reset();
        return type;
    }

    public AssociationType association() {
        return this.factory.createAssociationType((org.opengis.feature.type.Name)this.typeName(), this.getReferenceType(), true, true, this.restrictions, this.getAssociationSuper(), this.getDescription());
    }

    public GeometryType geometry() {
        return this.getTypeFactory().createGeometryType((org.opengis.feature.type.Name)this.typeName(), this.getBinding(), this.getCRS(), this.isIdentified(), this.isAbstract(), this.restrictions(), this.getSuper(), this.getDescription());
    }

    public ComplexType complex() {
        ComplexType type = this.getTypeFactory().createComplexType((org.opengis.feature.type.Name)this.typeName(), this.properties(), this.isIdentified(), this.isAbstract(), this.restrictions(), this.getSuper(), this.getDescription());
        this.reset();
        return type;
    }

    public AttributeDescriptor attributeDescriptor() {
        AttributeDescriptor attribute = this.getTypeFactory().createAttributeDescriptor((AttributeType)this.propertyType, (org.opengis.feature.type.Name)this.typeName(), this.getMinOccurs(), this.getMaxOccurs(), this.isNillable(), this.getDefaultValue());
        this.reset();
        return attribute;
    }

    public AssociationDescriptor associationDescriptor() {
        AssociationDescriptor association = this.getTypeFactory().createAssociationDescriptor((AssociationType)this.propertyType, (org.opengis.feature.type.Name)this.typeName(), this.getMinOccurs(), this.getMaxOccurs());
        this.reset();
        return association;
    }

    public FeatureType feature() {
        FeatureType type = this.getTypeFactory().createFeatureType((org.opengis.feature.type.Name)this.typeName(), this.properties(), this.defaultGeometry(), this.getCRS(), this.isAbstract(), this.restrictions(), this.getSuper(), this.getDescription());
        this.reset();
        return type;
    }

    public FeatureCollectionType collection() {
        FeatureCollectionType type = this.getTypeFactory().createFeatureCollectionType((org.opengis.feature.type.Name)this.typeName(), this.properties(), this.members(), this.defaultGeometry(), this.getCRS(), this.isAbstract(), this.restrictions(), this.getSuper(), this.getDescription());
        this.reset();
        return type;
    }

    public void setNamespaceURI(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TypeBuilder name(String name) {
        this.setName(name);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setBinding(Class binding) {
        this.binding = binding;
    }

    public TypeBuilder bind(Class binding) {
        this.setBinding(binding);
        return this;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyType type) {
        this.propertyType = type;
    }

    public TypeBuilder property(PropertyType type) {
        this.setPropertyType(type);
        return this;
    }

    public Class getBinding() {
        return this.binding;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString description) {
        this.description = description;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public TypeBuilder nillable(boolean isNillable) {
        this.isNillable = isNillable;
        return this;
    }

    public void setNillable(boolean isNillable) {
        this.isNillable = isNillable;
    }

    public boolean isNillable() {
        return this.isNillable;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setIdentified(boolean isIdentified) {
        this.isIdentified = isIdentified;
    }

    public boolean isIdentified() {
        return this.isIdentified;
    }

    public void setSuper(PropertyType superType) {
        this.superType = superType;
    }

    public AttributeType getSuper() {
        return (AttributeType)this.superType;
    }

    public AssociationType getAssociationSuper() {
        return (AssociationType)this.superType;
    }

    public void addRestriction(Filter restriction) {
        this.restrictions().add(restriction);
    }

    public void setRestrictions(Set restrictions) {
        this.restrictions = restrictions;
    }

    public Set getRestrictions() {
        return this.restrictions;
    }

    public void setRestriction(Set restrictions) {
        this.restrictions = restrictions;
    }

    protected Set restrictions() {
        if (this.restrictions == null) {
            this.restrictions = this.createRestrictionSet();
        }
        return this.restrictions;
    }

    protected Set createRestrictionSet() {
        return new HashSet();
    }

    protected TypeName typeName() {
        if (this.name != null) {
            return new TypeName(this.namespace, this.name);
        }
        return null;
    }

    public AttributeType getBinding(Class binding) {
        AttributeType type = (AttributeType)this.bindings().get(binding);
        if (type == null) {
            throw new IllegalArgumentException("No type bound to: " + binding);
        }
        return type;
    }

    public void addBinding(Class binding, AttributeType type) {
        this.bindings().put(binding, type);
    }

    public void load(Schema schema) {
        for (AttributeType type : schema.values()) {
            this.addBinding(type.getBinding(), type);
        }
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public TypeBuilder cardinality(int min, int max) {
        this.minOccurs = min;
        this.maxOccurs = max;
        return this;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public TypeBuilder attribute(String name, Class binding) {
        return this.attribute(this.namespace, name, binding);
    }

    public TypeBuilder attribute(String namespaceURI, String name, Class binding) {
        return this.attribute((org.opengis.feature.type.Name)new Name(namespaceURI, name), binding);
    }

    public TypeBuilder attribute(org.opengis.feature.type.Name name, Class binding) {
        return this.attribute(name, this.getBinding(binding));
    }

    public TypeBuilder attribute(String name, String namespaceURI, AttributeType type) {
        this.attribute((org.opengis.feature.type.Name)new Name(namespaceURI, name), type);
        return this;
    }

    public TypeBuilder attribute(String name, AttributeType type) {
        this.attribute(name, this.getNamespaceURI(), type);
        return this;
    }

    public TypeBuilder attribute(org.opengis.feature.type.Name name, AttributeType type) {
        AttributeDescriptor descriptor = this.getTypeFactory().createAttributeDescriptor(type, name, this.getMinOccurs(), this.getMaxOccurs(), this.isNillable(), this.getDefaultValue());
        this.add((StructuralDescriptor)descriptor);
        return this;
    }

    public void addAttribute(String name, Class binding) {
        this.addAttribute(this.namespace, name, binding);
    }

    public void addAttribute(String uri, String name, Class binding) {
        this.addAttribute((org.opengis.feature.type.Name)new Name(uri, name), binding);
    }

    public void addAttribute(org.opengis.feature.type.Name name, Class binding) {
        this.addAttribute(name, this.getBinding(binding));
    }

    public void addAttribute(String name, AttributeType type) {
        this.addAttribute(name, this.getNamespaceURI(), type);
    }

    public void addAttribute(String name, String namespaceURI, AttributeType type) {
        this.addAttribute((org.opengis.feature.type.Name)new Name(namespaceURI, name), type);
    }

    public void addAttribute(org.opengis.feature.type.Name name, AttributeType type) {
        AttributeDescriptor descriptor = this.getTypeFactory().createAttributeDescriptor(type, name, this.getMinOccurs(), this.getMaxOccurs(), this.isNillable(), this.getDefaultValue());
        this.add((StructuralDescriptor)descriptor);
    }

    public void setReferenceType(AttributeType reference) {
        this.referenceType = reference;
    }

    public TypeBuilder referenceType(AttributeType reference) {
        this.setReferenceType(reference);
        return this;
    }

    public AttributeType getReferenceType() {
        return this.referenceType;
    }

    public TypeBuilder association(String name, AssociationType type) {
        return this.association(this.getNamespaceURI(), name, type);
    }

    public TypeBuilder association(String namespaceURI, String name, AssociationType type) {
        return this.association((org.opengis.feature.type.Name)new Name(namespaceURI, name), type);
    }

    public TypeBuilder association(org.opengis.feature.type.Name name, AssociationType type) {
        AssociationDescriptor descriptor = this.getTypeFactory().createAssociationDescriptor(type, name, this.getMinOccurs(), this.getMaxOccurs());
        this.add((StructuralDescriptor)descriptor);
        return this;
    }

    public TypeBuilder add(StructuralDescriptor descriptor) {
        if (!TypeBuilder.contains(this.properties(), (PropertyDescriptor)descriptor)) {
            this.properties.add(descriptor);
        }
        this.clear();
        return this;
    }

    public static boolean contains(Collection collection, PropertyDescriptor descriptor) {
        for (PropertyDescriptor d : collection) {
            if (!d.getName().equals(descriptor.getName())) continue;
            return true;
        }
        return false;
    }

    public Collection getProperties() {
        if (this.properties == null) {
            this.properties = this.newCollection();
        }
        return this.properties;
    }

    public void setProperties(Collection properties) {
        this.properties = properties;
    }

    protected Collection newCollection() {
        return new HashSet();
    }

    protected Collection newCollection(Collection origional) {
        if (origional == null) {
            return this.newCollection();
        }
        try {
            return (Collection)origional.getClass().newInstance();
        }
        catch (InstantiationException e) {
            return this.newCollection();
        }
        catch (IllegalAccessException e) {
            return this.newCollection();
        }
    }

    protected Collection properties() {
        if (this.properties == null) {
            this.properties = this.newCollection();
        }
        return this.properties;
    }

    protected Map bindings() {
        if (this.bindings == null) {
            this.bindings = new HashMap();
        }
        return this.bindings;
    }

    public void setDefaultGeometry(String name) {
        this.setDefaultGeometry(name, this.getNamespaceURI());
    }

    public void setDefaultGeometry(String name, String namespaceURI) {
        this.setDefaultGeometry((org.opengis.feature.type.Name)new Name(namespaceURI, name));
    }

    public void setDefaultGeometry(org.opengis.feature.type.Name name) {
        this.defaultGeom = name;
    }

    public TypeBuilder defaultGeometry(String name) {
        this.setDefaultGeometry(name);
        return this;
    }

    public org.opengis.feature.type.Name getDefaultGeometry() {
        return this.defaultGeom;
    }

    protected AttributeDescriptor defaultGeometry() {
        if (this.defaultGeom != null) {
            for (AttributeDescriptor ad : this.getProperties()) {
                if (!ad.getName().equals(this.defaultGeom)) continue;
                return ad;
            }
        }
        for (AttributeDescriptor ad : this.getProperties()) {
            if (!(ad.getType() instanceof GeometryType)) continue;
            return ad;
        }
        return null;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public TypeBuilder crs(CoordinateReferenceSystem crs) {
        this.setCRS(crs);
        return this;
    }

    public TypeBuilder crs(String SRS) {
        try {
            this.setCRS(CRS.decode((String)SRS));
        }
        catch (Exception e) {
            String msg = "SRS '" + SRS + "' unknown:" + e.getLocalizedMessage();
            throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
        }
        return this;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public Collection getMembers() {
        if (this.members == null) {
            this.members = this.newCollection();
        }
        return this.members;
    }

    public void setMembers(Collection members) {
        this.members = members;
    }

    protected Collection members() {
        if (this.members == null) {
            this.members = this.newCollection();
        }
        return this.members;
    }

    public void addMemberType(String name, AssociationType memberType) {
        this.addMemberType(this.getNamespaceURI(), name, memberType);
    }

    public void addMemberType(String namespaceURI, String name, AssociationType memberType) {
        this.addMemberType((org.opengis.feature.type.Name)new Name(namespaceURI, name), memberType);
    }

    public void addMemberType(org.opengis.feature.type.Name name, AssociationType memberType) {
        this.member(name, memberType);
    }

    public TypeBuilder member(String name, AssociationType type) {
        return this.member((org.opengis.feature.type.Name)new Name(this.getNamespaceURI(), name), type);
    }

    public TypeBuilder member(org.opengis.feature.type.Name name, AssociationType type) {
        AssociationDescriptor descriptor = this.getTypeFactory().createAssociationDescriptor(type, name, this.getMinOccurs(), this.getMaxOccurs());
        this.clear();
        return this.member(descriptor);
    }

    public TypeBuilder member(AssociationDescriptor memberOf) {
        if (!TypeBuilder.contains(this.members(), (PropertyDescriptor)memberOf)) {
            this.members.add(memberOf);
        }
        return this;
    }
}

