/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotools.resources.Utilities;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyType;
import org.opengis.util.InternationalString;

public class PropertyTypeImpl
implements PropertyType {
    protected final Name name;
    protected final boolean isAbstract;
    protected final Set restrictions;
    protected final InternationalString description;
    protected final Map userData;

    public PropertyTypeImpl(Name name, boolean isAbstract, Set restrictions, InternationalString description) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        this.isAbstract = isAbstract;
        this.restrictions = restrictions == null ? restrictions : Collections.unmodifiableSet(restrictions);
        this.description = description;
        this.userData = new HashMap();
    }

    public Name getName() {
        return this.name;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Set getRestrictions() {
        return this.restrictions;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[name=").append(this.name).append(", abstrsct=, ").append(this.isAbstract).append(", restrictions=").append(this.restrictions).append(", description=").append((CharSequence)this.description);
        return sb.toString();
    }

    public int hashCode() {
        return this.getName().hashCode() ^ (this.getDescription() != null ? this.getDescription().hashCode() : 17);
    }

    public boolean equals(Object other) {
        if (!(other instanceof PropertyType)) {
            return false;
        }
        PropertyType prop = (PropertyType)other;
        if (!Utilities.equals((Object)this.name, (Object)prop.getName())) {
            return false;
        }
        if (this.isAbstract != prop.isAbstract()) {
            return false;
        }
        if (!Utilities.equals((Object)this.restrictions, (Object)prop.getRestrictions())) {
            return false;
        }
        return Utilities.equals((Object)this.description, (Object)prop.getDescription());
    }

    public Object getUserData(Object key) {
        return this.userData.get(key);
    }

    public void putUserData(Object key, Object value) {
        if (value == null && this.userData.containsKey(key)) {
            this.userData.remove(key);
        } else if (value != null) {
            this.userData.put(key, value);
        }
    }
}

