/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.geotools.data.collection.ResourceCollection;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.collection.FeatureState;
import org.geotools.feature.type.FeatureAttributeType;

public class BaseFeatureState
extends FeatureState {
    final FeatureType featureType;
    final FeatureType schema;
    String id;
    private List listeners = new ArrayList(2);

    public static FeatureType featureType(FeatureType schema) {
        LinkedList<FeatureAttributeType> ats = new LinkedList<FeatureAttributeType>();
        ats.add(new FeatureAttributeType(schema.getTypeName(), schema, false));
        return new DefaultFeatureType("AbstractFeatureColletionType", FeatureTypes.DEFAULT_NAMESPACE, ats, new LinkedList(), null);
    }

    public BaseFeatureState(ResourceCollection collection, FeatureType schema) {
        this(collection, BaseFeatureState.featureType(schema), schema);
    }

    public BaseFeatureState(ResourceCollection collection, FeatureType featureType, FeatureType schema) {
        super(collection);
        this.featureType = featureType;
        this.schema = schema;
    }

    public void addListener(CollectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CollectionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChange(Feature[] features, int type) {
        this.bounds = null;
        CollectionEvent cEvent = new CollectionEvent((FeatureCollection)this.data, features, type);
        int ii = this.listeners.size();
        for (int i = 0; i < ii; ++i) {
            ((CollectionListener)this.listeners.get(i)).collectionChanged(cEvent);
        }
    }

    protected void fireChange(Feature feature, int type) {
        this.fireChange(new Feature[]{feature}, type);
    }

    protected void fireChange(Collection coll, int type) {
        Feature[] features = new Feature[coll.size()];
        features = coll.toArray(features);
        this.fireChange(features, type);
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public FeatureType getChildFeatureType() {
        return this.schema;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

