/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.LockingManager;
import org.geotools.data.Repository;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureType;

public class FeatureSourceRepository
implements Repository {
    protected SortedMap featuresources = new TreeMap();

    public SortedMap getFeatureSources() {
        return Collections.unmodifiableSortedMap(this.featuresources);
    }

    public Set getPrefixes() throws IOException {
        HashSet<String> prefix = new HashSet<String>();
        for (FeatureSource fs : this.featuresources.values()) {
            FeatureType schema = fs.getSchema();
            prefix.add(schema.getNamespace().toString());
        }
        return prefix;
    }

    private SortedSet typeNames() throws IOException {
        TreeSet<String> typeNames = new TreeSet<String>();
        for (FeatureSource fs : this.featuresources.values()) {
            FeatureType schema = fs.getSchema();
            typeNames.add(schema.getTypeName());
        }
        return typeNames;
    }

    private Map dataStores() {
        TreeMap<String, DataStore> dataStores = new TreeMap<String, DataStore>();
        for (Map.Entry entry : this.featuresources.entrySet()) {
            String key = (String)entry.getKey();
            String dataStoreId = key.split(":")[0];
            FeatureSource fs = (FeatureSource)entry.getValue();
            dataStores.put(dataStoreId, fs.getDataStore());
        }
        return dataStores;
    }

    private SortedMap types(DataStore ds) throws IOException {
        TreeMap<String, FeatureType> map = new TreeMap<String, FeatureType>();
        String[] typeNames = ds.getTypeNames();
        for (int i = 0; i < typeNames.length; ++i) {
            try {
                map.put(typeNames[i], ds.getSchema(typeNames[i]));
                continue;
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return map;
    }

    public SortedMap types() {
        return new TreeMap(this.featuresources);
    }

    public boolean lockExists(String lockID) {
        if (lockID == null) {
            return false;
        }
        for (DataStore store : this.dataStores().values()) {
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.exists(lockID)) continue;
            return true;
        }
        return false;
    }

    public boolean lockRefresh(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean refresh = false;
        for (DataStore store : this.dataStores().values()) {
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            refresh = true;
        }
        return refresh;
    }

    public boolean lockRelease(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean release = false;
        for (DataStore store : this.dataStores().values()) {
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            release = true;
        }
        return release;
    }

    public void register(String id, FeatureSource featureSource) throws IOException {
        this.featuresources.put(id + ":" + featureSource.getSchema().getTypeName(), featureSource);
    }

    public DataStore datastore(String id) {
        HashSet prefix = new HashSet();
        for (Map.Entry entry : this.featuresources.entrySet()) {
            String key = (String)entry.getKey();
            String dataStoreId = key.split(":")[0];
            if (!id.equals(dataStoreId)) continue;
            FeatureSource fs = (FeatureSource)entry.getValue();
            return fs.getDataStore();
        }
        return null;
    }

    public Map getDataStores() {
        return Collections.unmodifiableMap(this.dataStores());
    }

    public FeatureSource source(String dataStoreId, String typeName) throws IOException {
        String typeRef = dataStoreId + ":" + typeName;
        return (FeatureSource)this.featuresources.get(typeRef);
    }
}

