/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.collection.CollectionDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.DefaultFeatureTypeBuilder;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureCollection;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataUtilities {
    static Map typeMap = new HashMap();
    static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    public static String[] attributeNames(FeatureType featureType) {
        String[] names = new String[featureType.getAttributeCount()];
        int count = featureType.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            names[i] = featureType.getAttributeType(i).getLocalName();
        }
        return names;
    }

    public static File urlToFile(URL url) {
        String auth = url.getAuthority();
        String path = url.getPath();
        File f = null;
        f = auth != null && !auth.equals("") ? new File("//" + auth + path) : new File(path);
        return f;
    }

    public static String[] attributeNames(Filter filter, FeatureType featureType) {
        if (filter == null) {
            return new String[0];
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        filter.accept((FilterVisitor)attExtractor, null);
        String[] attributeNames = attExtractor.getAttributeNames();
        return attributeNames;
    }

    public static String[] attributeNames(Filter filter) {
        return DataUtilities.attributeNames(filter, null);
    }

    public static String[] attributeNames(Expression expression, FeatureType featureType) {
        if (expression == null) {
            return new String[0];
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        expression.accept((ExpressionVisitor)attExtractor, null);
        String[] attributeNames = attExtractor.getAttributeNames();
        return attributeNames;
    }

    public static String[] attributeNames(Expression expression) {
        return DataUtilities.attributeNames(expression, null);
    }

    public static void traverse(Filter filter, FilterVisitor visitor) {
        DataUtilities.traverse(DataUtilities.traverseDepth(filter), visitor);
    }

    public static void traverse(Expression expression, FilterVisitor visitor) {
        DataUtilities.traverse(DataUtilities.traverseDepth(expression), visitor);
    }

    public static void traverse(Set set, FilterVisitor visitor) {
        for (Object here : set) {
            if (here instanceof Filter) {
                ((Filter)here).accept(visitor, null);
                continue;
            }
            if (here instanceof Expression) {
                if (!(visitor instanceof ExpressionVisitor)) {
                    throw new IllegalArgumentException("visitor is not an ExpressionVisitor");
                }
                ((Expression)here).accept((ExpressionVisitor)visitor, null);
                continue;
            }
            throw new IllegalArgumentException("Not a Filter or an Expression: " + here);
        }
    }

    public static Set traverseDepth(Filter filter) {
        final HashSet set = new HashSet();
        Traversal traverse = new Traversal(){

            void traverse(Filter f) {
                set.add(f);
            }

            void traverse(Expression expression) {
                set.add(expression);
            }
        };
        filter.accept((FilterVisitor)traverse, null);
        return set;
    }

    public static Set traverseDepth(Expression expression) {
        final HashSet set = new HashSet();
        Traversal traverse = new Traversal(){

            void traverse(Filter f) {
                set.add(f);
            }

            void traverse(Expression expr) {
                set.add(expr);
            }
        };
        expression.accept((ExpressionVisitor)traverse, null);
        return set;
    }

    public static int compare(FeatureType typeA, FeatureType typeB) {
        int countB;
        if (typeA == typeB) {
            return 0;
        }
        if (typeA == null) {
            return -1;
        }
        if (typeB == null) {
            return -1;
        }
        int countA = typeA.getAttributeCount();
        if (countA > (countB = typeB.getAttributeCount())) {
            return -1;
        }
        int match = 0;
        for (int i = 0; i < countA; ++i) {
            AttributeType a = typeA.getAttributeType(i);
            if (DataUtilities.isMatch(a, typeB.getAttributeType(i))) {
                ++match;
                continue;
            }
            if (DataUtilities.isMatch(a, typeB.getAttributeType(a.getLocalName()))) continue;
            return -1;
        }
        if (countA == countB && match == countA) {
            return 0;
        }
        return 1;
    }

    public static boolean isMatch(AttributeType a, AttributeType b) {
        if (a == b) {
            return true;
        }
        if (b == null) {
            return false;
        }
        if (a == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        return a.getLocalName().equals(b.getLocalName()) && a.getClass().equals(b.getClass());
    }

    public static Feature reType(FeatureType featureType, Feature feature) throws IllegalAttributeException {
        FeatureType origional = feature.getFeatureType();
        if (featureType.equals(origional)) {
            return featureType.duplicate(feature);
        }
        String id = feature.getID();
        int numAtts = featureType.getAttributeCount();
        Object[] attributes = new Object[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            AttributeType curAttType = featureType.getAttributeType(i);
            String xpath = curAttType.getLocalName();
            attributes[i] = curAttType.duplicate(feature.getAttribute(xpath));
        }
        return featureType.create(attributes, id);
    }

    public static Feature template(FeatureType featureType) throws IllegalAttributeException {
        return featureType.create(DataUtilities.defaultValues(featureType));
    }

    public static Feature template(FeatureType featureType, String featureID) throws IllegalAttributeException {
        return featureType.create(DataUtilities.defaultValues(featureType), featureID);
    }

    public static Object[] defaultValues(FeatureType featureType) throws IllegalAttributeException {
        return DataUtilities.defaultValues(featureType, null);
    }

    public static Feature template(FeatureType featureType, Object[] atts) throws IllegalAttributeException {
        return featureType.create(DataUtilities.defaultValues(featureType, atts));
    }

    public static Feature template(FeatureType featureType, String featureID, Object[] atts) throws IllegalAttributeException {
        return featureType.create(DataUtilities.defaultValues(featureType, atts), featureID);
    }

    public static Object[] defaultValues(FeatureType featureType, Object[] values) throws IllegalAttributeException {
        if (values == null) {
            values = new Object[featureType.getAttributeCount()];
        } else if (values.length != featureType.getAttributeCount()) {
            throw new ArrayIndexOutOfBoundsException("values");
        }
        for (int i = 0; i < featureType.getAttributeCount(); ++i) {
            values[i] = DataUtilities.defaultValue(featureType.getAttributeType(i));
        }
        return values;
    }

    public static Object defaultValue(AttributeType attributeType) throws IllegalAttributeException {
        Object value = attributeType.createDefaultValue();
        if (value == null && !attributeType.isNillable()) {
            throw new IllegalAttributeException("Got null default value for non-null type.");
        }
        return value;
    }

    public static Object defaultValue(Class type) {
        if (type == String.class || type == Object.class) {
            return "";
        }
        if (type == Integer.class) {
            return new Integer(0);
        }
        if (type == Double.class) {
            return new Double(0.0);
        }
        if (type == Long.class) {
            return new Long(0L);
        }
        if (type == Short.class) {
            return new Short(0);
        }
        if (type == Float.class) {
            return new Float(0.0f);
        }
        if (type == Character.class) {
            return new Character(' ');
        }
        GeometryFactory fac = new GeometryFactory();
        Coordinate coordinate = new Coordinate(0.0, 0.0);
        Point point = fac.createPoint(coordinate);
        if (type == Point.class) {
            return point;
        }
        if (type == MultiPoint.class) {
            return fac.createMultiPoint(new Point[]{point});
        }
        if (type == LineString.class) {
            return fac.createLineString(new Coordinate[]{coordinate, coordinate, coordinate, coordinate});
        }
        LinearRing linearRing = fac.createLinearRing(new Coordinate[]{coordinate, coordinate, coordinate, coordinate});
        if (type == LinearRing.class) {
            return linearRing;
        }
        if (type == MultiLineString.class) {
            return fac.createMultiLineString(new LineString[]{linearRing});
        }
        Polygon polygon = fac.createPolygon(linearRing, new LinearRing[0]);
        if (type == Polygon.class) {
            return polygon;
        }
        if (type == MultiPolygon.class) {
            return fac.createMultiPolygon(new Polygon[]{polygon});
        }
        throw new IllegalArgumentException(type + " is not supported by this method");
    }

    public static FeatureReader reader(final Feature[] features) throws IOException {
        if (features == null || features.length == 0) {
            throw new IOException("Provided features where empty");
        }
        return new FeatureReader(){
            Feature[] array;
            int offset;
            {
                this.array = features;
                this.offset = -1;
            }

            public FeatureType getFeatureType() {
                return features[0].getFeatureType();
            }

            public Feature next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more features");
                }
                return this.array[++this.offset];
            }

            public boolean hasNext() {
                return this.array != null && this.offset < this.array.length - 1;
            }

            public void close() {
                this.array = null;
                this.offset = -1;
            }
        };
    }

    public static FeatureSource source(final Feature[] featureArray) {
        final FeatureType featureType = featureArray == null || featureArray.length == 0 ? DefaultFeatureType.EMPTY : featureArray[0].getFeatureType();
        AbstractDataStore arrayStore = new AbstractDataStore(){

            public String[] getTypeNames() {
                return new String[]{featureType.getTypeName()};
            }

            public FeatureType getSchema(String typeName) throws IOException {
                if (typeName != null && typeName.equals(featureType.getTypeName())) {
                    return featureType;
                }
                throw new IOException(typeName + " not available");
            }

            protected FeatureReader getFeatureReader(String typeName) throws IOException {
                return DataUtilities.reader(featureArray);
            }
        };
        try {
            return arrayStore.getFeatureSource(arrayStore.getTypeNames()[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Something is wrong with the geotools code, this exception should not happen", e);
        }
    }

    public static FeatureSource source(FeatureCollection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        CollectionDataStore store = new CollectionDataStore(collection);
        try {
            return store.getFeatureSource(store.getTypeNames()[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Something is wrong with the geotools code, this exception should not happen", e);
        }
    }

    public static FeatureCollection results(Feature[] featureArray) {
        return DataUtilities.results(DataUtilities.collection(featureArray));
    }

    public static FeatureCollection results(FeatureCollection collection) {
        if (collection.size() == 0) {
            // empty if block
        }
        return collection;
    }

    public static FeatureReader reader(Collection collection) throws IOException {
        return DataUtilities.reader(collection.toArray(new Feature[collection.size()]));
    }

    public static FeatureCollection collection(Feature[] features) {
        FeatureCollection collection = FeatureCollections.newCollection();
        int length = features.length;
        for (int i = 0; i < length; ++i) {
            collection.add((Object)features[i]);
        }
        return collection;
    }

    public static FeatureCollection collection(FeatureCollection featureCollection) {
        return new DefaultFeatureCollection(featureCollection);
    }

    public static SimpleFeatureCollection collection(List<Feature> list) {
        FeatureCollection collection = FeatureCollections.newCollection();
        for (Feature feature : list) {
            collection.add(list);
        }
        return collection;
    }

    public static FeatureCollection collection(Feature feature) {
        FeatureCollection collection = FeatureCollections.newCollection();
        collection.add((Object)feature);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FeatureCollection collection(FeatureReader reader) throws IOException {
        FeatureCollection collection = FeatureCollections.newCollection();
        try {
            while (reader.hasNext()) {
                try {
                    collection.add((Object)reader.next());
                }
                catch (NoSuchElementException e) {
                    throw (IOException)new IOException("EOF").initCause(e);
                }
                catch (IllegalAttributeException e) {
                    throw (IOException)new IOException().initCause(e);
                    return collection;
                }
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FeatureCollection collection(FeatureIterator reader) throws IOException {
        FeatureCollection collection = FeatureCollections.newCollection();
        try {
            while (reader.hasNext()) {
                try {
                    collection.add((Object)reader.next());
                }
                catch (NoSuchElementException e) {
                    throw (IOException)new IOException("EOF").initCause(e);
                    return collection;
                }
            }
        }
        finally {
            reader.close();
        }
    }

    public static boolean attributesEqual(Object att, Object otherAtt) {
        if (att == null) {
            if (otherAtt != null) {
                return false;
            }
        } else if (!att.equals(otherAtt)) {
            if (att instanceof Geometry && otherAtt instanceof Geometry) {
                if (!((Geometry)att).equals((Geometry)otherAtt)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static FeatureType createSubType(FeatureType featureType, String[] properties, CoordinateReferenceSystem override) throws SchemaException {
        return DataUtilities.createSubType(featureType, properties, override, featureType.getTypeName(), featureType.getNamespace());
    }

    public static FeatureType createSubType(FeatureType featureType, String[] properties, CoordinateReferenceSystem override, String typeName, URI namespace) throws SchemaException {
        if (properties == null && override == null) {
            return featureType;
        }
        if (properties == null) {
            properties = new String[featureType.getAttributeCount()];
            for (int i = 0; i < properties.length; ++i) {
                properties[i] = featureType.getAttributeType(i).getLocalName();
            }
        }
        boolean same = featureType.getAttributeCount() == properties.length && featureType.getTypeName().equals(typeName) && featureType.getNamespace().equals(namespace);
        for (int i = 0; i < featureType.getAttributeCount() && same; ++i) {
            AttributeType type = featureType.getAttributeType(i);
            same = type.getLocalName().equals(properties[i]) && (override == null || !(type instanceof GeometryAttributeType) || DataUtilities.assertEquals(override, ((GeometryAttributeType)type).getCoordinateSystem()));
        }
        if (same) {
            return featureType;
        }
        AttributeType[] types = new AttributeType[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            types[i] = featureType.getAttributeType(properties[i]);
            if (override == null || !(types[i] instanceof GeometryAttributeType)) continue;
            types[i] = new GeometricAttributeType((GeometricAttributeType)types[i], override);
        }
        if (typeName == null) {
            typeName = featureType.getTypeName();
        }
        if (namespace == null) {
            namespace = featureType.getNamespace();
        }
        return FeatureTypeFactory.newFeatureType(types, typeName, namespace);
    }

    private static boolean assertEquals(Object o1, Object o2) {
        return o1 == null && o2 == null ? true : (o1 != null ? o1.equals(o2) : false);
    }

    public static FeatureType createSubType(FeatureType featureType, String[] properties) throws SchemaException {
        if (properties == null) {
            return featureType;
        }
        boolean same = featureType.getAttributeCount() == properties.length;
        for (int i = 0; i < featureType.getAttributeCount() && same; ++i) {
            same = featureType.getAttributeType(i).getLocalName().equals(properties[i]);
        }
        if (same) {
            return featureType;
        }
        AttributeType[] types = new AttributeType[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            types[i] = featureType.getAttributeType(properties[i]);
        }
        return FeatureTypeFactory.newFeatureType(types, featureType.getTypeName(), featureType.getNamespace());
    }

    public static FeatureType createType(String identification, String typeSpec) throws SchemaException {
        int split = identification.lastIndexOf(46);
        String namespace = split == -1 ? null : identification.substring(0, split);
        String typeName = split == -1 ? identification : identification.substring(split + 1);
        DefaultFeatureTypeBuilder tb = new DefaultFeatureTypeBuilder();
        tb.setName(typeName);
        tb.setNamespaceURI(namespace);
        String[] types = typeSpec.split(",");
        int geometryIndex = -1;
        GeometryAttributeType geometryAttribute = null;
        for (int i = 0; i < types.length; ++i) {
            if (types[i].startsWith("*")) {
                types[i] = types[i].substring(1);
                geometryIndex = i;
            }
            AttributeType attributeType = DataUtilities.createAttribute(types[i]);
            tb.add(attributeType);
            if (geometryAttribute != null || !(attributeType instanceof GeometryAttributeType)) continue;
            if (geometryIndex == -1) {
                geometryAttribute = (GeometryAttributeType)attributeType;
                continue;
            }
            if (geometryIndex != i) continue;
            geometryAttribute = (GeometryAttributeType)attributeType;
        }
        if (geometryAttribute != null) {
            tb.setDefaultGeometry(geometryAttribute.getLocalName());
        }
        return tb.buildFeatureType();
    }

    public static Feature parse(FeatureType type, String fid, String[] text) throws IllegalAttributeException {
        Object[] attributes = new Object[text.length];
        for (int i = 0; i < text.length; ++i) {
            attributes[i] = type.getAttributeType(i).parse((Object)text[i]);
        }
        return type.create(attributes, fid);
    }

    public static String spec(FeatureType featureType) {
        AttributeType[] types = featureType.getAttributeTypes();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < types.length; ++i) {
            buf.append(types[i].getLocalName());
            buf.append(":");
            buf.append(DataUtilities.typeMap(types[i].getBinding()));
            if (i >= types.length - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    static Class type(String typeName) throws ClassNotFoundException {
        if (typeMap.containsKey(typeName)) {
            return (Class)typeMap.get(typeName);
        }
        return Class.forName(typeName);
    }

    static String typeMap(Class type) {
        for (Map.Entry entry : typeMap.entrySet()) {
            if (!entry.getValue().equals(type)) continue;
            return (String)entry.getKey();
        }
        return type.getName();
    }

    public static Query mixQueries(Query firstQuery, Query secondQuery, String handle) {
        String version;
        if (firstQuery == null || secondQuery == null) {
            throw new NullPointerException("got a null query argument");
        }
        if (firstQuery.equals(Query.ALL)) {
            return secondQuery;
        }
        if (secondQuery.equals(Query.ALL)) {
            return firstQuery;
        }
        if (firstQuery.getTypeName() != null && secondQuery.getTypeName() != null && !firstQuery.getTypeName().equals(secondQuery.getTypeName())) {
            String msg = "Type names do not match: " + firstQuery.getTypeName() + " != " + secondQuery.getTypeName();
            throw new IllegalArgumentException(msg);
        }
        if (firstQuery.getVersion() != null) {
            if (secondQuery.getVersion() != null && !secondQuery.getVersion().equals(firstQuery.getVersion())) {
                throw new IllegalArgumentException("First and second query refer different versions");
            }
            version = firstQuery.getVersion();
        } else {
            version = secondQuery.getVersion();
        }
        int maxFeatures = Math.min(firstQuery.getMaxFeatures(), secondQuery.getMaxFeatures());
        String[] propNames = DataUtilities.joinAttributes(firstQuery.getPropertyNames(), secondQuery.getPropertyNames());
        Filter filter = firstQuery.getFilter();
        Filter filter2 = secondQuery.getFilter();
        if (filter == null || filter.equals(Filter.INCLUDE)) {
            filter = filter2;
        } else if (filter2 != null && !filter2.equals(Filter.INCLUDE)) {
            filter = ff.and(filter, filter2);
        }
        String typeName = firstQuery.getTypeName() != null ? firstQuery.getTypeName() : secondQuery.getTypeName();
        DefaultQuery mixed = new DefaultQuery(typeName, filter, maxFeatures, propNames, handle);
        mixed.setVersion(version);
        return mixed;
    }

    private static String[] joinAttributes(String[] atts1, String[] atts2) {
        String[] propNames = null;
        if (atts1 == null && atts2 == null) {
            return null;
        }
        LinkedList<String> atts = new LinkedList<String>();
        if (atts1 != null) {
            atts.addAll(Arrays.asList(atts1));
        }
        if (atts2 != null) {
            for (int i = 0; i < atts2.length; ++i) {
                if (atts.contains(atts2[i])) continue;
                atts.add(atts2[i]);
            }
        }
        propNames = new String[atts.size()];
        atts.toArray(propNames);
        return propNames;
    }

    static AttributeType createAttribute(String typeSpec) throws SchemaException {
        String type;
        String name;
        int split = typeSpec.indexOf(":");
        String hint = null;
        if (split == -1) {
            name = typeSpec;
            type = "String";
        } else {
            name = typeSpec.substring(0, split);
            int split2 = typeSpec.indexOf(":", split + 1);
            if (split2 == -1) {
                type = typeSpec.substring(split + 1);
            } else {
                type = typeSpec.substring(split + 1, split2);
                hint = typeSpec.substring(split2 + 1);
            }
        }
        try {
            boolean nillable = true;
            CoordinateReferenceSystem crs = null;
            if (hint != null) {
                StringTokenizer st = new StringTokenizer(hint, ";");
                while (st.hasMoreTokens()) {
                    String h = st.nextToken();
                    if ((h = h.trim()).equals("nillable")) {
                        nillable = true;
                    }
                    if (!h.startsWith("srid=")) continue;
                    String srid = h.split("=")[1];
                    Integer.parseInt(srid);
                    try {
                        crs = CRS.decode((String)("EPSG:" + srid));
                    }
                    catch (Exception e) {
                        String msg = "Error decoding srs: " + srid;
                        throw new SchemaException(msg, (Throwable)e);
                    }
                }
            }
            return AttributeTypeFactory.newAttributeType(name, DataUtilities.type(type), nillable, -1, null, crs);
        }
        catch (ClassNotFoundException e) {
            throw new SchemaException("Could not type " + name + " as:" + type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Envelope bounds(FeatureCollection collection) {
        Iterator i = collection.iterator();
        try {
            Envelope bounds = new Envelope();
            if (!i.hasNext()) {
                bounds.setToNull();
                Envelope envelope = bounds;
                return envelope;
            }
            bounds.init((Envelope)((Feature)i.next()).getBounds());
            Envelope envelope = bounds;
            return envelope;
        }
        finally {
            collection.close(i);
        }
    }

    static {
        typeMap.put("String", String.class);
        typeMap.put("string", String.class);
        typeMap.put("\"\"", String.class);
        typeMap.put("Integer", Integer.class);
        typeMap.put("int", Integer.class);
        typeMap.put("0", Integer.class);
        typeMap.put("Double", Double.class);
        typeMap.put("double", Double.class);
        typeMap.put("0.0", Double.class);
        typeMap.put("Float", Float.class);
        typeMap.put("float", Float.class);
        typeMap.put("0.0f", Float.class);
        typeMap.put("Boolean", Boolean.class);
        typeMap.put("true", Boolean.class);
        typeMap.put("false", Boolean.class);
        typeMap.put("Geometry", Geometry.class);
        typeMap.put("Point", Point.class);
        typeMap.put("LineString", LineString.class);
        typeMap.put("Polygon", Polygon.class);
        typeMap.put("MultiPoint", MultiPoint.class);
        typeMap.put("MultiLineString", MultiLineString.class);
        typeMap.put("MultiPolygon", MultiPolygon.class);
        typeMap.put("GeometryCollection", GeometryCollection.class);
        typeMap.put("Date", Date.class);
    }

    static abstract class Traversal
    extends DefaultFilterVisitor {
        Traversal() {
        }

        abstract void traverse(Filter var1);

        abstract void traverse(Expression var1);

        public Object visit(ExcludeFilter filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(IncludeFilter filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(And filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Id filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Not filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Or filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(PropertyIsBetween filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(PropertyIsEqualTo filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(PropertyIsNotEqualTo filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(PropertyIsGreaterThan filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(PropertyIsLessThan filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(PropertyIsLike filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(PropertyIsNull filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(BBOX filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Beyond filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Contains filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Crosses filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Disjoint filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(DWithin filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Equals filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Intersects filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Overlaps filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Touches filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visit(Within filter, Object data) {
            this.traverse((Filter)filter);
            return super.visit(filter, data);
        }

        public Object visitNullFilter(Object data) {
            return super.visitNullFilter(data);
        }

        public Object visit(NilExpression expr, Object data) {
            this.traverse((Expression)expr);
            return super.visit(expr, data);
        }

        public Object visit(Add expr, Object data) {
            this.traverse((Expression)expr);
            return super.visit(expr, data);
        }

        public Object visit(Divide expr, Object data) {
            this.traverse((Expression)expr);
            return super.visit(expr, data);
        }

        public Object visit(Function expr, Object data) {
            this.traverse((Expression)expr);
            return super.visit(expr, data);
        }

        public Object visit(Literal expr, Object data) {
            this.traverse((Expression)expr);
            return super.visit(expr, data);
        }

        public Object visit(Multiply expr, Object data) {
            this.traverse((Expression)expr);
            return super.visit(expr, data);
        }

        public Object visit(PropertyName expr, Object data) {
            this.traverse((Expression)expr);
            return super.visit(expr, data);
        }

        public Object visit(Subtract expr, Object data) {
            this.traverse((Expression)expr);
            return super.visit(expr, data);
        }
    }
}

