/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.geometry.coordinate;

import java.util.List;
import java.util.Set;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.coordinate.Arc;
import org.opengis.geometry.coordinate.ArcByBulge;
import org.opengis.geometry.coordinate.ArcString;
import org.opengis.geometry.coordinate.ArcStringByBulge;
import org.opengis.geometry.coordinate.BSplineCurve;
import org.opengis.geometry.coordinate.BSplineSurface;
import org.opengis.geometry.coordinate.Geodesic;
import org.opengis.geometry.coordinate.GeodesicString;
import org.opengis.geometry.coordinate.KnotType;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.coordinate.Tin;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public interface GeometryFactory {
    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    public DirectPosition createDirectPosition();

    public DirectPosition createDirectPosition(double[] var1);

    public Envelope createEnvelope(DirectPosition var1, DirectPosition var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public LineSegment createLineSegment(Position var1, Position var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public LineString createLineString(List var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Geodesic createGeodesic(Position var1, Position var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public GeodesicString createGeodesicString(List var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Arc createArc(Position var1, Position var2, Position var3) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Arc createArc(Position var1, Position var2, double var3, double[] var5) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public ArcString createArcString(List var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public ArcByBulge createArcByBulge(Position var1, Position var2, double var3, double[] var5) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public ArcStringByBulge createArcStringByBulge(List var1, double[] var2, List var3) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public BSplineCurve createBSplineCurve(int var1, PointArray var2, List var3, KnotType var4) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public BSplineSurface createBSplineSurface(List var1, int[] var2, List[] var3, KnotType var4) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Polygon createPolygon(SurfaceBoundary var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Polygon createPolygon(SurfaceBoundary var1, Surface var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Tin createTin(Set var1, Set var2, Set var3, double var4) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public PolyhedralSurface createPolyhedralSurface(List var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public MultiPrimitive createMultiPrimitive();
}

