/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.FieldReferenceMatch;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.LocalVariableDeclarationMatch;
import org.eclipse.jdt.core.search.LocalVariableReferenceMatch;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.PackageDeclarationMatch;
import org.eclipse.jdt.core.search.PackageReferenceMatch;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.core.search.TypeParameterDeclarationMatch;
import org.eclipse.jdt.core.search.TypeParameterReferenceMatch;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfIntValues;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.IndexSelector;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.matching.AndPattern;
import org.eclipse.jdt.internal.core.search.matching.ClassFileMatchLocator;
import org.eclipse.jdt.internal.core.search.matching.InternalSearchPattern;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchNameEnvironment;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocatorParser;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PackageDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatchSet;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.eclipse.jdt.internal.core.util.HandleFactory;
import org.eclipse.jdt.internal.core.util.SimpleSet;
import org.eclipse.jdt.internal.core.util.Util;

public class MatchLocator
implements ITypeRequestor {
    public static final int MAX_AT_ONCE = 400;
    public SearchPattern pattern;
    public PatternLocator patternLocator;
    public int matchContainer;
    public SearchRequestor requestor;
    public IJavaSearchScope scope;
    public IProgressMonitor progressMonitor;
    public ICompilationUnit[] workingCopies;
    public HandleFactory handleFactory;
    public char[][][] allSuperTypeNames;
    public MatchLocatorParser parser;
    private Parser basicParser;
    public INameEnvironment nameEnvironment;
    public NameLookup nameLookup;
    public LookupEnvironment lookupEnvironment;
    public HierarchyResolver hierarchyResolver;
    public CompilerOptions options;
    public int numberOfMatches;
    public PossibleMatch[] matchesToProcess;
    public PossibleMatch currentPossibleMatch;
    public long resultCollectorTime = 0L;
    int progressStep;
    int progressWorked;
    CompilationUnitScope unitScope;
    SimpleLookupTable bindings;
    HashSet methodHandles;

    public static SearchDocument[] addWorkingCopies(InternalSearchPattern pattern, SearchDocument[] indexMatches, ICompilationUnit[] copies, SearchParticipant participant) {
        int remainingWorkingCopiesSize;
        HashMap workingCopyDocuments = MatchLocator.workingCopiesThatCanSeeFocus(copies, pattern.focus, pattern.isPolymorphicSearch(), participant);
        SearchDocument[] matches = null;
        int length = indexMatches.length;
        int i = 0;
        while (i < length) {
            SearchDocument workingCopyDocument;
            SearchDocument searchDocument = indexMatches[i];
            if (searchDocument.getParticipant() == participant && (workingCopyDocument = (SearchDocument)workingCopyDocuments.remove(searchDocument.getPath())) != null) {
                if (matches == null) {
                    matches = new SearchDocument[length];
                    System.arraycopy(indexMatches, 0, matches, 0, length);
                }
                matches[i] = workingCopyDocument;
            }
            ++i;
        }
        if (matches == null) {
            matches = indexMatches;
        }
        if ((remainingWorkingCopiesSize = workingCopyDocuments.size()) != 0) {
            SearchDocument[] searchDocumentArray = matches;
            matches = new SearchDocument[length + remainingWorkingCopiesSize];
            System.arraycopy(searchDocumentArray, 0, matches, 0, length);
            Iterator iterator = workingCopyDocuments.values().iterator();
            int index = length;
            while (iterator.hasNext()) {
                matches[index++] = (SearchDocument)iterator.next();
            }
        }
        return matches;
    }

    public static void setFocus(InternalSearchPattern pattern, IJavaElement focus) {
        pattern.focus = focus;
    }

    private static HashMap workingCopiesThatCanSeeFocus(ICompilationUnit[] copies, IJavaElement focus, boolean isPolymorphicSearch, SearchParticipant participant) {
        if (copies == null) {
            return new HashMap();
        }
        if (focus != null) {
            while (!(focus instanceof IJavaProject) && !(focus instanceof JarPackageFragmentRoot)) {
                focus = focus.getParent();
            }
        }
        HashMap<String, WorkingCopyDocument> result = new HashMap<String, WorkingCopyDocument>();
        int i = 0;
        int length = copies.length;
        while (i < length) {
            ICompilationUnit workingCopy = copies[i];
            IPath projectOrJar = MatchLocator.getProjectOrJar(workingCopy).getPath();
            if (focus == null || IndexSelector.canSeeFocus(focus, isPolymorphicSearch, projectOrJar)) {
                result.put(workingCopy.getPath().toString(), new WorkingCopyDocument(workingCopy, participant));
            }
            ++i;
        }
        return result;
    }

    public static ClassFileReader classFileReader(IType type) {
        IClassFile classFile = type.getClassFile();
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        if (classFile.isOpen()) {
            return (ClassFileReader)manager.getInfo(type);
        }
        PackageFragment pkg = (PackageFragment)type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            IPath zipPath;
            if (!root.isArchive()) {
                return ClassFileReader.read(type.getResource().getLocation().toOSString());
            }
            IPath iPath = zipPath = root.isExternal() ? root.getPath() : root.getResource().getLocation();
            if (zipPath == null) {
                return null;
            }
            ZipFile zipFile = null;
            try {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [MatchLocator.classFileReader()] Creating ZipFile on " + zipPath);
                }
                zipFile = manager.getZipFile(zipPath);
                String classFileName = classFile.getElementName();
                String path = Util.concatWith(pkg.names, classFileName, '/');
                ClassFileReader classFileReader = ClassFileReader.read(zipFile, path);
                Object var9_10 = null;
                manager.closeZipFile(zipFile);
                return classFileReader;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                manager.closeZipFile(zipFile);
                throw throwable;
            }
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public static SearchPattern createAndPattern(final SearchPattern leftPattern, final SearchPattern rightPattern) {
        return new AndPattern(0, 0){
            SearchPattern current;
            {
                this.current = searchPattern;
            }

            public SearchPattern currentPattern() {
                return this.current;
            }

            protected boolean hasNextQuery() {
                if (this.current == leftPattern) {
                    this.current = rightPattern;
                    return true;
                }
                return false;
            }

            protected void resetQuery() {
                this.current = leftPattern;
            }
        };
    }

    public static void findIndexMatches(InternalSearchPattern pattern, Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor monitor) throws IOException {
        pattern.findIndexMatches(index, requestor, participant, scope, monitor);
    }

    public static IJavaElement getProjectOrJar(IJavaElement element) {
        while (!(element instanceof IJavaProject) && !(element instanceof JarPackageFragmentRoot)) {
            element = element.getParent();
        }
        return element;
    }

    public static boolean isPolymorphicSearch(InternalSearchPattern pattern) {
        return pattern.isPolymorphicSearch();
    }

    public static IJavaElement projectOrJarFocus(InternalSearchPattern pattern) {
        return pattern == null || pattern.focus == null ? null : MatchLocator.getProjectOrJar(pattern.focus);
    }

    public MatchLocator(SearchPattern pattern, SearchRequestor requestor, IJavaSearchScope scope, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.patternLocator = PatternLocator.patternLocator(this.pattern);
        this.matchContainer = this.patternLocator.matchContainer();
        this.requestor = requestor;
        this.scope = scope;
        this.progressMonitor = progressMonitor;
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding, accessRestriction);
    }

    public void accept(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        block2: {
            CompilationResult unitResult = new CompilationResult(sourceUnit, 1, 1, this.options.maxProblemsPerUnit);
            try {
                CompilationUnitDeclaration parsedUnit = this.basicParser().dietParse(sourceUnit, unitResult);
                this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
                this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
            }
            catch (AbortCompilationUnit e) {
                if (unitResult.compilationUnit == sourceUnit) break block2;
                throw e;
            }
        }
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        if (sourceType instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)sourceType;
            IType type = elementInfo.getHandle();
            org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)type.getCompilationUnit());
            this.accept(sourceUnit, accessRestriction);
        } else {
            CompilationResult result = new CompilationResult(sourceType.getFileName(), 1, 1, 0);
            CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 15, this.lookupEnvironment.problemReporter, result);
            this.lookupEnvironment.buildTypeBindings(unit, accessRestriction);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    protected Parser basicParser() {
        if (this.basicParser == null) {
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
            this.basicParser = new Parser(problemReporter, false);
            this.basicParser.reportOnlyOneSyntaxError = true;
        }
        return this.basicParser;
    }

    protected BinaryTypeBinding cacheBinaryType(IType type, IBinaryType binaryType) throws JavaModelException {
        char[][] compoundName;
        ReferenceBinding referenceBinding;
        BinaryTypeBinding binding;
        IType enclosingType = type.getDeclaringType();
        if (enclosingType != null) {
            this.cacheBinaryType(enclosingType, null);
        }
        if (binaryType == null) {
            ClassFile classFile = (ClassFile)type.getClassFile();
            try {
                binaryType = this.getBinaryInfo(classFile, classFile.getResource());
            }
            catch (CoreException e) {
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        }
        if ((binding = this.lookupEnvironment.cacheBinaryType(binaryType, null)) == null && (referenceBinding = this.lookupEnvironment.getCachedType(compoundName = CharOperation.splitOn('.', type.getFullyQualifiedName().toCharArray()))) != null && referenceBinding instanceof BinaryTypeBinding) {
            binding = (BinaryTypeBinding)referenceBinding;
        }
        return binding;
    }

    protected char[][][] computeSuperTypeNames(IType focusType) {
        String fullyQualifiedName = focusType.getFullyQualifiedName();
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        char[] qualification = lastDot == -1 ? CharOperation.NO_CHAR : fullyQualifiedName.substring(0, lastDot).toCharArray();
        char[] simpleName = focusType.getElementName().toCharArray();
        SuperTypeNamesCollector superTypeNamesCollector = new SuperTypeNamesCollector(this.pattern, simpleName, qualification, new MatchLocator(this.pattern, this.requestor, this.scope, this.progressMonitor), focusType, this.progressMonitor);
        try {
            this.allSuperTypeNames = superTypeNamesCollector.collect();
        }
        catch (JavaModelException javaModelException) {}
        return this.allSuperTypeNames;
    }

    protected IJavaElement createHandle(AbstractMethodDeclaration method, IJavaElement parent) {
        int argCount;
        if (!(parent instanceof IType)) {
            return parent;
        }
        IType type = (IType)parent;
        Argument[] arguments = method.arguments;
        int n = argCount = arguments == null ? 0 : arguments.length;
        if (type.isBinary()) {
            IBinaryMethod[] methods;
            ClassFileReader reader = MatchLocator.classFileReader(type);
            if (reader != null && (methods = reader.getMethods()) != null) {
                boolean firstIsSynthetic = false;
                if (reader.isMember() && method.isConstructor() && !Flags.isStatic(reader.getModifiers())) {
                    firstIsSynthetic = true;
                    ++argCount;
                }
                int i = 0;
                int methodsLength = methods.length;
                while (i < methodsLength) {
                    block14: {
                        char[] selector;
                        IBinaryMethod binaryMethod = methods[i];
                        char[] cArray = selector = binaryMethod.isConstructor() ? type.getElementName().toCharArray() : binaryMethod.getSelector();
                        if (CharOperation.equals(selector, method.selector)) {
                            char[][] parameterTypes;
                            char[] signature = binaryMethod.getGenericSignature();
                            if (signature == null) {
                                signature = binaryMethod.getMethodDescriptor();
                            }
                            if (argCount == (parameterTypes = Signature.getParameterTypes(signature)).length) {
                                int j = 0;
                                while (j < argCount) {
                                    char[] typeName;
                                    if (j == 0 && firstIsSynthetic) {
                                        typeName = type.getDeclaringType().getFullyQualifiedName().toCharArray();
                                    } else {
                                        TypeReference typeRef = arguments[firstIsSynthetic ? j - 1 : j].type;
                                        typeName = CharOperation.concatWith(typeRef.getTypeName(), '.');
                                        int k = 0;
                                        int dim = typeRef.dimensions();
                                        while (k < dim) {
                                            typeName = CharOperation.concat(typeName, new char[]{'[', ']'});
                                            ++k;
                                        }
                                    }
                                    char[] parameterTypeName = ClassFileMatchLocator.convertClassFileFormat(parameterTypes[j]);
                                    if (CharOperation.endsWith(Signature.toCharArray(Signature.getTypeErasure(parameterTypeName)), typeName)) {
                                        parameterTypes[j] = parameterTypeName;
                                        ++j;
                                        continue;
                                    }
                                    break block14;
                                }
                                return this.createMethodHandle(type, new String(selector), CharOperation.toStrings(parameterTypes));
                            }
                        }
                    }
                    ++i;
                }
            }
            return null;
        }
        String[] parameterTypeSignatures = new String[argCount];
        int i = 0;
        while (i < argCount) {
            TypeReference typeRef = arguments[i].type;
            char[] typeName = CharOperation.concatWith(typeRef.getParameterizedTypeName(), '.');
            parameterTypeSignatures[i] = Signature.createTypeSignature(typeName, false);
            ++i;
        }
        return this.createMethodHandle(type, new String(method.selector), parameterTypeSignatures);
    }

    private IJavaElement createMethodHandle(IType type, String methodName, String[] parameterTypeSignatures) {
        IMethod methodHandle = type.getMethod(methodName, parameterTypeSignatures);
        if (methodHandle instanceof SourceMethod) {
            while (this.methodHandles.contains(methodHandle)) {
                ++((SourceMethod)methodHandle).occurrenceCount;
            }
        }
        this.methodHandles.add(methodHandle);
        return methodHandle;
    }

    protected IJavaElement createHandle(FieldDeclaration fieldDeclaration, TypeDeclaration typeDeclaration, IJavaElement parent) {
        if (!(parent instanceof IType)) {
            return parent;
        }
        IType type = (IType)parent;
        switch (fieldDeclaration.getKind()) {
            case 1: 
            case 3: {
                return ((IType)parent).getField(new String(fieldDeclaration.name));
            }
        }
        if (type.isBinary()) {
            return type;
        }
        int occurrenceCount = 0;
        FieldDeclaration[] fields = typeDeclaration.fields;
        int i = 0;
        int length = fields.length;
        while (i < length) {
            if (fields[i].getKind() == 2) {
                ++occurrenceCount;
                if (fields[i].equals(fieldDeclaration)) break;
            }
            ++i;
        }
        return ((IType)parent).getInitializer(occurrenceCount);
    }

    protected boolean createHierarchyResolver(IType focusType, PossibleMatch[] possibleMatches) {
        char[][] compoundName = CharOperation.splitOn('.', focusType.getFullyQualifiedName().toCharArray());
        boolean isPossibleMatch = false;
        int i = 0;
        int length = possibleMatches.length;
        while (i < length) {
            if (CharOperation.equals(possibleMatches[i].compoundName, compoundName)) {
                isPossibleMatch = true;
                break;
            }
            ++i;
        }
        if (!isPossibleMatch) {
            if (focusType.isBinary()) {
                try {
                    this.cacheBinaryType(focusType, null);
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            } else {
                this.accept((org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)focusType.getCompilationUnit()), null);
            }
        }
        this.hierarchyResolver = new HierarchyResolver(this.lookupEnvironment, null);
        ReferenceBinding binding = this.hierarchyResolver.setFocusType(compoundName);
        return binding != null && binding.isValidBinding() && (binding.tagBits & 0x8000L) == 0L;
    }

    protected IJavaElement createImportHandle(ImportReference importRef) {
        Openable openable;
        char[] importName = CharOperation.concatWith(importRef.getImportName(), '.');
        if (importRef.onDemand) {
            importName = CharOperation.concat(importName, ".*".toCharArray());
        }
        if ((openable = this.currentPossibleMatch.openable) instanceof CompilationUnit) {
            return ((CompilationUnit)openable).getImport(new String(importName));
        }
        IType binaryType = ((ClassFile)openable).getType();
        String typeName = binaryType.getElementName();
        int lastDollar = typeName.lastIndexOf(36);
        if (lastDollar == -1) {
            return binaryType;
        }
        return this.createTypeHandle(typeName.substring(0, lastDollar));
    }

    protected IJavaElement createPackageDeclarationHandle(CompilationUnitDeclaration unit) {
        if (unit.isPackageInfo()) {
            char[] packName = CharOperation.concatWith(unit.currentPackage.getImportName(), '.');
            Openable openable = this.currentPossibleMatch.openable;
            if (openable instanceof CompilationUnit) {
                return ((CompilationUnit)openable).getPackageDeclaration(new String(packName));
            }
        }
        return this.createTypeHandle(new String(unit.getMainTypeName()));
    }

    protected IType createTypeHandle(String simpleTypeName) {
        Openable openable = this.currentPossibleMatch.openable;
        if (openable instanceof CompilationUnit) {
            return ((CompilationUnit)openable).getType(simpleTypeName);
        }
        IType binaryType = ((ClassFile)openable).getType();
        if (simpleTypeName.equals(binaryType.getTypeQualifiedName())) {
            return binaryType;
        }
        try {
            IClassFile classFile = binaryType.getPackageFragment().getClassFile(String.valueOf(simpleTypeName) + ".class");
            return classFile.getType();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected boolean encloses(IJavaElement element) {
        return element != null && this.scope.encloses(element);
    }

    private long findLastTypeArgumentInfo(TypeReference typeRef) {
        TypeReference lastTypeArgument = typeRef;
        int depth = 0;
        while (true) {
            int i;
            TypeReference[] lastTypeArguments = null;
            if (lastTypeArgument instanceof ParameterizedQualifiedTypeReference) {
                ParameterizedQualifiedTypeReference pqtRef = (ParameterizedQualifiedTypeReference)lastTypeArgument;
                i = pqtRef.typeArguments.length - 1;
                while (i >= 0 && lastTypeArguments == null) {
                    lastTypeArguments = pqtRef.typeArguments[i];
                    --i;
                }
            }
            TypeReference last = null;
            if (lastTypeArgument instanceof ParameterizedSingleTypeReference || lastTypeArguments != null) {
                if (lastTypeArguments == null) {
                    lastTypeArguments = ((ParameterizedSingleTypeReference)lastTypeArgument).typeArguments;
                }
                i = lastTypeArguments.length - 1;
                while (i >= 0 && last == null) {
                    last = lastTypeArguments[i];
                    ++i;
                }
            }
            if (last == null) break;
            ++depth;
            lastTypeArgument = last;
        }
        return ((long)depth << 32) + (long)lastTypeArgument.sourceEnd;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IBinaryType getBinaryInfo(ClassFile classFile, IResource resource) throws CoreException {
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (classFile.isOpen()) {
            return (IBinaryType)binaryType.getElementInfo();
        }
        try {
            ClassFileReader info;
            block9: {
                PackageFragment pkg = (PackageFragment)classFile.getParent();
                PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
                if (root.isArchive()) {
                    String classFileName = classFile.getElementName();
                    String classFilePath = Util.concatWith(pkg.names, classFileName, '/');
                    ZipFile zipFile = null;
                    try {
                        zipFile = ((JarPackageFragmentRoot)root).getJar();
                        info = ClassFileReader.read(zipFile, classFilePath);
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                        throw throwable;
                    }
                    {
                        Object var10_14 = null;
                        JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                        break block9;
                    }
                }
                String osPath = resource.getLocation().toOSString();
                info = ClassFileReader.read(osPath);
            }
            if (info == null) {
                throw binaryType.newNotPresentException();
            }
            return info;
        }
        catch (ClassFormatException classFormatException) {
            return null;
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    protected IType getFocusType() {
        return this.scope instanceof HierarchyScope ? ((HierarchyScope)this.scope).focusType : null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getMethodBodies(CompilationUnitDeclaration unit, MatchingNodeSet nodeSet) {
        if (unit.ignoreMethodBodies) {
            unit.ignoreFurtherInvestigation = true;
            return;
        }
        int[] oldLineEnds = this.parser.scanner.lineEnds;
        int oldLinePtr = this.parser.scanner.linePtr;
        try {
            CompilationResult compilationResult = unit.compilationResult;
            this.parser.scanner.setSource(compilationResult);
            if (this.parser.javadocParser.checkDocComment) {
                char[] contents = compilationResult.compilationUnit.getContents();
                this.parser.javadocParser.scanner.setSource(contents);
            }
            this.parser.nodeSet = nodeSet;
            this.parser.parseBodies(unit);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.parser.nodeSet = null;
            this.parser.scanner.lineEnds = oldLineEnds;
            this.parser.scanner.linePtr = oldLinePtr;
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.parser.nodeSet = null;
            this.parser.scanner.lineEnds = oldLineEnds;
            this.parser.scanner.linePtr = oldLinePtr;
            return;
        }
    }

    protected TypeBinding getType(Object typeKey, char[] typeName) {
        if (this.unitScope == null || typeName == null || typeName.length == 0) {
            return null;
        }
        Binding binding = (Binding)this.bindings.get(typeKey);
        if (binding != null) {
            if (binding instanceof TypeBinding && binding.isValidBinding()) {
                return (TypeBinding)binding;
            }
            return null;
        }
        char[][] compoundName = CharOperation.splitOn('.', typeName);
        TypeBinding typeBinding = this.unitScope.getType(compoundName, compoundName.length);
        this.bindings.put(typeKey, typeBinding);
        return typeBinding.isValidBinding() ? typeBinding : null;
    }

    public MethodBinding getMethodBinding(MethodPattern methodPattern) {
        TypeBinding declaringTypeBinding;
        if (this.unitScope == null) {
            return null;
        }
        Binding binding = (Binding)this.bindings.get(methodPattern);
        if (binding != null) {
            if (binding instanceof MethodBinding && binding.isValidBinding()) {
                return (MethodBinding)binding;
            }
            return null;
        }
        char[] typeName = PatternLocator.qualifiedPattern(methodPattern.declaringSimpleName, methodPattern.declaringQualification);
        if (typeName == null) {
            if (methodPattern.declaringType == null) {
                return null;
            }
            typeName = methodPattern.declaringType.getFullyQualifiedName().toCharArray();
        }
        if ((declaringTypeBinding = this.getType(typeName, typeName)) != null) {
            if (declaringTypeBinding.isArrayType()) {
                declaringTypeBinding = declaringTypeBinding.leafComponentType();
            }
            if (!declaringTypeBinding.isBaseType()) {
                char[][] parameterTypes = methodPattern.parameterSimpleNames;
                if (parameterTypes == null) {
                    return null;
                }
                int paramTypeslength = parameterTypes.length;
                ReferenceBinding referenceBinding = (ReferenceBinding)declaringTypeBinding;
                MethodBinding[] methods = referenceBinding.getMethods(methodPattern.selector);
                int methodsLength = methods.length;
                TypeVariableBinding[] refTypeVariables = referenceBinding.typeVariables();
                int typeVarLength = refTypeVariables == null ? 0 : refTypeVariables.length;
                int i = 0;
                while (i < methodsLength) {
                    TypeBinding[] methodParameters = methods[i].parameters;
                    int paramLength = methodParameters == null ? 0 : methodParameters.length;
                    TypeVariableBinding[] methodTypeVariables = methods[i].typeVariables;
                    int methTypeVarLength = methodTypeVariables == null ? 0 : methodTypeVariables.length;
                    boolean found = false;
                    if (paramLength == paramTypeslength) {
                        int p = 0;
                        while (p < paramLength) {
                            if (CharOperation.equals(methodParameters[p].sourceName(), parameterTypes[p])) {
                                found = true;
                            } else {
                                found = false;
                                int v = 0;
                                while (v < typeVarLength) {
                                    if (!CharOperation.equals(refTypeVariables[v].sourceName, parameterTypes[p])) {
                                        found = false;
                                        break;
                                    }
                                    found = true;
                                    ++v;
                                }
                                if (!found) {
                                    v = 0;
                                    while (v < methTypeVarLength) {
                                        if (!CharOperation.equals(methodTypeVariables[v].sourceName, parameterTypes[p])) {
                                            found = false;
                                            break;
                                        }
                                        found = true;
                                        ++v;
                                    }
                                }
                                if (!found) break;
                            }
                            ++p;
                        }
                    }
                    if (found) {
                        this.bindings.put(methodPattern, methods[i]);
                        return methods[i];
                    }
                    ++i;
                }
            }
        }
        this.bindings.put(methodPattern, new ProblemMethodBinding(methodPattern.selector, null, 1));
        return null;
    }

    protected boolean hasAlreadyDefinedType(CompilationUnitDeclaration parsedUnit) {
        CompilationResult result = parsedUnit.compilationResult;
        if (result == null) {
            return false;
        }
        int i = 0;
        while (i < result.problemCount) {
            if (result.problems[i].getID() == 16777539) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initialize(JavaProject project, int possibleMatchSize) throws JavaModelException {
        if (this.nameEnvironment != null && possibleMatchSize != 1) {
            this.nameEnvironment.cleanup();
        }
        SearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(this.workingCopies);
        this.nameEnvironment = possibleMatchSize == 1 ? searchableEnvironment : new JavaSearchNameEnvironment(project, this.workingCopies);
        Map map = project.getOptions(true);
        map.put("org.eclipse.jdt.core.compiler.taskTags", "");
        this.options = new CompilerOptions(map);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
        this.lookupEnvironment = new LookupEnvironment(this, this.options, problemReporter, this.nameEnvironment);
        this.parser = MatchLocatorParser.createParser(problemReporter, this);
        this.nameLookup = searchableEnvironment.nameLookup;
        this.numberOfMatches = 0;
        this.matchesToProcess = new PossibleMatch[possibleMatchSize];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void locateMatches(JavaProject javaProject, PossibleMatch[] possibleMatches, int start, int length) throws CoreException {
        boolean bindingsWereCreated;
        boolean mustResolve;
        block33: {
            boolean mustResolvePattern;
            this.initialize(javaProject, length);
            mustResolve = mustResolvePattern = this.pattern.mustResolve;
            this.patternLocator.mayBeGeneric = this.options.sourceLevel >= 0x310000L;
            bindingsWereCreated = mustResolve;
            try {
                IType focusType;
                int i = start;
                int maxUnits = start + length;
                while (true) {
                    block34: {
                        Object var11_14;
                        if (i >= maxUnits) {
                            if (mustResolve) {
                                this.lookupEnvironment.completeTypeBindings();
                            }
                            if ((focusType = this.getFocusType()) != null) break;
                            this.hierarchyResolver = null;
                            break block33;
                        }
                        PossibleMatch possibleMatch = possibleMatches[i];
                        try {
                            if (!this.parseAndBuildBindings(possibleMatch, mustResolvePattern)) {
                                var11_14 = null;
                                if (!possibleMatch.nodeSet.mustResolve) {
                                    possibleMatch.cleanUp();
                                }
                                break block34;
                            }
                            if (this.patternLocator.mayBeGeneric) {
                                if (!mustResolvePattern && !mustResolve) {
                                    bindingsWereCreated = mustResolve = possibleMatch.nodeSet.mustResolve;
                                }
                            } else {
                                possibleMatch.nodeSet.mustResolve = mustResolvePattern;
                            }
                            if (!possibleMatch.nodeSet.mustResolve) {
                                if (this.progressMonitor != null) {
                                    ++this.progressWorked;
                                    if (this.progressWorked % this.progressStep == 0) {
                                        this.progressMonitor.worked(this.progressStep);
                                    }
                                }
                                this.process(possibleMatch, bindingsWereCreated);
                                if (this.numberOfMatches > 0 && this.matchesToProcess[this.numberOfMatches - 1] == possibleMatch) {
                                    --this.numberOfMatches;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            var11_14 = null;
                            if (!possibleMatch.nodeSet.mustResolve) {
                                possibleMatch.cleanUp();
                            }
                            throw throwable;
                        }
                        {
                            var11_14 = null;
                            if (possibleMatch.nodeSet.mustResolve) break block34;
                            possibleMatch.cleanUp();
                        }
                    }
                    ++i;
                }
                if (!this.createHierarchyResolver(focusType, possibleMatches) && this.computeSuperTypeNames(focusType) == null) {
                    return;
                }
            }
            catch (AbortCompilation abortCompilation) {
                bindingsWereCreated = false;
            }
        }
        if (!mustResolve) {
            return;
        }
        int i = 0;
        while (true) {
            PossibleMatch possibleMatch;
            block35: {
                Object var10_13;
                if (i >= this.numberOfMatches) {
                    return;
                }
                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                possibleMatch = this.matchesToProcess[i];
                this.matchesToProcess[i] = null;
                try {
                    try {
                        this.process(possibleMatch, bindingsWereCreated);
                    }
                    catch (AbortCompilation abortCompilation) {
                        bindingsWereCreated = false;
                    }
                    catch (JavaModelException javaModelException) {
                        bindingsWereCreated = false;
                    }
                }
                catch (Throwable throwable) {
                    var10_13 = null;
                    if (this.progressMonitor != null) {
                        ++this.progressWorked;
                        if (this.progressWorked % this.progressStep == 0) {
                            this.progressMonitor.worked(this.progressStep);
                        }
                    }
                    if (this.options.verbose) {
                        System.out.println(Messages.bind(Messages.compilation_done, new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
                    }
                    possibleMatch.cleanUp();
                    throw throwable;
                }
                {
                    var10_13 = null;
                    if (this.progressMonitor == null) break block35;
                    ++this.progressWorked;
                    if (this.progressWorked % this.progressStep != 0) break block35;
                }
                this.progressMonitor.worked(this.progressStep);
            }
            if (this.options.verbose) {
                System.out.println(Messages.bind(Messages.compilation_done, new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
            }
            possibleMatch.cleanUp();
            ++i;
        }
    }

    protected void locateMatches(JavaProject javaProject, PossibleMatchSet matchSet, int expected) throws CoreException {
        PossibleMatch[] possibleMatches = matchSet.getPossibleMatches(javaProject.getPackageFragmentRoots());
        int length = possibleMatches.length;
        if (this.progressMonitor != null && expected > length) {
            this.progressWorked += expected - length;
            this.progressMonitor.worked(expected - length);
        }
        int index = 0;
        while (index < length) {
            int max = Math.min(400, length - index);
            this.locateMatches(javaProject, possibleMatches, index, max);
            index += max;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void locateMatches(SearchDocument[] searchDocuments) throws CoreException {
        docsLength = searchDocuments.length;
        if (BasicSearchEngine.VERBOSE) {
            System.out.println("Locating matches in documents [");
            i = 0;
            while (true) {
                if (i >= docsLength) {
                    System.out.println("]");
                    break;
                }
                System.out.println("\t" + searchDocuments[i]);
                ++i;
            }
        }
        n = docsLength < 1000 ? Math.min(Math.max(docsLength / 200 + 1, 2), 4) : 5 * (docsLength / 1000);
        this.progressStep = docsLength < n ? 1 : docsLength / n;
        this.progressWorked = 0;
        copies = new ArrayList<ICompilationUnit>();
        i = 0;
        while (true) {
            if (i >= docsLength) {
                copiesLength = copies.size();
                this.workingCopies = new ICompilationUnit[copiesLength];
                copies.toArray(this.workingCopies);
                manager = JavaModelManager.getJavaModelManager();
                this.bindings = new SimpleLookupTable();
                ** try [egrp 0[TRYBLOCK] [2 : 213->674)] { 
lbl26:
                // 1 sources

                break;
            }
            document = searchDocuments[i];
            if (document instanceof WorkingCopyDocument) {
                copies.add(((WorkingCopyDocument)document).workingCopy);
            }
            ++i;
        }
        {
            block31: {
                manager.cacheZipFiles();
                if (this.handleFactory == null) {
                    this.handleFactory = new HandleFactory();
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.beginTask("", searchDocuments.length);
                }
                this.patternLocator.initializePolymorphicSearch(this);
                previousJavaProject = null;
                matchSet = new PossibleMatchSet();
                Util.sort((Object[])searchDocuments, new Util.Comparer(){

                    public int compare(Object a, Object b) {
                        return ((SearchDocument)a).getPath().compareTo(((SearchDocument)b).getPath());
                    }
                });
                displayed = 0;
                i = 0;
                while (true) {
                    block33: {
                        block34: {
                            block32: {
                                if (i >= docsLength) {
                                    if (previousJavaProject != null) {
                                        ** try [egrp 2[TRYBLOCK] [1 : 639->654)] { 
lbl48:
                                        // 1 sources

                                        break;
                                    }
                                    break block31;
                                }
                                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                searchDocument = searchDocuments[i];
                                pathString = searchDocument.getPath();
                                if (i <= 0 || !pathString.equals(searchDocuments[i - 1].getPath())) break block32;
                                if (this.progressMonitor != null) {
                                    ++this.progressWorked;
                                    if (this.progressWorked % this.progressStep == 0) {
                                        this.progressMonitor.worked(this.progressStep);
                                    }
                                }
                                ++displayed;
                                break block33;
                            }
                            workingCopy = null;
                            if (!(searchDocument instanceof WorkingCopyDocument)) break block34;
                            workingCopy = ((WorkingCopyDocument)searchDocument).workingCopy;
                            openable = (Openable)workingCopy;
                            ** GOTO lbl-1000
                        }
                        openable = this.handleFactory.createOpenable(pathString, this.scope);
                        if (openable == null) {
                            if (this.progressMonitor != null) {
                                ++this.progressWorked;
                                if (this.progressWorked % this.progressStep == 0) {
                                    this.progressMonitor.worked(this.progressStep);
                                }
                            }
                            ++displayed;
                        } else lbl-1000:
                        // 2 sources

                        {
                            resource = null;
                            javaProject = (JavaProject)openable.getJavaProject();
                            v0 = resource = workingCopy != null ? workingCopy.getResource() : openable.getResource();
                            if (resource == null) {
                                resource = javaProject.getProject();
                            }
                            if (!javaProject.equals(previousJavaProject)) {
                                if (previousJavaProject != null) {
                                    try {
                                        this.locateMatches(previousJavaProject, matchSet, i - displayed);
                                        displayed = i;
                                    }
                                    catch (JavaModelException v1) {}
                                    matchSet.reset();
                                }
                                previousJavaProject = javaProject;
                            }
                            matchSet.add(new PossibleMatch(this, resource, openable, searchDocument, this.pattern.mustResolve));
                        }
                    }
                    ++i;
                }
                {
                    this.locateMatches(previousJavaProject, matchSet, docsLength - displayed);
                }
lbl96:
                // 1 sources

                catch (JavaModelException v2) {}
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
        }
lbl101:
        // 1 sources

        catch (Throwable var18_17) {
            var17_18 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            this.bindings = null;
            this.patternLocator.clear();
            throw var18_17;
        }
        {
            var17_19 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            this.bindings = null;
            this.patternLocator.clear();
            return;
        }
    }

    public void locatePackageDeclarations(SearchParticipant participant) throws CoreException {
        this.locatePackageDeclarations(this.pattern, participant);
    }

    protected void locatePackageDeclarations(SearchPattern searchPattern, SearchParticipant participant) throws CoreException {
        block22: {
            block21: {
                if (!(searchPattern instanceof OrPattern)) break block21;
                SearchPattern[] patterns = ((OrPattern)searchPattern).patterns;
                int i = 0;
                int length = patterns.length;
                while (i < length) {
                    this.locatePackageDeclarations(patterns[i], participant);
                    ++i;
                }
                break block22;
            }
            if (!(searchPattern instanceof PackageDeclarationPattern)) break block22;
            IJavaElement focus = searchPattern.focus;
            if (focus != null) {
                SearchDocument document = participant.getDocument(focus.getPath().toString());
                this.currentPossibleMatch = new PossibleMatch(this, focus.getResource(), null, document, searchPattern.mustResolve);
                if (this.encloses(focus)) {
                    SearchMatch match = this.newDeclarationMatch(focus.getAncestor(4), null, 0, -1, -1);
                    this.report(match);
                }
                return;
            }
            PackageDeclarationPattern pkgPattern = (PackageDeclarationPattern)searchPattern;
            IJavaProject[] projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                block18: {
                    IJavaProject javaProject = projects[i];
                    IPackageFragmentRoot[] roots = null;
                    try {
                        roots = javaProject.getPackageFragmentRoots();
                    }
                    catch (JavaModelException javaModelException) {
                        break block18;
                    }
                    int j = 0;
                    int rootsLength = roots.length;
                    while (j < rootsLength) {
                        block19: {
                            IJavaElement[] pkgs = null;
                            try {
                                pkgs = roots[j].getChildren();
                            }
                            catch (JavaModelException javaModelException) {
                                break block19;
                            }
                            int k = 0;
                            int pksLength = pkgs.length;
                            while (k < pksLength) {
                                block20: {
                                    IPackageFragment pkg = (IPackageFragment)pkgs[k];
                                    IJavaElement[] children = null;
                                    try {
                                        children = pkg.getChildren();
                                    }
                                    catch (JavaModelException javaModelException) {
                                        break block20;
                                    }
                                    if (children.length > 0 && pkgPattern.matchesName(pkgPattern.pkgName, pkg.getElementName().toCharArray())) {
                                        IResource resource = pkg.getResource();
                                        if (resource == null) {
                                            resource = javaProject.getProject();
                                        }
                                        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
                                        this.currentPossibleMatch = new PossibleMatch(this, resource, null, document, searchPattern.mustResolve);
                                        try {
                                            if (this.encloses(pkg)) {
                                                SearchMatch match = this.newDeclarationMatch(pkg, null, 0, -1, -1);
                                                this.report(match);
                                            }
                                        }
                                        catch (JavaModelException e) {
                                            throw e;
                                        }
                                        catch (CoreException e) {
                                            throw new JavaModelException(e);
                                        }
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected IType lookupType(ReferenceBinding typeBinding) {
        IType type;
        if (typeBinding == null) {
            return null;
        }
        char[] packageName = typeBinding.qualifiedPackageName();
        IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
        char[] sourceName = typeBinding.qualifiedSourceName();
        String typeName = new String(sourceName);
        int acceptFlag = 0;
        if (typeBinding.isAnnotationType()) {
            acceptFlag = 16;
        } else if (typeBinding.isEnum()) {
            acceptFlag = 8;
        } else if (typeBinding.isInterface()) {
            acceptFlag = 4;
        } else if (typeBinding.isClass()) {
            acceptFlag = 2;
        }
        int i = 0;
        int length = pkgs == null ? 0 : pkgs.length;
        while (i < length) {
            type = this.nameLookup.findType(typeName, pkgs[i], false, acceptFlag);
            if (type != null) {
                return type;
            }
            ++i;
        }
        char[][] qualifiedName = CharOperation.splitOn('.', sourceName);
        length = qualifiedName.length;
        if (length == 0) {
            return null;
        }
        type = this.createTypeHandle(new String(qualifiedName[0]));
        if (type == null) {
            return null;
        }
        int i2 = 1;
        while (i2 < length) {
            if ((type = type.getType(new String(qualifiedName[i2]))) == null) {
                return null;
            }
            ++i2;
        }
        if (type.exists()) {
            return type;
        }
        return null;
    }

    public SearchMatch newDeclarationMatch(IJavaElement element, Binding binding, int accuracy, int offset, int length) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return this.newDeclarationMatch(element, binding, accuracy, offset, length, participant, resource);
    }

    public SearchMatch newDeclarationMatch(IJavaElement element, Binding binding, int accuracy, int offset, int length, SearchParticipant participant, IResource resource) {
        switch (element.getElementType()) {
            case 4: {
                return new PackageDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 7: {
                return new TypeDeclarationMatch(binding == null ? element : ((JavaElement)element).resolved(binding), accuracy, offset, length, participant, resource);
            }
            case 8: {
                return new FieldDeclarationMatch(binding == null ? element : ((JavaElement)element).resolved(binding), accuracy, offset, length, participant, resource);
            }
            case 9: {
                return new MethodDeclarationMatch(binding == null ? element : ((JavaElement)element).resolved(binding), accuracy, offset, length, participant, resource);
            }
            case 14: {
                return new LocalVariableDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 11: {
                return new PackageDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 15: {
                return new TypeParameterDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
        }
        return null;
    }

    public SearchMatch newFieldReferenceMatch(IJavaElement enclosingElement, Binding enclosingBinding, int accuracy, int offset, int length, ASTNode reference) {
        int bits = reference.bits;
        boolean isCoupoundAssigned = (bits & 0x10000) != 0;
        boolean isReadAccess = isCoupoundAssigned || (bits & 0x2000) == 0;
        boolean isWriteAccess = isCoupoundAssigned || (bits & 0x2000) != 0;
        boolean insideDocComment = (bits & 0x8000) != 0;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        if (enclosingBinding != null) {
            enclosingElement = ((JavaElement)enclosingElement).resolved(enclosingBinding);
        }
        return new FieldReferenceMatch(enclosingElement, accuracy, offset, length, isReadAccess, isWriteAccess, insideDocComment, participant, resource);
    }

    public SearchMatch newLocalVariableReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        int bits = reference.bits;
        boolean isCoupoundAssigned = (bits & 0x10000) != 0;
        boolean isReadAccess = isCoupoundAssigned || (bits & 0x2000) == 0;
        boolean isWriteAccess = isCoupoundAssigned || (bits & 0x2000) != 0;
        boolean insideDocComment = (bits & 0x8000) != 0;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new LocalVariableReferenceMatch(enclosingElement, accuracy, offset, length, isReadAccess, isWriteAccess, insideDocComment, participant, resource);
    }

    public SearchMatch newMethodReferenceMatch(IJavaElement enclosingElement, Binding enclosingBinding, int accuracy, int offset, int length, boolean isConstructor, boolean isSynthetic, ASTNode reference) {
        boolean insideDocComment;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean bl = insideDocComment = (reference.bits & 0x8000) != 0;
        if (enclosingBinding != null) {
            enclosingElement = ((JavaElement)enclosingElement).resolved(enclosingBinding);
        }
        return new MethodReferenceMatch(enclosingElement, accuracy, offset, length, isConstructor, isSynthetic, insideDocComment, participant, resource);
    }

    public SearchMatch newPackageReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean insideDocComment = (reference.bits & 0x8000) != 0;
        return new PackageReferenceMatch(enclosingElement, accuracy, offset, length, insideDocComment, participant, resource);
    }

    public SearchMatch newTypeParameterReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        int bits = reference.bits;
        boolean insideDocComment = (bits & 0x8000) != 0;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new TypeParameterReferenceMatch(enclosingElement, accuracy, offset, length, insideDocComment, participant, resource);
    }

    public SearchMatch newTypeReferenceMatch(IJavaElement enclosingElement, Binding enclosingBinding, int accuracy, int offset, int length, ASTNode reference) {
        boolean insideDocComment;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean bl = insideDocComment = (reference.bits & 0x8000) != 0;
        if (enclosingBinding != null) {
            enclosingElement = ((JavaElement)enclosingElement).resolved(enclosingBinding);
        }
        return new TypeReferenceMatch(enclosingElement, accuracy, offset, length, insideDocComment, participant, resource);
    }

    public SearchMatch newTypeReferenceMatch(IJavaElement enclosingElement, Binding enclosingBinding, int accuracy, ASTNode reference) {
        return this.newTypeReferenceMatch(enclosingElement, enclosingBinding, accuracy, reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1, reference);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean parseAndBuildBindings(PossibleMatch possibleMatch, boolean mustResolve) throws CoreException {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (BasicSearchEngine.VERBOSE) {
                System.out.println("Parsing " + possibleMatch.openable.toStringWithAncestors());
            }
            this.parser.nodeSet = possibleMatch.nodeSet;
            CompilationResult unitResult = new CompilationResult(possibleMatch, 1, 1, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration parsedUnit = this.parser.dietParse(possibleMatch, unitResult);
            if (parsedUnit != null) {
                if (!parsedUnit.isEmpty()) {
                    if (mustResolve) {
                        this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                    }
                    if (this.hasAlreadyDefinedType(parsedUnit)) {
                        Object var6_5 = null;
                        this.parser.nodeSet = null;
                        return false;
                    }
                    this.getMethodBodies(parsedUnit, possibleMatch.nodeSet);
                    if (this.patternLocator.mayBeGeneric && !mustResolve && possibleMatch.nodeSet.mustResolve) {
                        this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                    }
                }
                possibleMatch.parsedUnit = parsedUnit;
                int size = this.matchesToProcess.length;
                if (this.numberOfMatches == size) {
                    this.matchesToProcess = new PossibleMatch[size == 0 ? 1 : size * 2];
                    System.arraycopy(this.matchesToProcess, 0, this.matchesToProcess, 0, this.numberOfMatches);
                }
                this.matchesToProcess[this.numberOfMatches++] = possibleMatch;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.parser.nodeSet = null;
            throw throwable;
        }
        {
            Object var6_7 = null;
            this.parser.nodeSet = null;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process(PossibleMatch possibleMatch, boolean bindingsWereCreated) throws CoreException {
        block17: {
            block16: {
                this.currentPossibleMatch = possibleMatch;
                CompilationUnitDeclaration unit = possibleMatch.parsedUnit;
                try {
                    try {
                        boolean mustResolve;
                        if (unit.isEmpty()) {
                            ClassFile classFile;
                            IBinaryType info;
                            if (this.currentPossibleMatch.openable instanceof ClassFile && (info = this.getBinaryInfo(classFile = (ClassFile)this.currentPossibleMatch.openable, this.currentPossibleMatch.resource)) != null) {
                                new ClassFileMatchLocator().locateMatches(this, classFile, info);
                            }
                            Object var6_8 = null;
                            this.currentPossibleMatch = null;
                            return;
                        }
                        if (this.hasAlreadyDefinedType(unit)) {
                            break block16;
                        }
                        boolean bl = mustResolve = this.pattern.mustResolve || possibleMatch.nodeSet.mustResolve;
                        if (bindingsWereCreated && mustResolve) {
                            if (unit.types != null) {
                                if (BasicSearchEngine.VERBOSE) {
                                    System.out.println("Resolving " + this.currentPossibleMatch.openable.toStringWithAncestors());
                                }
                                this.reduceParseTree(unit);
                                if (unit.scope != null) {
                                    unit.scope.faultInTypes();
                                }
                                unit.resolve();
                            } else if (unit.isPackageInfo()) {
                                if (BasicSearchEngine.VERBOSE) {
                                    System.out.println("Resolving " + this.currentPossibleMatch.openable.toStringWithAncestors());
                                }
                                unit.resolve();
                            }
                        }
                        this.reportMatching(unit, mustResolve);
                        break block17;
                    }
                    catch (AbortCompilation e) {
                        this.reportMatching(unit, true);
                        if (!(e instanceof AbortCompilationUnit)) {
                            throw e;
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    this.currentPossibleMatch = null;
                    throw throwable;
                }
            }
            Object var6_9 = null;
            this.currentPossibleMatch = null;
            return;
        }
        Object var6_11 = null;
        this.currentPossibleMatch = null;
    }

    protected void purgeMethodStatements(TypeDeclaration type, boolean checkEachMethod) {
        TypeDeclaration[] memberTypes;
        checkEachMethod = checkEachMethod && this.currentPossibleMatch.nodeSet.hasPossibleNodes(type.declarationSourceStart, type.declarationSourceEnd);
        AbstractMethodDeclaration[] methods = type.methods;
        if (methods != null) {
            int length;
            int j;
            if (checkEachMethod) {
                j = 0;
                length = methods.length;
                while (j < length) {
                    AbstractMethodDeclaration method = methods[j];
                    if (!this.currentPossibleMatch.nodeSet.hasPossibleNodes(method.declarationSourceStart, method.declarationSourceEnd)) {
                        method.statements = null;
                        method.javadoc = null;
                    }
                    ++j;
                }
            } else {
                j = 0;
                length = methods.length;
                while (j < length) {
                    methods[j].statements = null;
                    methods[j].javadoc = null;
                    ++j;
                }
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int i = 0;
            int l = memberTypes.length;
            while (i < l) {
                this.purgeMethodStatements(memberTypes[i], checkEachMethod);
                ++i;
            }
        }
    }

    protected void reduceParseTree(CompilationUnitDeclaration unit) {
        TypeDeclaration[] types = unit.types;
        int i = 0;
        int l = types.length;
        while (i < l) {
            this.purgeMethodStatements(types[i], true);
            ++i;
        }
    }

    public SearchParticipant getParticipant() {
        return this.currentPossibleMatch.document.getParticipant();
    }

    protected void report(SearchMatch match) throws CoreException {
        long start = -1L;
        if (BasicSearchEngine.VERBOSE) {
            start = System.currentTimeMillis();
            System.out.println("Reporting match");
            System.out.println("\tResource: " + match.getResource());
            System.out.println("\tPositions: [offset=" + match.getOffset() + ", length=" + match.getLength() + "]");
            try {
                if (this.parser != null && match.getOffset() > 0 && match.getLength() > 0 && !(match.getElement() instanceof BinaryMember)) {
                    String selection = new String(this.parser.scanner.source, match.getOffset(), match.getLength());
                    System.out.println("\tSelection: -->" + selection + "<--");
                }
            }
            catch (Exception exception) {}
            try {
                JavaElement javaElement = (JavaElement)match.getElement();
                System.out.println("\tJava element: " + javaElement.toStringWithAncestors());
                if (!javaElement.exists()) {
                    System.out.println("\t\tWARNING: this element does NOT exist!");
                }
            }
            catch (Exception exception) {}
            System.out.println(match.getAccuracy() == 0 ? "\tAccuracy: EXACT_MATCH" : "\tAccuracy: POTENTIAL_MATCH");
            System.out.print("\tRule: ");
            if (match.isExact()) {
                System.out.println("EXACT");
            } else if (match.isEquivalent()) {
                System.out.println("EQUIVALENT");
            } else if (match.isErasure()) {
                System.out.println("ERASURE");
            } else {
                System.out.println("INVALID RULE");
            }
            System.out.println("\tRaw: " + match.isRaw());
        }
        this.requestor.acceptSearchMatch(match);
        if (BasicSearchEngine.VERBOSE) {
            this.resultCollectorTime += System.currentTimeMillis() - start;
        }
    }

    protected void reportAccurateTypeReference(SearchMatch match, ASTNode typeRef, char[] name) throws CoreException {
        if (match.getRule() == 0) {
            return;
        }
        if (!this.encloses((IJavaElement)match.getElement())) {
            return;
        }
        int sourceStart = typeRef.sourceStart;
        int sourceEnd = typeRef.sourceEnd;
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPossibleMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int token = -1;
        do {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {}
            if (token != 26 || !this.pattern.matchesName(name, scanner.getCurrentTokenSource())) continue;
            int length = scanner.currentPosition - currentPosition;
            match.setOffset(currentPosition);
            match.setLength(length);
            this.report(match);
            return;
        } while (token != 66);
        match.setOffset(sourceStart);
        match.setLength(sourceEnd - sourceStart + 1);
        this.report(match);
    }

    protected void reportAccurateParameterizedMethodReference(SearchMatch match, ASTNode statement, TypeReference[] typeArguments) throws CoreException {
        int start;
        block10: {
            if (match.getRule() == 0) {
                return;
            }
            if (!this.encloses((IJavaElement)match.getElement())) {
                return;
            }
            start = match.getOffset();
            if (typeArguments != null && typeArguments.length > 0) {
                boolean isErasureMatch;
                boolean bl = isErasureMatch = this.pattern instanceof OrPattern ? ((OrPattern)this.pattern).isErasureMatch() : ((JavaSearchPattern)this.pattern).isErasureMatch();
                if (!isErasureMatch) {
                    Scanner scanner = this.parser.scanner;
                    char[] source = this.currentPossibleMatch.getContents();
                    scanner.setSource(source);
                    start = typeArguments[0].sourceStart;
                    int end = statement.sourceEnd;
                    scanner.resetTo(start, end);
                    int lineStart = start;
                    try {
                        while (true) {
                            if (scanner.source[scanner.currentPosition] != '\n') {
                                --scanner.currentPosition;
                                if (scanner.currentPosition != 0) {
                                    continue;
                                }
                                break;
                            }
                            lineStart = scanner.currentPosition + 1;
                            scanner.resetTo(lineStart, end);
                            while (!scanner.atEnd()) {
                                if (scanner.getNextToken() != 7) continue;
                                start = scanner.getCurrentTokenStartPosition();
                                break block10;
                            }
                            scanner.currentPosition = end = lineStart - 2;
                        }
                    }
                    catch (InvalidInputException invalidInputException) {}
                }
            }
        }
        match.setOffset(start);
        match.setLength(statement.sourceEnd - start + 1);
        this.report(match);
    }

    /*
     * Unable to fully structure code
     */
    protected void reportAccurateParameterizedTypeReference(SearchMatch match, TypeReference typeRef, int index, TypeReference[] typeArguments) throws CoreException {
        block7: {
            block6: {
                block8: {
                    block9: {
                        if (match.getRule() == 0) {
                            return;
                        }
                        if (!this.encloses((IJavaElement)match.getElement())) {
                            return;
                        }
                        end = typeRef.sourceEnd;
                        if (typeArguments == null) break block7;
                        scanner = this.parser.scanner;
                        source = this.currentPossibleMatch.getContents();
                        scanner.setSource(source);
                        shouldMatchErasure = this.pattern instanceof OrPattern != false ? ((OrPattern)this.pattern).isErasureMatch() : ((JavaSearchPattern)this.pattern).isErasureMatch();
                        v0 = hasSignatures = this.pattern instanceof OrPattern != false ? ((OrPattern)this.pattern).hasSignatures() : ((JavaSearchPattern)this.pattern).hasSignatures();
                        if (!shouldMatchErasure && hasSignatures) break block8;
                        if (!(typeRef instanceof QualifiedTypeReference) || index < 0) break block9;
                        positions = ((QualifiedTypeReference)typeRef).sourcePositions;
                        end = (int)positions[index];
                        break block7;
                    }
                    if (!(typeRef instanceof ArrayTypeReference)) break block7;
                    end = ((ArrayTypeReference)typeRef).originalSourceEnd;
                    break block7;
                }
                scanner.resetTo(end, source.length - 1);
                depth = 0;
                i = typeArguments.length - 1;
                while (i >= 0) {
                    if (typeArguments[i] != null) {
                        lastTypeArgInfo = this.findLastTypeArgumentInfo(typeArguments[i]);
                        depth = (int)(lastTypeArgInfo >>> 32) + 1;
                        scanner.resetTo((int)lastTypeArgInfo + 1, scanner.eofPosition - 1);
                        break block6;
                    }
                    --i;
                }
                break block6;
                while (true) {
                    if (scanner.getNextChar() != 62) continue;
                    end = scanner.currentPosition - 1;
                    break;
                }
            }
            while (depth-- > 0) {
                if (!scanner.atEnd()) ** continue;
            }
        }
        match.setLength(end - match.getOffset() + 1);
        this.report(match);
    }

    protected void reportAccurateFieldReference(SearchMatch[] matches, QualifiedNameReference qNameRef) throws CoreException {
        int matchesLength = matches == null ? 0 : matches.length;
        int sourceStart = qNameRef.sourceStart;
        int sourceEnd = qNameRef.sourceEnd;
        char[][] tokens = qNameRef.tokens;
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPossibleMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int sourceLength = sourceEnd - sourceStart + 1;
        int refSourceStart = -1;
        int refSourceEnd = -1;
        int length = tokens.length;
        int token = -1;
        int previousValid = -1;
        int i = 0;
        int index = 0;
        do {
            SearchMatch match;
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {}
            if (token != 66) {
                char[] currentTokenSource = scanner.getCurrentTokenSource();
                boolean equals = false;
                while (i < length && !(equals = this.pattern.matchesName(tokens[i++], currentTokenSource))) {
                }
                if (equals && (previousValid == -1 || previousValid == i - 2)) {
                    previousValid = i - 1;
                    if (refSourceStart == -1) {
                        refSourceStart = currentPosition;
                    }
                    refSourceEnd = scanner.currentPosition - 1;
                } else {
                    i = 0;
                    refSourceStart = -1;
                    previousValid = -1;
                }
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {}
            }
            if ((match = matches[index]) != null && match.getRule() != 0) {
                if (!this.encloses((IJavaElement)match.getElement())) {
                    return;
                }
                if (refSourceStart != -1) {
                    match.setOffset(refSourceStart);
                    match.setLength(refSourceEnd - refSourceStart + 1);
                    this.report(match);
                } else {
                    match.setOffset(sourceStart);
                    match.setLength(sourceLength);
                    this.report(match);
                }
                i = 0;
            }
            refSourceStart = -1;
            previousValid = -1;
            if (index >= matchesLength - 1) continue;
            ++index;
        } while (token != 66);
    }

    protected void reportBinaryMemberDeclaration(IResource resource, IMember binaryMember, Binding binaryMemberBinding, IBinaryType info, int accuracy) throws CoreException {
        char[] contents;
        SourceMapper mapper;
        BinaryType type;
        String sourceFileName;
        ISourceRange range;
        ClassFile classFile = (ClassFile)binaryMember.getClassFile();
        ISourceRange iSourceRange = range = classFile.isOpen() ? binaryMember.getNameRange() : SourceMapper.fgUnknownRange;
        if (range.getOffset() == -1 && (sourceFileName = (type = (BinaryType)classFile.getType()).sourceFileName(info)) != null && (mapper = classFile.getSourceMapper()) != null && (contents = mapper.findSource(type, sourceFileName)) != null) {
            range = mapper.mapSource(type, contents, binaryMember);
        }
        if (resource == null) {
            resource = this.currentPossibleMatch.resource;
        }
        SearchMatch match = this.newDeclarationMatch(binaryMember, binaryMemberBinding, accuracy, range.getOffset(), range.getLength(), this.getParticipant(), resource);
        this.report(match);
    }

    protected void reportMatching(AbstractMethodDeclaration method, IJavaElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        ASTNode[] nodes;
        IJavaElement enclosingElement = null;
        if (accuracy > -1 && (enclosingElement = this.createHandle(method, parent)) != null) {
            int length;
            SearchMatch match;
            Scanner scanner = this.parser.scanner;
            int nameSourceStart = method.sourceStart;
            scanner.setSource(this.currentPossibleMatch.getContents());
            scanner.resetTo(nameSourceStart, method.sourceEnd);
            try {
                scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {}
            if (this.encloses(enclosingElement) && (match = this.patternLocator.newDeclarationMatch(method, enclosingElement, method.binding, accuracy, length = scanner.currentPosition - nameSourceStart, this)) != null) {
                this.report(match);
            }
        }
        if ((method.bits & 2) != 0) {
            if (enclosingElement == null) {
                enclosingElement = this.createHandle(method, parent);
            }
            LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, method.binding, nodeSet);
            try {
                method.traverse((ASTVisitor)localDeclarationVisitor, (ClassScope)null);
            }
            catch (WrappedCoreException e) {
                throw e.coreException;
            }
        }
        if (method.annotations != null) {
            if (enclosingElement == null) {
                enclosingElement = this.createHandle(method, parent);
            }
            this.reportMatching(method.annotations, enclosingElement, method.binding, nodeSet, true, true);
        }
        if (typeInHierarchy && (nodes = nodeSet.matchingNodes(method.declarationSourceStart, method.declarationSourceEnd)) != null) {
            int l;
            int i;
            if ((this.matchContainer & 4) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(method, parent);
                }
                if (this.encloses(enclosingElement)) {
                    i = 0;
                    l = nodes.length;
                    while (i < l) {
                        ASTNode node = nodes[i];
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                        this.patternLocator.matchReportReference(node, enclosingElement, method.binding, level, this);
                        ++i;
                    }
                    return;
                }
            }
            i = 0;
            l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey(nodes[i]);
                ++i;
            }
        }
    }

    protected void reportMatching(Annotation[] annotations, IJavaElement enclosingElement, Binding elementBinding, MatchingNodeSet nodeSet, boolean matchedContainer, boolean enclosesElement) throws CoreException {
        int i = 0;
        int al = annotations.length;
        while (i < al) {
            Annotation annotationType = annotations[i];
            TypeReference typeRef = annotationType.type;
            Integer level = (Integer)nodeSet.matchingNodes.removeKey(typeRef);
            if (level != null && matchedContainer) {
                this.patternLocator.matchReportReference(typeRef, enclosingElement, elementBinding, level, this);
            }
            MemberValuePair[] pairs = annotationType.memberValuePairs();
            int j = 0;
            int pl = pairs.length;
            while (j < pl) {
                MemberValuePair pair = pairs[j];
                level = (Integer)nodeSet.matchingNodes.removeKey(pair);
                if (level != null && enclosesElement) {
                    ASTNode reference = annotationType instanceof SingleMemberAnnotation ? annotationType : pair;
                    this.patternLocator.matchReportReference(reference, enclosingElement, pair.binding, level, this);
                }
                ++j;
            }
            ASTNode[] nodes = nodeSet.matchingNodes(annotationType.sourceStart, annotationType.declarationSourceEnd);
            if (nodes != null) {
                int j2;
                if (!matchedContainer) {
                    j2 = 0;
                    int nl = nodes.length;
                    while (j2 < nl) {
                        nodeSet.matchingNodes.removeKey(nodes[j2]);
                        ++j2;
                    }
                } else {
                    j2 = 0;
                    int nl = nodes.length;
                    while (j2 < nl) {
                        ASTNode node = nodes[j2];
                        level = (Integer)nodeSet.matchingNodes.removeKey(node);
                        if (enclosesElement) {
                            this.patternLocator.matchReportReference(node, enclosingElement, elementBinding, level, this);
                        }
                        ++j2;
                    }
                }
            }
            ++i;
        }
    }

    protected void reportMatching(CompilationUnitDeclaration unit, boolean mustResolve) throws CoreException {
        TypeDeclaration[] types;
        Integer level;
        ASTNode[] nodes;
        boolean matchedUnitContainer;
        boolean locatorMustResolve;
        MatchingNodeSet nodeSet;
        block27: {
            block24: {
                nodeSet = this.currentPossibleMatch.nodeSet;
                locatorMustResolve = this.patternLocator.mustResolve;
                if (nodeSet.mustResolve) {
                    this.patternLocator.mustResolve = true;
                }
                if (BasicSearchEngine.VERBOSE) {
                    System.out.println("Report matching: ");
                    int size = nodeSet.matchingNodes == null ? 0 : nodeSet.matchingNodes.elementSize;
                    System.out.print("\t- node set: accurate=" + size);
                    size = nodeSet.possibleMatchingNodesSet == null ? 0 : nodeSet.possibleMatchingNodesSet.elementSize;
                    System.out.println(", possible=" + size);
                    System.out.print("\t- must resolve: " + mustResolve);
                    System.out.print(" (locator: " + this.patternLocator.mustResolve);
                    System.out.println(", nodeSet: " + nodeSet.mustResolve + ')');
                }
                if (!mustResolve) break block24;
                this.unitScope = unit.scope.compilationUnitScope();
                Object[] nodes2 = nodeSet.possibleMatchingNodesSet.values;
                int i = 0;
                int l = nodes2.length;
                while (i < l) {
                    block25: {
                        ASTNode node;
                        block26: {
                            node = (ASTNode)nodes2[i];
                            if (node == null) break block25;
                            if (!(node instanceof ImportReference)) break block26;
                            if (this.hierarchyResolver != null) break block25;
                            ImportReference importRef = (ImportReference)node;
                            Binding binding = importRef.onDemand ? this.unitScope.getImport(CharOperation.subarray(importRef.tokens, 0, importRef.tokens.length), true, importRef.isStatic()) : this.unitScope.getImport(importRef.tokens, false, importRef.isStatic());
                            this.patternLocator.matchLevelAndReportImportRef(importRef, binding, this);
                        }
                        nodeSet.addMatch(node, this.patternLocator.resolveLevel(node));
                    }
                    ++i;
                }
                nodeSet.possibleMatchingNodesSet = new SimpleSet(3);
                if (BasicSearchEngine.VERBOSE) {
                    int size = nodeSet.matchingNodes == null ? 0 : nodeSet.matchingNodes.elementSize;
                    System.out.print("\t- node set: accurate=" + size);
                    size = nodeSet.possibleMatchingNodesSet == null ? 0 : nodeSet.possibleMatchingNodesSet.elementSize;
                    System.out.println(", possible=" + size);
                }
                break block27;
            }
            this.unitScope = null;
        }
        if (nodeSet.matchingNodes.elementSize == 0) {
            return;
        }
        this.methodHandles = new HashSet();
        boolean bl = matchedUnitContainer = (this.matchContainer & 1) != 0;
        if (unit.javadoc != null && (nodes = nodeSet.matchingNodes(unit.javadoc.sourceStart, unit.javadoc.sourceEnd)) != null) {
            if (!matchedUnitContainer) {
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
            } else {
                IJavaElement element = this.createPackageDeclarationHandle(unit);
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    ASTNode node = nodes[i];
                    level = (Integer)nodeSet.matchingNodes.removeKey(node);
                    if (this.encloses(element)) {
                        this.patternLocator.matchReportReference(node, element, null, level, this);
                    }
                    ++i;
                }
            }
        }
        if (matchedUnitContainer) {
            ImportReference[] imports;
            IJavaElement element;
            ImportReference pkg = unit.currentPackage;
            if (pkg != null && pkg.annotations != null && (element = this.createPackageDeclarationHandle(unit)) != null) {
                this.reportMatching(pkg.annotations, element, null, nodeSet, true, this.encloses(element));
            }
            if ((imports = unit.imports) != null) {
                int i = 0;
                int l = imports.length;
                while (i < l) {
                    ImportReference importRef = imports[i];
                    level = (Integer)nodeSet.matchingNodes.removeKey(importRef);
                    if (level != null) {
                        this.patternLocator.matchReportImportRef(importRef, null, this.createImportHandle(importRef), level, this);
                    }
                    ++i;
                }
            }
        }
        if ((types = unit.types) != null) {
            int i = 0;
            int l = types.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration type = types[i];
                Integer level2 = (Integer)nodeSet.matchingNodes.removeKey(type);
                int accuracy = level2 != null && matchedUnitContainer ? level2 : -1;
                this.reportMatching(type, null, accuracy, nodeSet, 1);
                ++i;
            }
        }
        this.methodHandles = null;
        this.patternLocator.mustResolve = locatorMustResolve;
    }

    protected void reportMatching(FieldDeclaration field, TypeDeclaration type, IJavaElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        block11: {
            ASTNode[] nodes;
            IJavaElement enclosingElement;
            block12: {
                int end;
                enclosingElement = null;
                if (accuracy > -1 && this.encloses(enclosingElement = this.createHandle(field, type, parent))) {
                    int offset = field.sourceStart;
                    SearchMatch match = this.newDeclarationMatch(enclosingElement, field.binding, accuracy, offset, field.sourceEnd - offset + 1);
                    this.report(match);
                }
                if ((field.bits & 2) != 0) {
                    if (enclosingElement == null) {
                        enclosingElement = this.createHandle(field, type, parent);
                    }
                    LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, field.binding, nodeSet);
                    try {
                        field.traverse((ASTVisitor)localDeclarationVisitor, null);
                    }
                    catch (WrappedCoreException e) {
                        throw e.coreException;
                    }
                }
                if (field.annotations != null) {
                    if (enclosingElement == null) {
                        enclosingElement = this.createHandle(field, type, parent);
                    }
                    this.reportMatching(field.annotations, enclosingElement, field.binding, nodeSet, true, true);
                }
                if (!typeInHierarchy || (nodes = nodeSet.matchingNodes(field.declarationSourceStart, end = field.endPart2Position == 0 ? field.declarationSourceEnd : field.endPart2Position)) == null) break block11;
                if ((this.matchContainer & 8) != 0) break block12;
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
                break block11;
            }
            if (enclosingElement == null) {
                enclosingElement = this.createHandle(field, type, parent);
            }
            if (!this.encloses(enclosingElement)) break block11;
            int i = 0;
            int l = nodes.length;
            while (i < l) {
                QualifiedAllocationExpression allocation;
                ASTNode node = nodes[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                if (node instanceof TypeDeclaration && (allocation = ((TypeDeclaration)node).allocation) != null && allocation.enumConstant != null) {
                    node = field;
                }
                this.patternLocator.matchReportReference(node, enclosingElement, field.binding, level, this);
                ++i;
            }
        }
    }

    protected void reportMatching(TypeDeclaration type, IJavaElement parent, int accuracy, MatchingNodeSet nodeSet, int occurrenceCount) throws CoreException {
        TypeDeclaration[] memberTypes;
        AbstractMethodDeclaration[] methods;
        ASTNode[] nodes;
        boolean matchedClassContainer;
        IJavaElement enclosingElement = parent;
        if (enclosingElement == null) {
            enclosingElement = this.createTypeHandle(new String(type.name));
        } else if (enclosingElement instanceof IType) {
            enclosingElement = ((IType)parent).getType(new String(type.name));
        } else if (enclosingElement instanceof IMember) {
            IMember member = (IMember)parent;
            enclosingElement = member.isBinary() ? parent : member.getType(new String(type.name), occurrenceCount);
        }
        if (enclosingElement == null) {
            return;
        }
        boolean enclosesElement = this.encloses(enclosingElement);
        if (accuracy > -1 && enclosesElement) {
            int offset = type.sourceStart;
            SearchMatch match = this.patternLocator.newDeclarationMatch(type, enclosingElement, type.binding, accuracy, type.sourceEnd - offset + 1, this);
            this.report(match);
        }
        boolean bl = matchedClassContainer = (this.matchContainer & 2) != 0;
        if (type.typeParameters != null) {
            int i = 0;
            int l = type.typeParameters.length;
            while (i < l) {
                TypeParameter typeParameter = type.typeParameters[i];
                if (typeParameter != null) {
                    Integer level = (Integer)nodeSet.matchingNodes.removeKey(typeParameter);
                    if (level != null && matchedClassContainer && level > -1 && enclosesElement) {
                        int offset = typeParameter.sourceStart;
                        SearchMatch match = this.patternLocator.newDeclarationMatch(typeParameter, enclosingElement, type.binding, level, typeParameter.sourceEnd - offset + 1, this);
                        this.report(match);
                    }
                    if (typeParameter.type != null && (level = (Integer)nodeSet.matchingNodes.removeKey(typeParameter.type)) != null && matchedClassContainer) {
                        this.patternLocator.matchReportReference(typeParameter.type, enclosingElement, type.binding, level, this);
                    }
                    if (typeParameter.bounds != null) {
                        int j = 0;
                        int b = typeParameter.bounds.length;
                        while (j < b) {
                            level = (Integer)nodeSet.matchingNodes.removeKey(typeParameter.bounds[j]);
                            if (level != null && matchedClassContainer) {
                                this.patternLocator.matchReportReference(typeParameter.bounds[j], enclosingElement, type.binding, level, this);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        if (type.annotations != null) {
            this.reportMatching(type.annotations, enclosingElement, type.binding, nodeSet, matchedClassContainer, enclosesElement);
        }
        if (type.javadoc != null && (nodes = nodeSet.matchingNodes(type.declarationSourceStart, type.sourceStart)) != null) {
            int i;
            if (!matchedClassContainer) {
                i = 0;
                int l = nodes.length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
            } else {
                i = 0;
                int l = nodes.length;
                while (i < l) {
                    ASTNode node = nodes[i];
                    Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                    if (enclosesElement) {
                        this.patternLocator.matchReportReference(node, enclosingElement, type.binding, level, this);
                    }
                    ++i;
                }
            }
        }
        if ((type.bits & 0x200) != 0) {
            Integer level;
            TypeReference superType = type.allocation.type;
            if (superType != null && (level = (Integer)nodeSet.matchingNodes.removeKey(superType)) != null && matchedClassContainer) {
                this.patternLocator.matchReportReference(superType, enclosingElement, type.binding, level, this);
            }
        } else {
            TypeReference[] superInterfaces;
            TypeReference superClass = type.superclass;
            if (superClass != null) {
                this.reportMatchingSuper(superClass, enclosingElement, type.binding, nodeSet, matchedClassContainer);
            }
            if ((superInterfaces = type.superInterfaces) != null) {
                int i = 0;
                int l = superInterfaces.length;
                while (i < l) {
                    this.reportMatchingSuper(superInterfaces[i], enclosingElement, type.binding, nodeSet, matchedClassContainer);
                    ++i;
                }
            }
        }
        boolean typeInHierarchy = type.binding == null || this.typeInHierarchy(type.binding);
        matchedClassContainer = matchedClassContainer && typeInHierarchy;
        FieldDeclaration[] fields = type.fields;
        if (fields != null) {
            if (nodeSet.matchingNodes.elementSize == 0) {
                return;
            }
            int i = 0;
            int l = fields.length;
            while (i < l) {
                FieldDeclaration field = fields[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(field);
                int value = level != null && matchedClassContainer ? level : -1;
                this.reportMatching(field, type, enclosingElement, value, typeInHierarchy, nodeSet);
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            if (nodeSet.matchingNodes.elementSize == 0) {
                return;
            }
            int i = 0;
            int l = methods.length;
            while (i < l) {
                AbstractMethodDeclaration method = methods[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(method);
                int value = level != null && matchedClassContainer ? level : -1;
                this.reportMatching(method, enclosingElement, value, typeInHierarchy, nodeSet);
                ++i;
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int i = 0;
            int l = memberTypes.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration memberType = memberTypes[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(memberType);
                int value = level != null && matchedClassContainer ? level : -1;
                this.reportMatching(memberType, enclosingElement, value, nodeSet, 1);
                ++i;
            }
        }
    }

    protected void reportMatchingSuper(TypeReference superReference, IJavaElement enclosingElement, Binding elementBinding, MatchingNodeSet nodeSet, boolean matchedClassContainer) throws CoreException {
        ASTNode[] nodes = null;
        if (superReference instanceof ParameterizedSingleTypeReference || superReference instanceof ParameterizedQualifiedTypeReference) {
            long lastTypeArgumentInfo = this.findLastTypeArgumentInfo(superReference);
            nodes = nodeSet.matchingNodes(superReference.sourceStart, (int)lastTypeArgumentInfo);
        }
        if (nodes != null) {
            if ((this.matchContainer & 2) == 0) {
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
            } else if (this.encloses(enclosingElement)) {
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    ASTNode node = nodes[i];
                    Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                    this.patternLocator.matchReportReference(node, enclosingElement, elementBinding, level, this);
                    ++i;
                }
            }
        } else {
            Integer level = (Integer)nodeSet.matchingNodes.removeKey(superReference);
            if (level != null && matchedClassContainer) {
                this.patternLocator.matchReportReference(superReference, enclosingElement, elementBinding, level, this);
            }
        }
    }

    protected boolean typeInHierarchy(ReferenceBinding binding) {
        if (this.hierarchyResolver == null) {
            return true;
        }
        if (this.hierarchyResolver.subOrSuperOfFocus(binding)) {
            return true;
        }
        if (this.allSuperTypeNames != null) {
            char[][] compoundName = binding.compoundName;
            int i = 0;
            int length = this.allSuperTypeNames.length;
            while (i < length) {
                if (CharOperation.equals(compoundName, this.allSuperTypeNames[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public class LocalDeclarationVisitor
    extends ASTVisitor {
        IJavaElement enclosingElement;
        Binding enclosingElementBinding;
        MatchingNodeSet nodeSet;
        HashtableOfIntValues occurrencesCounts = new HashtableOfIntValues();

        public LocalDeclarationVisitor(IJavaElement enclosingElement, Binding enclosingElementBinding, MatchingNodeSet nodeSet) {
            this.enclosingElement = enclosingElement;
            this.enclosingElementBinding = enclosingElementBinding;
            this.nodeSet = nodeSet;
        }

        public boolean visit(TypeDeclaration typeDeclaration, BlockScope unused) {
            try {
                char[] simpleName = (typeDeclaration.bits & 0x200) != 0 ? CharOperation.NO_CHAR : typeDeclaration.name;
                int occurrenceCount = this.occurrencesCounts.get(simpleName);
                occurrenceCount = occurrenceCount == Integer.MIN_VALUE ? 1 : ++occurrenceCount;
                this.occurrencesCounts.put(simpleName, occurrenceCount);
                if ((typeDeclaration.bits & 0x200) != 0) {
                    MatchLocator.this.reportMatching(typeDeclaration, this.enclosingElement, -1, this.nodeSet, occurrenceCount);
                } else {
                    Integer level = (Integer)this.nodeSet.matchingNodes.removeKey(typeDeclaration);
                    MatchLocator.this.reportMatching(typeDeclaration, this.enclosingElement, level != null ? level : -1, this.nodeSet, occurrenceCount);
                }
                return false;
            }
            catch (CoreException e) {
                throw new WrappedCoreException(e);
            }
        }
    }

    public static class WorkingCopyDocument
    extends JavaSearchDocument {
        public ICompilationUnit workingCopy;

        WorkingCopyDocument(ICompilationUnit workingCopy, SearchParticipant participant) {
            super(workingCopy.getPath().toString(), participant);
            this.charContents = ((CompilationUnit)workingCopy).getContents();
            this.workingCopy = workingCopy;
        }

        public String toString() {
            return "WorkingCopyDocument for " + this.getPath();
        }
    }

    public class WrappedCoreException
    extends RuntimeException {
        private static final long serialVersionUID = 8354329870126121212L;
        public CoreException coreException;

        public WrappedCoreException(CoreException coreException) {
            this.coreException = coreException;
        }
    }
}

