/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetCallback;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.impl.Assert;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class CharsetDecoderICU
extends CharsetDecoder {
    int toUnicodeStatus;
    byte[] toUBytesArray = new byte[128];
    int toUBytesBegin = 0;
    int toULength;
    char[] charErrorBufferArray = new char[128];
    int charErrorBufferLength;
    int charErrorBufferBegin;
    char[] invalidCharBuffer = new char[128];
    int invalidCharLength;
    private static final int EXT_MAX_BYTES = 31;
    byte[] preToUArray = new byte[31];
    int preToUBegin;
    int preToULength;
    int preToUFirstLength;
    int mode;
    Object toUContext = null;
    private CharsetCallback.Decoder onUnmappableInput = CharsetCallback.TO_U_CALLBACK_STOP;
    private CharsetCallback.Decoder onMalformedInput = CharsetCallback.TO_U_CALLBACK_STOP;
    CharsetCallback.Decoder toCharErrorBehaviour = new CharsetCallback.Decoder(){

        public CoderResult call(CharsetDecoderICU decoder, Object context, ByteBuffer source, CharBuffer target, IntBuffer offsets, char[] buffer, int length, CoderResult cr) {
            if (cr.isUnmappable()) {
                return CharsetDecoderICU.this.onUnmappableInput.call(decoder, context, source, target, offsets, buffer, length, cr);
            }
            if (cr.isMalformed()) {
                return CharsetDecoderICU.this.onMalformedInput.call(decoder, context, source, target, offsets, buffer, length, cr);
            }
            return CharsetCallback.TO_U_CALLBACK_STOP.call(decoder, context, source, target, offsets, buffer, length, cr);
        }
    };
    private final ByteBuffer EMPTY = ByteBuffer.allocate(0);

    CharsetDecoderICU(CharsetICU cs) {
        super(cs, 1.0f / cs.maxCharsPerByte, cs.maxCharsPerByte);
    }

    final boolean isFallbackUsed() {
        return true;
    }

    protected final void implOnMalformedInput(CodingErrorAction newAction) {
        this.onMalformedInput = CharsetDecoderICU.getCallback(newAction);
    }

    protected final void implOnUnmappableCharacter(CodingErrorAction newAction) {
        this.onUnmappableInput = CharsetDecoderICU.getCallback(newAction);
    }

    private static CharsetCallback.Decoder getCallback(CodingErrorAction action) {
        if (action == CodingErrorAction.REPLACE) {
            return CharsetCallback.TO_U_CALLBACK_SUBSTITUTE;
        }
        if (action == CodingErrorAction.IGNORE) {
            return CharsetCallback.TO_U_CALLBACK_SKIP;
        }
        if (action == CodingErrorAction.REPORT) {
            return CharsetCallback.TO_U_CALLBACK_STOP;
        }
        return CharsetCallback.TO_U_CALLBACK_STOP;
    }

    protected final CoderResult implFlush(CharBuffer out) {
        return this.decode(this.EMPTY, out, null, true);
    }

    protected void implReset() {
        this.toUnicodeStatus = 0;
        this.toULength = 0;
        this.charErrorBufferLength = 0;
        this.charErrorBufferBegin = 0;
        this.preToUBegin = 0;
        this.preToULength = 0;
        this.preToUFirstLength = 0;
        this.mode = 0;
    }

    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        if (!in.hasRemaining()) {
            this.toULength = 0;
            return CoderResult.UNDERFLOW;
        }
        in.position(in.position() + this.toUCountPending());
        CoderResult ret = this.decode(in, out, null, false);
        this.setSourcePosition(in);
        return ret;
    }

    abstract CoderResult decodeLoop(ByteBuffer var1, CharBuffer var2, IntBuffer var3, boolean var4);

    final CoderResult decode(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
        if (target == null || source == null) {
            throw new IllegalArgumentException();
        }
        if (this.charErrorBufferLength > 0) {
            char[] overflow = null;
            overflow = this.charErrorBufferArray;
            int length = this.charErrorBufferLength;
            int i = 0;
            do {
                if (target.remaining() <= 0) {
                    int j = 0;
                    do {
                        overflow[j++] = overflow[i++];
                    } while (i < length);
                    this.charErrorBufferLength = (byte)j;
                    return CoderResult.OVERFLOW;
                }
                target.put(overflow[i++]);
                if (offsets == null) continue;
                offsets.put(-1);
            } while (i < length);
            this.charErrorBufferLength = 0;
        }
        if (!flush && source.remaining() == 0 && this.preToULength >= 0) {
            return CoderResult.UNDERFLOW;
        }
        return this.toUnicodeWithCallback(source, target, offsets, flush);
    }

    private void updateOffsets(IntBuffer offsets, int length, int sourceIndex, int errorInputLength) {
        block4: {
            int delta = sourceIndex >= 0 ? sourceIndex - errorInputLength : -1;
            int limit = offsets.position() + length;
            if (delta == 0) break block4;
            if (delta > 0) {
                while (offsets.position() < limit) {
                    int offset = offsets.get(offsets.position());
                    if (offset < 0) continue;
                    offsets.put(offset + delta);
                }
            } else {
                while (offsets.position() < limit) {
                    offsets.put(-1);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    final CoderResult toUnicodeWithCallback(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
        t = target.position();
        s = source.position();
        replayArray = ByteBuffer.allocate(31);
        replayArrayIndex = 0;
        realSource = null;
        realFlush = false;
        realSourceIndex = 0;
        cr = CoderResult.UNDERFLOW;
        sourceIndex = 0;
        if (this.preToULength < 0) {
            realSource = source;
            realFlush = flush;
            realSourceIndex = sourceIndex;
            replayArray.put(this.preToUArray, 0, -this.preToULength);
            source = replayArray;
            source.position(0);
            source.limit(replayArrayIndex - this.preToULength);
            flush = false;
            sourceIndex = -1;
            this.preToULength = 0;
        }
        block0: while (true) {
            converterSawEndOfInput = cr.isUnderflow() != false ? (cr = this.decodeLoop(source, target, offsets, flush)).isUnderflow() != false && flush != false && source.remaining() == 0 && this.toULength == 0 : false;
            calledCallback = false;
            errorInputLength = 0;
            while (true) {
                if (offsets != null) {
                    length = target.position() - t;
                    if (length > 0) {
                        this.updateOffsets(offsets, length, sourceIndex, errorInputLength);
                    }
                    if (sourceIndex >= 0) {
                        sourceIndex += source.position() - s;
                    }
                }
                if (this.preToULength < 0) {
                    if (realSource == null) {
                        realSource = source;
                        realFlush = flush;
                        realSourceIndex = sourceIndex;
                        replayArray.put(this.preToUArray, 0, -this.preToULength);
                        source = replayArray;
                        source.limit(replayArrayIndex - this.preToULength);
                        flush = false;
                        if ((sourceIndex += this.preToULength) < 0) {
                            sourceIndex = -1;
                        }
                        this.preToULength = 0;
                    } else {
                        Assert.assrt((boolean)(realSource == null));
                    }
                }
                s = source.position();
                t = target.position();
                if (cr.isUnderflow()) {
                    if (s < source.limit()) continue block0;
                    if (realSource != null) {
                        source = realSource;
                        flush = realFlush;
                        sourceIndex = realSourceIndex;
                        realSource = null;
                        continue block0;
                    }
                    if (flush && this.toULength > 0) {
                        cr = CoderResult.malformedForLength(this.toULength);
                        calledCallback = false;
                    } else {
                        if (flush) {
                            if (converterSawEndOfInput) ** break;
                            continue block0;
                            this.implReset();
                        }
                        return cr;
                    }
                }
                if (calledCallback || cr.isOverflow() || cr.isMalformed() && cr.isUnmappable()) {
                    if (realSource != null) {
                        Assert.assrt((boolean)(this.preToULength == 0));
                        length = source.limit() - source.position();
                        if (length > 0) {
                            source.get(this.preToUArray, this.preToUBegin, length);
                            this.preToULength = (byte)(-length);
                        }
                        source = realSource;
                        flush = realFlush;
                    }
                    return cr;
                }
                this.invalidCharLength = this.toULength;
                errorInputLength = this.invalidCharLength;
                if (errorInputLength > 0) {
                    this.copy(this.toUBytesArray, 0, this.invalidCharBuffer, 0, errorInputLength);
                }
                this.toULength = 0;
                cr = this.toCharErrorBehaviour.call(this, this.toUContext, source, target, offsets, this.invalidCharBuffer, errorInputLength, cr);
                calledCallback = true;
            }
            break;
        }
    }

    int toUCountPending() {
        if (this.preToULength > 0) {
            return this.preToULength;
        }
        if (this.preToULength < 0) {
            return -this.preToULength;
        }
        if (this.toULength > 0) {
            return this.toULength;
        }
        return 0;
    }

    private final void setSourcePosition(ByteBuffer source) {
        source.position(source.position() - this.toUCountPending());
    }

    private void copy(byte[] src, int srcOffset, char[] dst, int dstOffset, int length) {
        for (int i = srcOffset; i < length; ++i) {
            dst[dstOffset++] = (char)src[srcOffset++];
        }
    }

    static final CoderResult toUWriteUChars(CharsetDecoderICU cnv, char[] ucharsArray, int ucharsBegin, int length, CharBuffer target, IntBuffer offsets, int sourceIndex) {
        CoderResult cr = CoderResult.UNDERFLOW;
        if (offsets == null) {
            while (length > 0 && target.hasRemaining()) {
                target.put(ucharsArray[ucharsBegin++]);
                --length;
            }
        } else {
            while (length > 0 && target.hasRemaining()) {
                target.put(ucharsArray[ucharsBegin++]);
                offsets.put(sourceIndex);
                --length;
            }
        }
        if (length > 0) {
            cnv.charErrorBufferLength = 0;
            cr = CoderResult.OVERFLOW;
            do {
                cnv.charErrorBufferArray[cnv.charErrorBufferLength++] = ucharsArray[ucharsBegin++];
            } while (--length > 0);
        }
        return cr;
    }

    CoderResult cbToUWriteSub(CharsetDecoderICU decoder, ByteBuffer source, CharBuffer target, IntBuffer offsets) {
        String sub = decoder.replacement();
        CharsetICU cs = (CharsetICU)decoder.charset();
        if (decoder.invalidCharLength == 1 && cs.subChar1 != 0) {
            char[] subArr = new char[]{'\u001a'};
            return CharsetDecoderICU.toUWriteUChars(decoder, subArr, 0, sub.length(), target, offsets, source.position());
        }
        return CharsetDecoderICU.toUWriteUChars(decoder, sub.toCharArray(), 0, sub.length(), target, offsets, source.position());
    }
}

