/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import java.util.HashMap;
import java.util.Map;
import org.geotools.util.ObjectCache;

final class DefaultObjectCache
implements ObjectCache {
    private final Map cache;

    public DefaultObjectCache() {
        this.cache = new HashMap();
    }

    public DefaultObjectCache(int initialSize) {
        this.cache = new HashMap(initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public Object get(Object key) {
        return this.getEntry(key).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek(Object key) {
        Map map = this.cache;
        synchronized (map) {
            if (!this.cache.containsKey(key)) {
                return null;
            }
            return this.getEntry(key).peek();
        }
    }

    public void writeLock(Object key) {
        this.getEntry(key).writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUnLock(Object key) {
        Map map = this.cache;
        synchronized (map) {
            if (!this.cache.containsKey(key)) {
                throw new IllegalStateException("Cannot unlock prior to locking");
            }
            this.getEntry(key).writeUnLock();
        }
    }

    public void put(Object key, Object object) {
        this.getEntry(key).setValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectCacheEntry getEntry(Object key) {
        Map map = this.cache;
        synchronized (map) {
            ObjectCacheEntry entry = (ObjectCacheEntry)this.cache.get(key);
            if (entry == null) {
                entry = new ObjectCacheEntry();
                this.cache.put(key, entry);
            }
            return entry;
        }
    }

    static final class ObjectCacheEntry {
        private volatile Object value;
        private final ReadWriteLock lock = new ReentrantWriterPreferenceReadWriteLock();

        public ObjectCacheEntry() {
        }

        public ObjectCacheEntry(Object value) {
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object peek() {
            try {
                this.lock.writeLock().acquire();
                Object object = this.value;
                return object;
            }
            catch (InterruptedException e) {
                Object var2_3 = null;
                return var2_3;
            }
            finally {
                this.lock.writeLock().release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue() {
            try {
                this.lock.readLock().acquire();
                Object object = this.value;
                return object;
            }
            catch (InterruptedException e) {
                Object var2_3 = null;
                return var2_3;
            }
            finally {
                this.lock.readLock().release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object value) {
            try {
                this.lock.writeLock().acquire();
                this.value = value;
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.lock.writeLock().release();
            }
        }

        public boolean writeLock() {
            try {
                this.lock.writeLock().acquire();
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }

        public void writeUnLock() {
            this.lock.writeLock().release();
        }
    }
}

