/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.maintenance;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

public class MaintenanceInformationImpl
extends MetadataEntity
implements MaintenanceInformation {
    private static final long serialVersionUID = 8523463344581266776L;
    private MaintenanceFrequency maintenanceAndUpdateFrequency;
    private long dateOfNextUpdate = Long.MIN_VALUE;
    private PeriodDuration userDefinedMaintenanceFrequency;
    private Collection updateScopes;
    private Collection updateScopeDescriptions;
    private Collection maintenanceNotes;
    private Collection contacts;

    public MaintenanceInformationImpl() {
    }

    public MaintenanceInformationImpl(MaintenanceInformation source) {
        super(source);
    }

    public MaintenanceInformationImpl(MaintenanceFrequency maintenanceAndUpdateFrequency) {
        this.setMaintenanceAndUpdateFrequency(maintenanceAndUpdateFrequency);
    }

    public MaintenanceFrequency getMaintenanceAndUpdateFrequency() {
        return this.maintenanceAndUpdateFrequency;
    }

    public synchronized void setMaintenanceAndUpdateFrequency(MaintenanceFrequency newValue) {
        this.checkWritePermission();
        this.maintenanceAndUpdateFrequency = newValue;
    }

    public synchronized Date getDateOfNextUpdate() {
        return this.dateOfNextUpdate != Long.MIN_VALUE ? new Date(this.dateOfNextUpdate) : null;
    }

    public synchronized void setDateOfNextUpdate(Date newValue) {
        this.checkWritePermission();
        this.dateOfNextUpdate = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public PeriodDuration getUserDefinedMaintenanceFrequency() {
        return this.userDefinedMaintenanceFrequency;
    }

    public synchronized void setUserDefinedMaintenanceFrequency(PeriodDuration newValue) {
        this.checkWritePermission();
        this.userDefinedMaintenanceFrequency = newValue;
    }

    public ScopeCode getUpdateScope() {
        Collection updateScopes = this.getUpdateScopes();
        return updateScopes.isEmpty() ? null : (ScopeCode)updateScopes.iterator().next();
    }

    public void setUpdateScope(ScopeCode newValue) {
        this.setUpdateScopes(Collections.singleton(newValue));
    }

    public synchronized Collection getUpdateScopes() {
        this.updateScopes = this.nonNullCollection(this.updateScopes, ScopeCode.class);
        return this.updateScopes;
    }

    public synchronized void setUpdateScopes(Collection newValues) {
        this.updateScopes = this.copyCollection(newValues, this.updateScopes, ScopeCode.class);
    }

    public ScopeDescription getUpdateScopeDescription() {
        Collection updateScopeDescriptions = this.getUpdateScopeDescriptions();
        return updateScopeDescriptions.isEmpty() ? null : (ScopeDescription)updateScopeDescriptions.iterator().next();
    }

    public void setUpdateScopeDescription(ScopeDescription newValue) {
        this.setUpdateScopeDescriptions(Collections.singleton(newValue));
    }

    public synchronized Collection getUpdateScopeDescriptions() {
        this.updateScopeDescriptions = this.nonNullCollection(this.updateScopeDescriptions, ScopeDescription.class);
        return this.updateScopeDescriptions;
    }

    public synchronized void setUpdateScopeDescriptions(Collection newValues) {
        this.updateScopeDescriptions = this.copyCollection(newValues, this.updateScopeDescriptions, ScopeDescription.class);
    }

    public InternationalString getMaintenanceNote() {
        Collection maintenanceNotes = this.getMaintenanceNotes();
        return maintenanceNotes.isEmpty() ? null : (InternationalString)maintenanceNotes.iterator().next();
    }

    public void setMaintenanceNote(InternationalString newValue) {
        this.setMaintenanceNotes(Collections.singleton(newValue));
    }

    public synchronized Collection getMaintenanceNotes() {
        this.maintenanceNotes = this.nonNullCollection(this.maintenanceNotes, InternationalString.class);
        return this.maintenanceNotes;
    }

    public synchronized void setMaintenanceNotes(Collection newValues) {
        this.maintenanceNotes = this.copyCollection(newValues, this.maintenanceNotes, InternationalString.class);
    }

    public synchronized Collection getContacts() {
        this.contacts = this.nonNullCollection(this.contacts, ResponsibleParty.class);
        return this.contacts;
    }

    public synchronized void setContacts(Collection newValues) {
        this.contacts = this.copyCollection(newValues, this.contacts, ResponsibleParty.class);
    }
}

