/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.extent;

import javax.units.Unit;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.datum.VerticalDatum;

public class VerticalExtentImpl
extends MetadataEntity
implements VerticalExtent {
    private static final long serialVersionUID = -3214554246909844079L;
    private Double minimumValue;
    private Double maximumValue;
    private VerticalCRS verticalCRS;

    public VerticalExtentImpl() {
    }

    public VerticalExtentImpl(VerticalExtent source) {
        super(source);
    }

    public VerticalExtentImpl(Double minimumValue, Double maximumValue, VerticalCRS verticalCRS) {
        this.setMinimumValue(minimumValue);
        this.setMaximumValue(maximumValue);
        this.setVerticalCRS(verticalCRS);
    }

    public VerticalExtentImpl(double minimumValue, double maximumValue, Unit unit, VerticalDatum verticalDatum) {
        this.setMinimumValue(new Double(minimumValue));
        this.setMaximumValue(new Double(maximumValue));
        this.setUnit(unit);
        this.setVerticalDatum(verticalDatum);
    }

    public Double getMinimumValue() {
        return this.minimumValue;
    }

    public synchronized void setMinimumValue(Double newValue) {
        this.checkWritePermission();
        this.minimumValue = newValue;
    }

    public Double getMaximumValue() {
        return this.maximumValue;
    }

    public synchronized void setMaximumValue(Double newValue) {
        this.checkWritePermission();
        this.maximumValue = newValue;
    }

    public VerticalCRS getVerticalCRS() {
        return this.verticalCRS;
    }

    public synchronized void setVerticalCRS(VerticalCRS newValue) {
        this.checkWritePermission();
        this.verticalCRS = newValue;
    }

    public Unit getUnit() {
        return this.verticalCRS != null ? this.verticalCRS.getCoordinateSystem().getAxis(0).getUnit() : null;
    }

    public void setUnit(Unit newValue) {
        throw new UnsupportedOperationException("Use setVerticalCRS instead.");
    }

    public VerticalDatum getVerticalDatum() {
        return this.verticalCRS != null ? (VerticalDatum)this.verticalCRS.getDatum() : null;
    }

    public void setVerticalDatum(VerticalDatum newValue) {
        throw new UnsupportedOperationException("Use setVerticalCRS instead.");
    }
}

