/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.sql.DataSource;
import org.geotools.factory.AbstractFactory;
import org.geotools.factory.GeoTools;
import org.geotools.resources.Utilities;
import org.geotools.util.Logging;
import org.opengis.util.InternationalString;

public final class Hints
extends RenderingHints {
    private static final Hints GLOBAL = new Hints(Collections.EMPTY_MAP);
    private static boolean needScan = true;
    public static final ClassKey JTS_GEOMETRY_FACTORY = new ClassKey("com.vividsolutions.jts.geom.GeometryFactory");
    public static final ClassKey JTS_COORDINATE_SEQUENCE_FACTORY = new ClassKey("com.vividsolutions.jts.geom.CoordinateSequenceFactory");
    public static final Key JTS_PRECISION_MODEL = new Key("com.vividsolutions.jts.geom.PrecisionModel");
    public static final Key JTS_SRID = new Key(Integer.class);
    public static final ClassKey CRS_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.crs.CRSAuthorityFactory");
    public static final ClassKey CS_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.cs.CSAuthorityFactory");
    public static final ClassKey DATUM_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.datum.DatumAuthorityFactory");
    public static final ClassKey CRS_FACTORY = new ClassKey("org.opengis.referencing.crs.CRSFactory");
    public static final ClassKey CS_FACTORY = new ClassKey("org.opengis.referencing.cs.CSFactory");
    public static final ClassKey DATUM_FACTORY = new ClassKey("org.opengis.referencing.datum.DatumFactory");
    public static final ClassKey COORDINATE_OPERATION_FACTORY = new ClassKey("org.opengis.referencing.operation.CoordinateOperationFactory");
    public static final ClassKey COORDINATE_OPERATION_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.operation.CoordinateOperationAuthorityFactory");
    public static final ClassKey MATH_TRANSFORM_FACTORY = new ClassKey("org.opengis.referencing.operation.MathTransformFactory");
    public static final ClassKey FEATURE_LOCK_FACTORY = new ClassKey("org.geotools.data.FeatureLockFactory");
    public static final ClassKey FEATURE_COLLECTIONS = new ClassKey("org.geotools.feature.FeatureCollections");
    public static final ClassKey FEATURE_TYPE_FACTORY = new ClassKey("org.geotools.feature.FeatureTypeFactory");
    public static final Key FEATURE_TYPE_FACTORY_NAME = new Key(String.class);
    public static final Key FEATURE_DETACHED = new Key(Boolean.class);
    public static final ClassKey STYLE_FACTORY = new ClassKey("org.geotools.styling.StyleFactory");
    public static final ClassKey ATTRIBUTE_TYPE_FACTORY = new ClassKey("org.geotools.feature.AttributeTypeFactory");
    public static final ClassKey FILTER_FACTORY = new ClassKey("org.opengis.filter.FilterFactory");
    public static final Key DEFAULT_COORDINATE_REFERENCE_SYSTEM = new Key("org.opengis.referencing.crs.CoordinateReferenceSystem");
    public static final FileKey CRS_AUTHORITY_EXTRA_DIRECTORY = new FileKey(false);
    public static final Key EPSG_DATA_SOURCE = new DataSourceKey();
    public static final OptionKey DATUM_SHIFT_METHOD = new OptionKey("Molodenski", "Abridged_Molodenski", "Geocentric", "*");
    public static final Key LENIENT_DATUM_SHIFT = new Key(Boolean.class);
    public static final Key FORCE_LONGITUDE_FIRST_AXIS_ORDER = new Key(Boolean.class);
    public static final Key FORCE_STANDARD_AXIS_DIRECTIONS = new Key(Boolean.class);
    public static final Key FORCE_STANDARD_AXIS_UNITS = new Key(Boolean.class);
    public static final OptionKey CACHE_POLICY = new OptionKey("weak", "all", "fixed", "none", "default");
    public static final IntegerKey CACHE_LIMIT = new IntegerKey(50);
    public static final IntegerKey AUTHORITY_MAX_ACTIVE = new IntegerKey(2);
    public static final IntegerKey AUTHORITY_MIN_IDLE = new IntegerKey(1);
    public static final IntegerKey AUTHORITY_MAX_IDLE = new IntegerKey(2);
    public static final IntegerKey AUTHORITY_MIN_EVICT_IDLETIME = new IntegerKey(0);
    public static final IntegerKey AUTHORITY_SOFTMIN_EVICT_IDLETIME = new IntegerKey(0);
    public static final IntegerKey AUTHORITY_TIME_BETWEEN_EVICTION_RUNS = new IntegerKey(0);
    public static final Key VERSION = new Key("org.geotools.util.Version");
    public static final Key GRID_COVERAGE_PROCESSOR = new Key(Object.class);
    public static final Key IGNORE_COVERAGE_OVERVIEW = new Key(Boolean.class);
    public static final Key REPLACE_NON_GEOPHYSICS_VIEW = new Key(Boolean.class);
    public static final Key TILE_ENCODING = new Key(String.class);
    public static final Key JAI_INSTANCE = new Key("javax.media.jai.JAI");
    public static final Key SAMPLE_DIMENSION_TYPE = new Key("org.opengis.coverage.SampleDimensionType");
    public static final Key CRS = new Key("org.opengis.referencing.crs.CoordinateReferenceSystem");
    public static final Key PRECISION = new Key(" org.opengis.geometry.Precision");
    public static final Key POSITION_FACTORY = new Key("org.opengis.geometry.PositionFactory");
    public static final Key GEOMETRY_FACTORY = new Key("org.opengis.geometry.coordinate.GeometryFactory");
    public static final Key COMPLEX_FACTORY = new Key("org.opengis.geometry.complex.ComplexFactory");
    public static final Key AGGREGATE_FACTORY = new Key("org.opengis.geometry.aggregate.AggregateFactory");
    public static final Key PRIMITIVE_FACTORY = new Key("org.opengis.geometry.primitive.PrimitiveFactory");
    public static final Key GEOMETRY_VALIDATE = new Key(Boolean.class);

    public Hints(RenderingHints.Key key, Object value) {
        super(key, value);
    }

    public Hints(RenderingHints.Key key1, Object value1, RenderingHints.Key key2, Object value2) {
        this(Hints.fromPairs(new Object[]{key1, value1, key2, value2}));
    }

    public Hints(RenderingHints.Key key1, Object value1, Object[] pairs) {
        this(Hints.fromPairs(key1, value1, pairs));
    }

    public Hints(RenderingHints.Key key1, Object value1, RenderingHints.Key key2, Object value2, Object[] pairs) {
        this(Hints.fromPairs(key1, value1, key2, value2, pairs));
    }

    private static Map fromPairs(RenderingHints.Key key1, Object value1, Object[] pairs) {
        Map map = Hints.fromPairs(pairs);
        map.put(key1, value1);
        return map;
    }

    private static Map fromPairs(RenderingHints.Key key1, Object value1, RenderingHints.Key key2, Object value2, Object[] pairs) {
        Map map = Hints.fromPairs(pairs);
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    private static Map fromPairs(Object[] pairs) {
        HashMap<Key, Object> map = new HashMap<Key, Object>();
        for (int i = 0; i < pairs.length; i += 2) {
            Key key = (Key)pairs[i];
            Object value = pairs[i + 1];
            if (key.isCompatibleValue(value)) {
                throw new ClassCastException(key + " requires " + key.getValueClass() + " - could cast " + value);
            }
            map.put(key, value);
        }
        return map;
    }

    public Hints(Map hints) {
        super(Hints.stripNonKeys(hints));
    }

    static Map stripNonKeys(Map hints) {
        if (hints == null) {
            return null;
        }
        HashMap filtered = hints;
        for (Object key : hints.keySet()) {
            if (key instanceof RenderingHints.Key) continue;
            if (filtered == hints) {
                filtered = new HashMap(hints);
            }
            filtered.remove(key);
        }
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanSystemProperties() {
        Hints hints = GLOBAL;
        synchronized (hints) {
            needScan = true;
        }
    }

    private static boolean ensureSystemDefaultLoaded() {
        assert (Thread.holdsLock(GLOBAL));
        if (needScan) {
            needScan = false;
            return GeoTools.scanForSystemHints(GLOBAL);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Hints getDefaults() {
        Hints hints;
        boolean changed;
        Hints hints2 = GLOBAL;
        synchronized (hints2) {
            changed = Hints.ensureSystemDefaultLoaded();
            hints = new Hints((Map)GLOBAL);
        }
        if (changed) {
            GeoTools.fireConfigurationChanged();
        }
        return hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putSystemDefault(RenderingHints hints) {
        Hints hints2 = GLOBAL;
        synchronized (hints2) {
            Hints.ensureSystemDefaultLoaded();
            GLOBAL.add(hints);
        }
        GeoTools.fireConfigurationChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSystemDefault(RenderingHints.Key key) {
        Object value;
        boolean changed;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            value = GLOBAL.get(key);
        }
        if (changed) {
            GeoTools.fireConfigurationChanged();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object putSystemDefault(RenderingHints.Key key, Object value) {
        Object old;
        boolean changed;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            old = GLOBAL.put(key, value);
        }
        if (changed || !Utilities.equals(value, old)) {
            GeoTools.fireConfigurationChanged();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object removeSystemDefault(RenderingHints.Key key) {
        Object old;
        boolean changed;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            old = GLOBAL.remove(key);
        }
        if (changed || old != null) {
            GeoTools.fireConfigurationChanged();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean changed;
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuffer buffer = new StringBuffer("Hints:");
        buffer.append(lineSeparator).append(AbstractFactory.toString(this));
        HashMap<Object, Object> extra = null;
        Hints hints = GLOBAL;
        synchronized (hints) {
            changed = Hints.ensureSystemDefaultLoaded();
            if (!GLOBAL.isEmpty()) {
                extra = new HashMap<Object, Object>(GLOBAL);
            }
        }
        if (changed) {
            GeoTools.fireConfigurationChanged();
        }
        if (extra != null) {
            extra.keySet().removeAll(this.keySet());
            if (!extra.isEmpty()) {
                buffer.append("System defaults:").append(lineSeparator).append(AbstractFactory.toString(extra));
            }
        }
        return buffer.toString();
    }

    static final class DataSourceKey
    extends Key {
        public DataSourceKey() {
            super(DataSource.class);
        }

        public boolean isCompatibleValue(Object value) {
            return value instanceof DataSource || value instanceof String || value instanceof Name;
        }
    }

    public static final class OptionKey
    extends Key {
        private final Set options;
        private final boolean wildcard;

        public OptionKey(String option1, String option2) {
            this(new String[]{option1, option2});
        }

        public OptionKey(String option1, String option2, String option3) {
            this(new String[]{option1, option2, option3});
        }

        public OptionKey(String option1, String option2, String option3, String option4) {
            this(new String[]{option1, option2, option4});
        }

        public OptionKey(String option1, String option2, String option3, String option4, String option5) {
            this(new String[]{option1, option2, option4, option5});
        }

        public OptionKey(String[] alternatives) {
            super(String.class);
            TreeSet<String> options = new TreeSet<String>(Arrays.asList(alternatives));
            this.wildcard = options.remove("*");
            this.options = Collections.unmodifiableSet(options);
        }

        public Set getOptions() {
            return this.options;
        }

        public boolean isCompatibleValue(Object value) {
            return this.wildcard ? value instanceof String : this.options.contains(value);
        }
    }

    public static final class IntegerKey
    extends Key {
        private final int number;

        public IntegerKey(int number) {
            super(Integer.class);
            this.number = number;
        }

        public int getDefault() {
            return this.number;
        }

        public int toValue(Hints hints) {
            if (hints != null) {
                Object value = hints.get(this);
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (value instanceof CharSequence) {
                    return Integer.parseInt(value.toString());
                }
            }
            return this.number;
        }

        public boolean isCompatibleValue(Object value) {
            if (value instanceof Short || value instanceof Integer) {
                return true;
            }
            if (value instanceof String || value instanceof InternationalString) {
                try {
                    Integer.parseInt(value.toString());
                }
                catch (NumberFormatException e) {
                    Logger.getLogger("org.geotools.factory").finer(e.toString());
                }
            }
            return false;
        }
    }

    public static final class FileKey
    extends Key {
        private final boolean writable;

        public FileKey(boolean writable) {
            super(File.class);
            this.writable = writable;
        }

        public boolean isCompatibleValue(Object value) {
            File file;
            if (value instanceof File) {
                file = (File)value;
            } else if (value instanceof String) {
                file = new File((String)value);
            } else {
                return false;
            }
            if (file.exists()) {
                return !this.writable || file.canWrite();
            }
            File parent = file.getParentFile();
            return parent != null && parent.canWrite();
        }
    }

    public static final class ClassKey
    extends Key {
        public ClassKey(Class classe) {
            super(classe);
        }

        ClassKey(String className) {
            super(className);
        }

        public boolean isCompatibleValue(Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof Class[]) {
                Class[] types = (Class[])value;
                for (int i = 0; i < types.length; ++i) {
                    if (this.isCompatibleValue(types[i])) continue;
                    return false;
                }
                return types.length != 0;
            }
            Class<?> type = value instanceof Class ? (Class<?>)value : value.getClass();
            return this.getValueClass().isAssignableFrom(type);
        }
    }

    public static class Key
    extends RenderingHints.Key {
        private static int count;
        private final String className;
        private transient Class valueClass;

        public Key(Class classe) {
            this(classe.getName());
            this.valueClass = classe;
        }

        Key(String className) {
            super(Key.count());
            this.className = className;
        }

        private static synchronized int count() {
            return count++;
        }

        public Class getValueClass() {
            if (this.valueClass == null) {
                try {
                    this.valueClass = Class.forName(this.className);
                }
                catch (ClassNotFoundException exception) {
                    Logging.unexpectedException("org.geotools.factory", Key.class, "getValueClass", (Throwable)exception);
                    this.valueClass = Object.class;
                }
            }
            return this.valueClass;
        }

        public boolean isCompatibleValue(Object value) {
            return this.getValueClass().isInstance(value);
        }

        public String toString() {
            int t = 0;
            block6: while (true) {
                Class type;
                switch (t++) {
                    case 0: {
                        type = Hints.class;
                        break;
                    }
                    case 1: {
                        type = this.getValueClass();
                        break;
                    }
                    default: {
                        return super.toString();
                    }
                }
                Field[] fields = type.getFields();
                int i = 0;
                while (true) {
                    block10: {
                        if (i >= fields.length) continue block6;
                        Field f = fields[i];
                        if (Modifier.isStatic(f.getModifiers())) {
                            Object v;
                            try {
                                v = f.get(null);
                            }
                            catch (IllegalAccessException e) {
                                break block10;
                            }
                            if (v == this) {
                                return f.getName();
                            }
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }
}

