/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.mediarss.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.mediarss.MediaEntryModuleImpl;
import com.sun.syndication.feed.module.mediarss.MediaModuleImpl;
import com.sun.syndication.feed.module.mediarss.types.Category;
import com.sun.syndication.feed.module.mediarss.types.Credit;
import com.sun.syndication.feed.module.mediarss.types.Expression;
import com.sun.syndication.feed.module.mediarss.types.Hash;
import com.sun.syndication.feed.module.mediarss.types.MediaContent;
import com.sun.syndication.feed.module.mediarss.types.MediaGroup;
import com.sun.syndication.feed.module.mediarss.types.Metadata;
import com.sun.syndication.feed.module.mediarss.types.PlayerReference;
import com.sun.syndication.feed.module.mediarss.types.Rating;
import com.sun.syndication.feed.module.mediarss.types.Restriction;
import com.sun.syndication.feed.module.mediarss.types.Text;
import com.sun.syndication.feed.module.mediarss.types.Thumbnail;
import com.sun.syndication.feed.module.mediarss.types.Time;
import com.sun.syndication.feed.module.mediarss.types.UrlReference;
import com.sun.syndication.io.ModuleParser;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public class MediaModuleParser
implements ModuleParser {
    private static final Logger LOG = Logger.getLogger(MediaModuleParser.class.getName());
    private static final Namespace NS = Namespace.getNamespace((String)"http://search.yahoo.com/mrss/");

    public String getNamespaceUri() {
        return "http://search.yahoo.com/mrss/";
    }

    public Module parse(Element mmRoot) {
        MediaModuleImpl mod = null;
        mod = mmRoot.getName().equals("channel") || mmRoot.getName().equals("feed") ? new MediaModuleImpl() : new MediaEntryModuleImpl();
        mod.setMetadata(this.parseMetadata(mmRoot));
        mod.setPlayer(this.parsePlayer(mmRoot));
        if (mod instanceof MediaEntryModuleImpl) {
            MediaEntryModuleImpl m = (MediaEntryModuleImpl)mod;
            m.setMediaContents(this.parseContent(mmRoot));
            m.setMediaGroups(this.parseGroup(mmRoot));
        }
        return mod;
    }

    private MediaContent[] parseContent(Element e) {
        List contents = e.getChildren("content", this.getNS());
        ArrayList<MediaContent> values = new ArrayList<MediaContent>();
        try {
            for (int i = 0; contents != null && i < contents.size(); ++i) {
                Element content = (Element)contents.get(i);
                MediaContent mc = null;
                if (content.getAttributeValue("url") != null) {
                    mc = new MediaContent(new UrlReference(new URL(content.getAttributeValue("url"))));
                    mc.setPlayer(this.parsePlayer(content));
                } else {
                    mc = new MediaContent(this.parsePlayer(content));
                }
                mc.setAudioChannels(content.getAttributeValue("channels") == null ? null : new Integer(content.getAttributeValue("channels")));
                mc.setBitrate(content.getAttributeValue("bitrate") == null ? null : new Float(content.getAttributeValue("bitrate")));
                mc.setDuration(content.getAttributeValue("duration") == null ? null : new Long(content.getAttributeValue("duration")));
                String expression = content.getAttributeValue("expression");
                if (expression != null) {
                    if (expression.equalsIgnoreCase("full")) {
                        mc.setExpression(Expression.FULL);
                    } else if (expression.equalsIgnoreCase("sample")) {
                        mc.setExpression(Expression.SAMPLE);
                    } else if (expression.equalsIgnoreCase("nonstop")) {
                        mc.setExpression(Expression.NONSTOP);
                    }
                }
                mc.setFileSize(content.getAttributeValue("fileSize") == null ? null : new Long(content.getAttributeValue("fileSize")));
                mc.setFramerate(content.getAttributeValue("framerate") == null ? null : new Float(content.getAttributeValue("framerate")));
                mc.setHeight(content.getAttributeValue("height") == null ? null : new Integer(content.getAttributeValue("height")));
                mc.setLanguage(content.getAttributeValue("lang"));
                mc.setMetadata(this.parseMetadata(content));
                mc.setSamplingrate(content.getAttributeValue("samplingrate") == null ? null : new Float(content.getAttributeValue("ramplingrate")));
                mc.setType(content.getAttributeValue("type"));
                mc.setWidth(content.getAttributeValue("width") == null ? null : new Integer(content.getAttributeValue("width")));
                mc.setDefaultContent(content.getAttributeValue("isDefault") == null ? false : Boolean.getBoolean(content.getAttributeValue("isDefault")));
                values.add(mc);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception parsing content tag.", ex);
        }
        return values.toArray(new MediaContent[values.size()]);
    }

    private MediaGroup[] parseGroup(Element e) {
        List groups = e.getChildren("group", this.getNS());
        ArrayList<MediaGroup> values = new ArrayList<MediaGroup>();
        for (int i = 0; groups != null && i < groups.size(); ++i) {
            Element group = (Element)groups.get(i);
            MediaGroup g = new MediaGroup(this.parseContent(group));
            for (int j = 0; j < g.getContents().length; ++j) {
                if (!g.getContents()[j].isDefaultContent()) continue;
                g.setDefaultContentIndex(new Integer(j));
                break;
            }
            g.setMetadata(this.parseMetadata(e));
            values.add(g);
        }
        return values.toArray(new MediaGroup[values.size()]);
    }

    private Metadata parseMetadata(Element e) {
        int i;
        int i2;
        Metadata md = new Metadata();
        List categories = e.getChildren("category", this.getNS());
        ArrayList<Object> values = new ArrayList<Object>();
        for (i2 = 0; categories != null && i2 < categories.size(); ++i2) {
            try {
                Element cat = (Element)categories.get(i2);
                values.add(new Category(cat.getAttributeValue("scheme"), cat.getAttributeValue("label"), cat.getText()));
                continue;
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Exception parsing category tag.", ex);
            }
        }
        md.setCategories(values.toArray(new Category[values.size()]));
        try {
            Element copy = e.getChild("copyright", this.getNS());
            if (copy != null) {
                md.setCopyright(copy.getText());
                md.setCopyrightUrl(copy.getAttributeValue("url") != null ? new URL(copy.getAttributeValue("url")) : null);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception parsing copyright tag.", ex);
        }
        List credits = e.getChildren("credit", this.getNS());
        values = new ArrayList();
        for (i2 = 0; credits != null && i2 < credits.size(); ++i2) {
            try {
                Element cred = (Element)credits.get(i2);
                values.add(new Credit(cred.getAttributeValue("scheme"), cred.getAttributeValue("role"), cred.getText()));
                md.setCredits(values.toArray(new Credit[values.size()]));
                continue;
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Exception parsing credit tag.", ex);
            }
        }
        try {
            Element description = e.getChild("description", this.getNS());
            if (description != null) {
                md.setDescription(description.getText());
                md.setDescriptionType(description.getAttributeValue("type"));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception parsing description tag.", ex);
        }
        try {
            Element hash = e.getChild("hash", this.getNS());
            if (hash != null) {
                md.setHash(new Hash(hash.getAttributeValue("algo"), hash.getText()));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Exception parsing hash tag.", ex);
        }
        Element keywords = e.getChild("keywords", this.getNS());
        if (keywords != null) {
            StringTokenizer tok = new StringTokenizer(keywords.getText(), ",");
            String[] value = new String[tok.countTokens()];
            int i3 = 0;
            while (tok.hasMoreTokens()) {
                value[i3] = tok.nextToken().trim();
                ++i3;
            }
            md.setKeywords(value);
        }
        List ratings = e.getChildren("rating", this.getNS());
        values = new ArrayList();
        for (i = 0; ratings != null && i < ratings.size(); ++i) {
            try {
                Element rat = (Element)ratings.get(i);
                values.add(new Rating(rat.getAttributeValue("scheme"), rat.getText()));
                continue;
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Exception parsing rating tag.", ex);
            }
        }
        md.setRatings(values.toArray(new Rating[values.size()]));
        List texts = e.getChildren("text", this.getNS());
        values = new ArrayList();
        for (i = 0; texts != null && i < texts.size(); ++i) {
            try {
                Element text = (Element)texts.get(i);
                Time start = text.getAttributeValue("start") == null ? null : new Time(text.getAttributeValue("start"));
                Time end = text.getAttributeValue("end") == null ? null : new Time(text.getAttributeValue("end"));
                values.add(new Text(text.getAttributeValue("type"), text.getTextTrim(), start, end));
                continue;
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Exception parsing text tag.", ex);
            }
        }
        md.setText(values.toArray(new Text[values.size()]));
        List thumbnails = e.getChildren("thumbnail", this.getNS());
        values = new ArrayList();
        for (i = 0; thumbnails != null && i < thumbnails.size(); ++i) {
            try {
                Element thumb = (Element)thumbnails.get(i);
                Time t = thumb.getAttributeValue("time") == null ? null : new Time(thumb.getAttributeValue("time"));
                Integer width = thumb.getAttributeValue("width") == null ? null : new Integer(thumb.getAttributeValue("width"));
                Integer height = thumb.getAttributeValue("height") == null ? null : new Integer(thumb.getAttributeValue("height"));
                values.add(new Thumbnail(new URL(thumb.getAttributeValue("url")), width, height, t));
                continue;
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Exception parsing thumbnail tag.", ex);
            }
        }
        md.setThumbnail(values.toArray(new Thumbnail[values.size()]));
        Element title = e.getChild("title", this.getNS());
        if (title != null) {
            md.setTitle(title.getText());
            md.setTitleType(title.getAttributeValue("type"));
        }
        List restrictions = e.getChildren("restriction", this.getNS());
        values = new ArrayList();
        for (i = 0; i < restrictions.size(); ++i) {
            Element r = (Element)restrictions.get(i);
            Restriction.Type type = null;
            if (r.getAttributeValue("type").equalsIgnoreCase("uri")) {
                type = Restriction.Type.URI;
            } else if (r.getAttributeValue("type").equalsIgnoreCase("country")) {
                type = Restriction.Type.COUNTRY;
            }
            Restriction.Relationship relationship = null;
            if (r.getAttributeValue("relationship").equalsIgnoreCase("allow")) {
                relationship = Restriction.Relationship.ALLOW;
            } else if (r.getAttributeValue("relationship").equalsIgnoreCase("deny")) {
                relationship = Restriction.Relationship.DENY;
            }
            Restriction value = new Restriction(relationship, type, r.getTextTrim());
            values.add(value);
        }
        md.setRestrictions(values.toArray(new Restriction[values.size()]));
        Element adult = e.getChild("adult", this.getNS());
        if (adult != null && md.getRatings().length == 0) {
            Rating[] r = new Rating[]{adult.getTextTrim().equals("true") ? new Rating("urn:simple", "adult") : new Rating("urn:simple", "nonadult")};
            md.setRatings(r);
        }
        return md;
    }

    private PlayerReference parsePlayer(Element e) {
        Element player = e.getChild("player", this.getNS());
        PlayerReference p = null;
        if (player != null) {
            Integer width = player.getAttributeValue("width") == null ? null : new Integer(player.getAttributeValue("width"));
            Integer height = player.getAttributeValue("height") == null ? null : new Integer(player.getAttributeValue("height"));
            try {
                p = new PlayerReference(new URL(player.getAttributeValue("url")), width, height);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Exception parsing player tag.", ex);
            }
        }
        return p;
    }

    public Namespace getNS() {
        return NS;
    }
}

