/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.io.Serializable;
import javax.vecmath.SingularMatrixException;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.operation.Matrix;

public class Matrix2
implements XMatrix,
Serializable {
    private static final long serialVersionUID = 7116561372481474290L;
    public static final int SIZE = 2;
    public double m00;
    public double m01;
    public double m10;
    public double m11;

    public Matrix2() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public Matrix2(double m00, double m01, double m10, double m11) {
        this.m00 = m00;
        this.m01 = m01;
        this.m10 = m10;
        this.m11 = m11;
    }

    public Matrix2(Matrix matrix) {
        if (matrix.getNumRow() != 2 || matrix.getNumCol() != 2) {
            throw new IllegalArgumentException(Errors.format(191));
        }
        this.m00 = matrix.getElement(0, 0);
        this.m01 = matrix.getElement(0, 1);
        this.m10 = matrix.getElement(1, 0);
        this.m11 = matrix.getElement(1, 1);
    }

    public final int getNumRow() {
        return 2;
    }

    public final int getNumCol() {
        return 2;
    }

    public final double getElement(int row, int col) {
        switch (row) {
            case 0: {
                switch (col) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                }
                break;
            }
            case 1: {
                switch (col) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                }
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public final void setElement(int row, int col, double value) {
        switch (row) {
            case 0: {
                switch (col) {
                    case 0: {
                        this.m00 = value;
                        return;
                    }
                    case 1: {
                        this.m01 = value;
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (col) {
                    case 0: {
                        this.m10 = value;
                        return;
                    }
                    case 1: {
                        this.m11 = value;
                        return;
                    }
                }
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public final void setZero() {
        this.m11 = 0.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m00 = 0.0;
    }

    public final void setIdentity() {
        this.m10 = 1.0;
        this.m01 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        assert (this.isIdentity());
    }

    public final boolean isIdentity() {
        return this.m01 == 0.0 && this.m10 == 0.0 && this.m00 == 1.0 && this.m11 == 1.0;
    }

    public final boolean isIdentity(double tolerance) {
        return GeneralMatrix.isIdentity(this, tolerance);
    }

    public final boolean isAffine() {
        return this.m10 == 0.0 && this.m11 == 1.0;
    }

    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
    }

    public final void transpose() {
        double swap = this.m10;
        this.m10 = this.m01;
        this.m01 = swap;
    }

    public final void invert() {
        double det = this.m00 * this.m11 - this.m01 * this.m10;
        if (det == 0.0) {
            throw new SingularMatrixException();
        }
        double swap = this.m00;
        this.m00 = this.m11 / det;
        this.m11 = swap / det;
        this.m10 = -this.m10 / det;
        this.m01 = -this.m01 / det;
    }

    public final void multiply(Matrix matrix) {
        Matrix2 k = matrix instanceof Matrix2 ? (Matrix2)matrix : new Matrix2(matrix);
        double m0 = this.m00;
        double m1 = this.m01;
        this.m00 = m0 * k.m00 + m1 * k.m10;
        this.m01 = m0 * k.m01 + m1 * k.m11;
        m0 = this.m10;
        m1 = this.m11;
        this.m10 = m0 * k.m00 + m1 * k.m10;
        this.m11 = m0 * k.m01 + m1 * k.m11;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            Matrix2 that = (Matrix2)object;
            return Double.doubleToLongBits(this.m00) == Double.doubleToLongBits(that.m00) && Double.doubleToLongBits(this.m01) == Double.doubleToLongBits(that.m01) && Double.doubleToLongBits(this.m10) == Double.doubleToLongBits(that.m10) && Double.doubleToLongBits(this.m11) == Double.doubleToLongBits(that.m11);
        }
        return false;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.m00) + 37L * Double.doubleToLongBits(this.m01) + 37L * Double.doubleToLongBits(this.m10) + 37L * Double.doubleToLongBits(this.m11) ^ 0x62C31ADCF5064EF2L);
    }

    public String toString() {
        return GeneralMatrix.toString(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

