/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.resources.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

public class AbstractReferenceSystem
extends AbstractIdentifiedObject
implements ReferenceSystem {
    private static final long serialVersionUID = 3337659819553899435L;
    private static final String[] LOCALIZABLES = new String[]{"scope"};
    private final Extent validArea;
    private final InternationalString scope;

    public AbstractReferenceSystem(ReferenceSystem object) {
        super((IdentifiedObject)object);
        this.validArea = object.getValidArea();
        this.scope = object.getScope();
    }

    public AbstractReferenceSystem(Map properties) {
        this(properties, new HashMap());
    }

    private AbstractReferenceSystem(Map properties, Map subProperties) {
        super(properties, subProperties, LOCALIZABLES);
        this.validArea = (Extent)subProperties.get("validArea");
        this.scope = (InternationalString)subProperties.get("scope");
    }

    public Extent getValidArea() {
        return this.validArea;
    }

    public InternationalString getScope() {
        return this.scope;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            if (!compareMetadata) {
                return true;
            }
            AbstractReferenceSystem that = (AbstractReferenceSystem)object;
            return Utilities.equals(this.validArea, that.validArea) && Utilities.equals(this.scope, that.scope);
        }
        return false;
    }
}

