/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.units.Unit;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.MatrixParameters;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

public class MatrixParameterDescriptors
extends DefaultParameterDescriptorGroup {
    private static final long serialVersionUID = -7386537348359343836L;
    public static final int DEFAULT_MATRIX_SIZE = 3;
    private static final int CACHE_SIZE = 8;
    private final ParameterDescriptor[] parameters = new ParameterDescriptor[64];
    protected final ParameterDescriptor numRow;
    protected final ParameterDescriptor numCol;
    protected final String prefix;
    protected final char separator;

    public MatrixParameterDescriptors(Map properties) {
        this(properties, new ParameterDescriptor[]{new DefaultParameterDescriptor("num_row", 3, 2, 50), new DefaultParameterDescriptor("num_col", 3, 2, 50)}, "elt_", '_');
    }

    public MatrixParameterDescriptors(Map properties, ParameterDescriptor[] parameters, String prefix, char separator) {
        super(properties, (GeneralParameterDescriptor[])parameters);
        if (parameters.length < 2) {
            throw new IllegalArgumentException();
        }
        this.numRow = parameters[0];
        this.numCol = parameters[1];
        MatrixParameterDescriptors.ensureNonNull("prefix", prefix);
        this.prefix = prefix;
        this.separator = separator;
    }

    static void checkIndice(String name, int index, int upper) throws IndexOutOfBoundsException {
        if (index < 0 || index >= upper) {
            throw new IndexOutOfBoundsException(Errors.format(42, name, new Integer(index)));
        }
    }

    public final GeneralParameterDescriptor descriptor(String name) throws ParameterNotFoundException {
        return this.descriptor(name, ((Number)((Object)this.numRow.getMaximumValue())).intValue(), ((Number)((Object)this.numCol.getMaximumValue())).intValue());
    }

    final GeneralParameterDescriptor descriptor(String name, int numRow, int numCol) throws ParameterNotFoundException {
        int split;
        MatrixParameterDescriptors.ensureNonNull("name", name);
        name = name.trim();
        RuntimeException cause = null;
        if (name.regionMatches(true, 0, this.prefix, 0, this.prefix.length()) && (split = name.indexOf(this.separator, this.prefix.length())) >= 0) {
            try {
                int row = Integer.parseInt(name.substring(this.prefix.length(), split));
                int col = Integer.parseInt(name.substring(split + 1));
                return this.descriptor(row, col, numRow, numCol);
            }
            catch (NumberFormatException exception) {
                cause = exception;
            }
            catch (IndexOutOfBoundsException exception) {
                cause = exception;
            }
        }
        try {
            return super.descriptor(name);
        }
        catch (ParameterNotFoundException exception) {
            if (cause != null) {
                try {
                    exception.initCause(cause);
                }
                catch (IllegalStateException ignore) {
                    // empty catch block
                }
            }
            throw exception;
        }
    }

    public final ParameterDescriptor descriptor(int row, int column) throws IndexOutOfBoundsException {
        return this.descriptor(row, column, ((Number)((Object)this.numRow.getMaximumValue())).intValue(), ((Number)((Object)this.numCol.getMaximumValue())).intValue());
    }

    final ParameterDescriptor descriptor(int row, int column, int numRow, int numCol) throws IndexOutOfBoundsException {
        ParameterDescriptor param;
        MatrixParameterDescriptors.checkIndice("row", row, numRow);
        MatrixParameterDescriptors.checkIndice("column", column, numCol);
        int index = -1;
        if (row < 8 && column < 8 && (param = this.parameters[index = row * 8 + column]) != null) {
            return param;
        }
        param = new DefaultParameterDescriptor(Collections.singletonMap("name", this.prefix + row + this.separator + column), Double.TYPE, null, Parameter.wrap(row == column ? 1.0 : 0.0), null, null, Unit.ONE, true);
        if (index >= 0) {
            this.parameters[index] = param;
        }
        return param;
    }

    public final List descriptors() {
        return this.descriptors(((Number)this.numRow.getDefaultValue()).intValue(), ((Number)this.numCol.getDefaultValue()).intValue());
    }

    final List descriptors(int numRow, int numCol) {
        Object[] parameters = new ParameterDescriptor[numRow * numCol + 2];
        int k = 0;
        parameters[k++] = this.numRow;
        parameters[k++] = this.numCol;
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                parameters[k++] = this.descriptor(j, i, numRow, numCol);
            }
        }
        assert (k == parameters.length) : k;
        return new UnmodifiableArrayList(parameters);
    }

    public GeneralParameterValue createValue() {
        return new MatrixParameters(this);
    }

    public Matrix getMatrix(ParameterValueGroup parameters) throws InvalidParameterNameException {
        if (parameters instanceof MatrixParameters) {
            return ((MatrixParameters)parameters).getMatrix();
        }
        ParameterValue numRowParam = parameters.parameter(this.numRow.getName().toString());
        ParameterValue numColParam = parameters.parameter(this.numCol.getName().toString());
        int numRow = numRowParam.intValue();
        int numCol = numColParam.intValue();
        XMatrix matrix = MatrixFactory.create(numRow, numCol);
        List params = parameters.values();
        if (params != null) {
            for (GeneralParameterValue param : params) {
                int split;
                if (param == numRowParam || param == numColParam) continue;
                RuntimeException cause = null;
                String name = param.getDescriptor().getName().toString();
                if (name.regionMatches(true, 0, this.prefix, 0, this.prefix.length()) && (split = name.indexOf(this.separator, this.prefix.length())) >= 0) {
                    try {
                        int row = Integer.parseInt(name.substring(this.prefix.length(), split));
                        int col = Integer.parseInt(name.substring(split + 1));
                        matrix.setElement(row, col, ((ParameterValue)param).doubleValue());
                        continue;
                    }
                    catch (NumberFormatException exception) {
                        cause = exception;
                    }
                    catch (IndexOutOfBoundsException exception) {
                        cause = exception;
                    }
                }
                InvalidParameterNameException exception = new InvalidParameterNameException(Errors.format(129, name), name);
                if (cause != null) {
                    exception.initCause(cause);
                }
                throw exception;
            }
        }
        return matrix;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            MatrixParameterDescriptors that = (MatrixParameterDescriptors)object;
            return this.separator == that.separator && Utilities.equals(this.prefix, that.prefix);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.prefix.hashCode() ^ 37 * this.separator;
    }
}

