/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.postgis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernatespatial.AbstractDBGeometryType;
import org.hibernatespatial.HBSpatialExtension;
import org.hibernatespatial.mgeom.MCoordinate;
import org.hibernatespatial.mgeom.MGeometry;
import org.hibernatespatial.mgeom.MLineString;
import org.hibernatespatial.mgeom.MultiMLineString;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import org.postgis.PGbox2d;
import org.postgis.PGboxbase;
import org.postgis.PGgeometry;
import org.postgis.Point;
import org.postgresql.util.PGobject;

public class PGGeometryUserType
extends AbstractDBGeometryType {
    private static final int[] geometryTypes = new int[]{2002};
    private static Pattern boxPattern = Pattern.compile(".*box.*\\((.*)\\)", 2);

    public int[] sqlTypes() {
        return geometryTypes;
    }

    public com.vividsolutions.jts.geom.Geometry convert2JTS(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Geometry) {
            object = new PGgeometry((Geometry)object);
        }
        if (object instanceof PGgeometry) {
            PGgeometry geom = (PGgeometry)object;
            com.vividsolutions.jts.geom.Point out = null;
            switch (geom.getGeoType()) {
                case 1: {
                    out = this.convertPoint((Point)geom.getGeometry());
                    break;
                }
                case 2: {
                    out = this.convertLineString((LineString)geom.getGeometry());
                    break;
                }
                case 3: {
                    out = this.convertPolygon((org.postgis.Polygon)geom.getGeometry());
                    break;
                }
                case 5: {
                    out = this.convertMultiLineString((MultiLineString)geom.getGeometry());
                    break;
                }
                case 4: {
                    out = this.convertMultiPoint((org.postgis.MultiPoint)geom.getGeometry());
                    break;
                }
                case 6: {
                    out = this.convertMultiPolygon((MultiPolygon)geom.getGeometry());
                    break;
                }
                case 7: {
                    out = this.convertGeometryCollection((org.postgis.GeometryCollection)geom.getGeometry());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type of PGgeometry");
                }
            }
            out.setSRID(geom.getGeometry().srid);
            return out;
        }
        if (object instanceof PGboxbase) {
            return this.convertBox((PGboxbase)object);
        }
        if (object instanceof PGobject && ((PGobject)object).getType().contains("box")) {
            PGobject pgo = (PGobject)object;
            String boxStr = this.extractBoxString(pgo);
            if (boxStr == null) {
                throw new IllegalArgumentException("Can't convert object: " + pgo.getType() + " : " + pgo.getValue());
            }
            String[] pointsStr = boxStr.split(",");
            Point ll = this.toPoint(pointsStr[0]);
            Point ur = this.toPoint(pointsStr[1]);
            return this.cornerPointsToPolygon(ll, ur, false);
        }
        if (object instanceof PGobject && (((PGobject)object).getType().equals("geometry") || ((PGobject)object).getType().equals("geography"))) {
            return this.convertFromPGobject((PGobject)object);
        }
        throw new IllegalArgumentException("Can't convert object of type " + object.getClass().getCanonicalName());
    }

    private com.vividsolutions.jts.geom.Geometry convertFromPGobject(PGobject object) {
        String value = object.getValue();
        try {
            PGgeometry pg = new PGgeometry(value);
            return this.convert2JTS(pg);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Can't convert PGobject of type " + object.getType());
        }
    }

    private Point toPoint(String s) {
        String[] coords = s.split("\\s");
        double x = Double.parseDouble(coords[0]);
        double y = Double.parseDouble(coords[1]);
        return new Point(x, y);
    }

    private String extractBoxString(PGobject pgo) {
        String boxStr = null;
        Matcher m = boxPattern.matcher(pgo.getValue());
        if (m.matches() && m.groupCount() >= 1) {
            boxStr = m.group(1);
        }
        return boxStr;
    }

    private com.vividsolutions.jts.geom.Geometry convertBox(PGboxbase box) {
        Point ll = box.getLLB();
        Point ur = box.getURT();
        Coordinate[] ringCoords = new Coordinate[5];
        boolean is3D = true;
        if (box instanceof PGbox2d) {
            is3D = false;
        }
        return this.cornerPointsToPolygon(ll, ur, is3D);
    }

    private com.vividsolutions.jts.geom.Geometry cornerPointsToPolygon(Point ll, Point ur, boolean is3D) {
        Coordinate[] ringCoords = new Coordinate[]{is3D ? new Coordinate(ll.x, ll.y, ll.z) : new Coordinate(ll.x, ll.y), is3D ? new Coordinate(ur.x, ll.y, ll.z) : new Coordinate(ur.x, ll.y), is3D ? new Coordinate(ur.x, ur.y, ur.z) : new Coordinate(ur.x, ur.y), is3D ? new Coordinate(ll.x, ur.y, ur.z) : new Coordinate(ll.x, ur.y), is3D ? new Coordinate(ll.x, ll.y, ll.z) : new Coordinate(ll.x, ll.y)};
        LinearRing shell = this.getGeometryFactory().createLinearRing(ringCoords);
        return this.getGeometryFactory().createPolygon(shell, null);
    }

    private com.vividsolutions.jts.geom.Geometry convertGeometryCollection(org.postgis.GeometryCollection collection) {
        Geometry[] geometries = collection.getGeometries();
        com.vividsolutions.jts.geom.Geometry[] jtsGeometries = new com.vividsolutions.jts.geom.Geometry[geometries.length];
        for (int i = 0; i < geometries.length; ++i) {
            jtsGeometries[i] = this.convert2JTS(geometries[i]);
            jtsGeometries[i].setSRID(0);
        }
        GeometryCollection jtsGCollection = this.getGeometryFactory().createGeometryCollection(jtsGeometries);
        return jtsGCollection;
    }

    private com.vividsolutions.jts.geom.Geometry convertMultiPolygon(MultiPolygon pgMultiPolygon) {
        Polygon[] polygons = new Polygon[pgMultiPolygon.numPolygons()];
        for (int i = 0; i < polygons.length; ++i) {
            org.postgis.Polygon pgPolygon = pgMultiPolygon.getPolygon(i);
            polygons[i] = (Polygon)this.convertPolygon(pgPolygon);
        }
        com.vividsolutions.jts.geom.MultiPolygon out = this.getGeometryFactory().createMultiPolygon(polygons);
        return out;
    }

    private com.vividsolutions.jts.geom.Geometry convertMultiPoint(org.postgis.MultiPoint pgMultiPoint) {
        com.vividsolutions.jts.geom.Point[] points = new com.vividsolutions.jts.geom.Point[pgMultiPoint.numPoints()];
        for (int i = 0; i < points.length; ++i) {
            points[i] = this.convertPoint(pgMultiPoint.getPoint(i));
        }
        MultiPoint out = this.getGeometryFactory().createMultiPoint(points);
        out.setSRID(pgMultiPoint.srid);
        return out;
    }

    private com.vividsolutions.jts.geom.Geometry convertMultiLineString(MultiLineString mlstr) {
        MultiMLineString out;
        if (mlstr.haveMeasure) {
            MLineString[] lstrs = new MLineString[mlstr.numLines()];
            for (int i = 0; i < mlstr.numLines(); ++i) {
                MCoordinate[] coordinates = this.toJTSCoordinates(mlstr.getLine(i).getPoints());
                lstrs[i] = this.getGeometryFactory().createMLineString(coordinates);
            }
            out = this.getGeometryFactory().createMultiMLineString(lstrs);
        } else {
            com.vividsolutions.jts.geom.LineString[] lstrs = new com.vividsolutions.jts.geom.LineString[mlstr.numLines()];
            for (int i = 0; i < mlstr.numLines(); ++i) {
                lstrs[i] = this.getGeometryFactory().createLineString((Coordinate[])this.toJTSCoordinates(mlstr.getLine(i).getPoints()));
            }
            out = this.getGeometryFactory().createMultiLineString(lstrs);
        }
        return out;
    }

    protected com.vividsolutions.jts.geom.Geometry convertPolygon(org.postgis.Polygon polygon) {
        LinearRing shell = this.getGeometryFactory().createLinearRing((Coordinate[])this.toJTSCoordinates(polygon.getRing(0).getPoints()));
        Polygon out = null;
        if (polygon.numRings() > 1) {
            LinearRing[] rings = new LinearRing[polygon.numRings() - 1];
            for (int r = 1; r < polygon.numRings(); ++r) {
                rings[r - 1] = this.getGeometryFactory().createLinearRing((Coordinate[])this.toJTSCoordinates(polygon.getRing(r).getPoints()));
            }
            out = this.getGeometryFactory().createPolygon(shell, rings);
        } else {
            out = this.getGeometryFactory().createPolygon(shell, null);
        }
        return out;
    }

    protected com.vividsolutions.jts.geom.Point convertPoint(Point pnt) {
        com.vividsolutions.jts.geom.Point g = this.getGeometryFactory().createPoint((Coordinate)this.toJTSCoordinate(pnt));
        return g;
    }

    protected com.vividsolutions.jts.geom.LineString convertLineString(LineString lstr) {
        MLineString out = lstr.haveMeasure ? this.getGeometryFactory().createMLineString(this.toJTSCoordinates(lstr.getPoints())) : this.getGeometryFactory().createLineString((Coordinate[])this.toJTSCoordinates(lstr.getPoints()));
        return out;
    }

    private MCoordinate[] toJTSCoordinates(Point[] points) {
        MCoordinate[] coordinates = new MCoordinate[points.length];
        for (int i = 0; i < points.length; ++i) {
            coordinates[i] = this.toJTSCoordinate(points[i]);
        }
        return coordinates;
    }

    private MCoordinate toJTSCoordinate(Point pt) {
        MCoordinate mc = pt.dimension == 2 ? (pt.haveMeasure ? MCoordinate.create2dWithMeasure((double)pt.getX(), (double)pt.getY(), (double)pt.getM()) : MCoordinate.create2d((double)pt.getX(), (double)pt.getY())) : (pt.haveMeasure ? MCoordinate.create3dWithMeasure((double)pt.getX(), (double)pt.getY(), (double)pt.getZ(), (double)pt.getM()) : MCoordinate.create3d((double)pt.getX(), (double)pt.getY(), (double)pt.getZ()));
        return mc;
    }

    private Point[] toPoints(Coordinate[] coordinates) {
        Point[] points = new Point[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate c = coordinates[i];
            Point pt = Double.isNaN(c.z) ? new Point(c.x, c.y) : new Point(c.x, c.y, c.z);
            if (c instanceof MCoordinate) {
                MCoordinate mc = (MCoordinate)c;
                if (!Double.isNaN(mc.m)) {
                    pt.setM(mc.m);
                }
            }
            points[i] = pt;
        }
        return points;
    }

    public Object conv2DBGeometry(com.vividsolutions.jts.geom.Geometry jtsGeom, Connection connection) {
        Point geom = null;
        if ((jtsGeom = this.forceEmptyToGeometryCollection(jtsGeom)) instanceof com.vividsolutions.jts.geom.Point) {
            geom = this.convertJTSPoint((com.vividsolutions.jts.geom.Point)jtsGeom);
        } else if (jtsGeom instanceof com.vividsolutions.jts.geom.LineString) {
            geom = this.convertJTSLineString((com.vividsolutions.jts.geom.LineString)jtsGeom);
        } else if (jtsGeom instanceof com.vividsolutions.jts.geom.MultiLineString) {
            geom = this.convertJTSMultiLineString((com.vividsolutions.jts.geom.MultiLineString)jtsGeom);
        } else if (jtsGeom instanceof Polygon) {
            geom = this.convertJTSPolygon((Polygon)jtsGeom);
        } else if (jtsGeom instanceof MultiPoint) {
            geom = this.convertJTSMultiPoint((MultiPoint)jtsGeom);
        } else if (jtsGeom instanceof com.vividsolutions.jts.geom.MultiPolygon) {
            geom = this.convertJTSMultiPolygon((com.vividsolutions.jts.geom.MultiPolygon)jtsGeom);
        } else if (jtsGeom instanceof GeometryCollection) {
            geom = this.convertJTSGeometryCollection((GeometryCollection)jtsGeom);
        }
        if (geom != null) {
            return new PGgeometry((Geometry)geom);
        }
        throw new UnsupportedOperationException("Conversion of " + jtsGeom.getClass().getSimpleName() + " to PGgeometry not supported");
    }

    private com.vividsolutions.jts.geom.Geometry forceEmptyToGeometryCollection(com.vividsolutions.jts.geom.Geometry jtsGeom) {
        com.vividsolutions.jts.geom.Geometry forced = jtsGeom;
        if (forced.isEmpty()) {
            GeometryFactory factory = jtsGeom.getFactory();
            if (factory == null) {
                factory = HBSpatialExtension.getDefaultGeomFactory();
            }
            forced = factory.createGeometryCollection(null);
            forced.setSRID(jtsGeom.getSRID());
        }
        return forced;
    }

    private MultiPolygon convertJTSMultiPolygon(com.vividsolutions.jts.geom.MultiPolygon multiPolygon) {
        org.postgis.Polygon[] pgPolygons = new org.postgis.Polygon[multiPolygon.getNumGeometries()];
        for (int i = 0; i < pgPolygons.length; ++i) {
            pgPolygons[i] = this.convertJTSPolygon((Polygon)multiPolygon.getGeometryN(i));
        }
        MultiPolygon mpg = new MultiPolygon(pgPolygons);
        mpg.setSrid(multiPolygon.getSRID());
        return mpg;
    }

    private org.postgis.MultiPoint convertJTSMultiPoint(MultiPoint multiPoint) {
        Point[] pgPoints = new Point[multiPoint.getNumGeometries()];
        for (int i = 0; i < pgPoints.length; ++i) {
            pgPoints[i] = this.convertJTSPoint((com.vividsolutions.jts.geom.Point)multiPoint.getGeometryN(i));
        }
        org.postgis.MultiPoint mp = new org.postgis.MultiPoint(pgPoints);
        mp.setSrid(multiPoint.getSRID());
        return mp;
    }

    private org.postgis.Polygon convertJTSPolygon(Polygon jtsPolygon) {
        int numRings = jtsPolygon.getNumInteriorRing();
        org.postgis.LinearRing[] rings = new org.postgis.LinearRing[numRings + 1];
        rings[0] = this.convertJTSLineStringToLinearRing(jtsPolygon.getExteriorRing());
        for (int i = 0; i < numRings; ++i) {
            rings[i + 1] = this.convertJTSLineStringToLinearRing(jtsPolygon.getInteriorRingN(i));
        }
        org.postgis.Polygon polygon = new org.postgis.Polygon(rings);
        polygon.setSrid(jtsPolygon.getSRID());
        return polygon;
    }

    private org.postgis.LinearRing convertJTSLineStringToLinearRing(com.vividsolutions.jts.geom.LineString lineString) {
        org.postgis.LinearRing lr = new org.postgis.LinearRing(this.toPoints(lineString.getCoordinates()));
        lr.setSrid(lineString.getSRID());
        return lr;
    }

    private LineString convertJTSLineString(com.vividsolutions.jts.geom.LineString string) {
        LineString ls = new LineString(this.toPoints(string.getCoordinates()));
        if (string instanceof MGeometry) {
            ls.haveMeasure = true;
        }
        ls.setSrid(string.getSRID());
        return ls;
    }

    private MultiLineString convertJTSMultiLineString(com.vividsolutions.jts.geom.MultiLineString string) {
        LineString[] lines = new LineString[string.getNumGeometries()];
        for (int i = 0; i < string.getNumGeometries(); ++i) {
            lines[i] = new LineString(this.toPoints(string.getGeometryN(i).getCoordinates()));
        }
        MultiLineString mls = new MultiLineString(lines);
        if (string instanceof MGeometry) {
            mls.haveMeasure = true;
        }
        mls.setSrid(string.getSRID());
        return mls;
    }

    private Point convertJTSPoint(com.vividsolutions.jts.geom.Point point) {
        Point pgPoint = new Point();
        pgPoint.srid = point.getSRID();
        pgPoint.x = point.getX();
        pgPoint.y = point.getY();
        Coordinate coordinate = point.getCoordinate();
        if (Double.isNaN(coordinate.z)) {
            pgPoint.dimension = 2;
        } else {
            pgPoint.z = coordinate.z;
            pgPoint.dimension = 3;
        }
        pgPoint.haveMeasure = false;
        if (coordinate instanceof MCoordinate && !Double.isNaN(((MCoordinate)coordinate).m)) {
            pgPoint.m = ((MCoordinate)coordinate).m;
            pgPoint.haveMeasure = true;
        }
        return pgPoint;
    }

    private org.postgis.GeometryCollection convertJTSGeometryCollection(GeometryCollection collection) {
        Geometry[] pgCollections = new Geometry[collection.getNumGeometries()];
        for (int i = 0; i < pgCollections.length; ++i) {
            com.vividsolutions.jts.geom.Geometry currentGeom = collection.getGeometryN(i);
            if ((currentGeom = this.forceEmptyToGeometryCollection(currentGeom)).getClass() == com.vividsolutions.jts.geom.LineString.class) {
                pgCollections[i] = this.convertJTSLineString((com.vividsolutions.jts.geom.LineString)currentGeom);
                continue;
            }
            if (currentGeom.getClass() == LinearRing.class) {
                pgCollections[i] = this.convertJTSLineStringToLinearRing((com.vividsolutions.jts.geom.LineString)((LinearRing)currentGeom));
                continue;
            }
            if (currentGeom.getClass() == com.vividsolutions.jts.geom.MultiLineString.class) {
                pgCollections[i] = this.convertJTSMultiLineString((com.vividsolutions.jts.geom.MultiLineString)currentGeom);
                continue;
            }
            if (currentGeom.getClass() == MultiPoint.class) {
                pgCollections[i] = this.convertJTSMultiPoint((MultiPoint)currentGeom);
                continue;
            }
            if (currentGeom.getClass() == com.vividsolutions.jts.geom.MultiPolygon.class) {
                pgCollections[i] = this.convertJTSMultiPolygon((com.vividsolutions.jts.geom.MultiPolygon)currentGeom);
                continue;
            }
            if (currentGeom.getClass() == com.vividsolutions.jts.geom.Point.class) {
                pgCollections[i] = this.convertJTSPoint((com.vividsolutions.jts.geom.Point)currentGeom);
                continue;
            }
            if (currentGeom.getClass() == Polygon.class) {
                pgCollections[i] = this.convertJTSPolygon((Polygon)currentGeom);
                continue;
            }
            if (currentGeom.getClass() != GeometryCollection.class) continue;
            pgCollections[i] = this.convertJTSGeometryCollection((GeometryCollection)currentGeom);
        }
        org.postgis.GeometryCollection gc = new org.postgis.GeometryCollection(pgCollections);
        gc.setSrid(collection.getSRID());
        return gc;
    }
}

