/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.event.AbstractGTComponent;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.resources.Utilities;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.StyleVisitor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.util.Cloneable;

public class FillImpl
extends AbstractGTComponent
implements Fill,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private FilterFactory filterFactory;
    private Expression color = null;
    private Expression backgroundColor = null;
    private Expression opacity = null;
    private Graphic graphicFill = null;

    protected FillImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public FillImpl(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public Expression getColor() {
        return this.color;
    }

    public void setColor(Expression rgb) {
        if (this.color == rgb) {
            return;
        }
        Expression old = this.color;
        this.color = rgb;
        this.fireChildChanged("color", rgb, old);
    }

    public void setColor(String rgb) {
        if (this.color.toString() == rgb) {
            return;
        }
        this.setColor((Expression)this.filterFactory.literal((Object)rgb));
    }

    public Expression getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Expression rgb) {
        if (this.backgroundColor == rgb) {
            return;
        }
        Expression old = this.backgroundColor;
        this.backgroundColor = rgb;
        this.fireChildChanged("backgroundColor", rgb, old);
    }

    public void setBackgroundColor(String rgb) {
        LOGGER.fine("setting bg color with " + rgb + " as a string");
        if (this.backgroundColor.toString() == rgb) {
            return;
        }
        this.setBackgroundColor((Expression)this.filterFactory.literal((Object)rgb));
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Expression opacity) {
        if (this.opacity == opacity) {
            return;
        }
        Expression old = this.opacity;
        this.opacity = opacity;
        this.fireChildChanged("opacity", opacity, old);
    }

    public void setOpacity(String opacity) {
        if (this.opacity.toString() == opacity) {
            return;
        }
        this.setOpacity((Expression)this.filterFactory.literal((Object)opacity));
    }

    public Graphic getGraphicFill() {
        return this.graphicFill;
    }

    public void setGraphicFill(Graphic graphicFill) {
        if (this.graphicFill == graphicFill) {
            return;
        }
        Graphic old = this.graphicFill;
        this.graphicFill = graphicFill;
        this.fireChildChanged("graphicFill", graphicFill, old);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Fill)this);
    }

    public Object clone() {
        try {
            FillImpl clone = (FillImpl)super.clone();
            if (this.graphicFill != null) {
                clone.graphicFill = (Graphic)((Cloneable)this.graphicFill).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone FillImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.color != null) {
            result = 1000003 * result + this.color.hashCode();
        }
        if (this.backgroundColor != null) {
            result = 1000003 * result + this.backgroundColor.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        if (this.graphicFill != null) {
            result = 1000003 * result + this.graphicFill.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof FillImpl) {
            FillImpl other = (FillImpl)oth;
            return Utilities.equals((Object)this.color, (Object)other.color) && Utilities.equals((Object)this.backgroundColor, (Object)other.backgroundColor) && Utilities.equals((Object)this.opacity, (Object)other.opacity) && Utilities.equals((Object)this.graphicFill, (Object)other.graphicFill);
        }
        return false;
    }
}

