/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.AbstractFilterVisitor;

public class Collection_CountFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.filter.function");
    FeatureCollection previousFeatureCollection = null;
    Object count = null;

    public Collection_CountFunction() {
        super("Collection_Count");
    }

    public int getArgCount() {
        return 1;
    }

    public static CalcResult calculateCount(FeatureCollection collection) throws IllegalFilterException, IOException {
        CountVisitor countVisitor = new CountVisitor();
        collection.accepts((FeatureVisitor)countVisitor, null);
        return countVisitor.getResult();
    }

    public void setParameters(List args) {
        super.setParameters(args);
        Expression expr = (Expression)this.getExpression(0);
        expr.accept((FilterVisitor)new AbstractFilterVisitor(){

            public void visit(AttributeExpression expression) {
                String xpath = expression.getAttributePath();
                if (xpath.startsWith("featureMembers/*/")) {
                    xpath = xpath.substring(17);
                } else if (xpath.startsWith("featureMember/*/")) {
                    xpath = xpath.substring(16);
                }
                try {
                    expression.setAttributePath(xpath);
                }
                catch (IllegalFilterException illegalFilterException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Object feature) {
        FeatureCollection featureCollection;
        if (feature == null) {
            return new Integer(0);
        }
        FeatureCollection featureCollection2 = featureCollection = (FeatureCollection)feature;
        synchronized (featureCollection2) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.count = null;
                try {
                    CalcResult result = Collection_CountFunction.calculateCount(featureCollection);
                    if (result != null) {
                        this.count = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.count;
    }
}

