/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.feature.Feature;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.opengis.feature.type.FeatureCollectionType;
import org.opengis.filter.expression.Expression;

public class StandardDeviationVisitor
implements FeatureCalc {
    private Expression expr;
    private int count = 0;
    private double deviationSquaredSum = 0.0;
    private double average = 0.0;
    boolean visited = false;
    int countNull = 0;
    int countNaN = 0;

    public StandardDeviationVisitor(Expression expr, double average) {
        this.expr = expr;
        this.average = average;
    }

    public void init(FeatureCollectionType collection) {
    }

    public CalcResult getResult() {
        return new AbstractCalcResult(){

            public Object getValue() {
                if (StandardDeviationVisitor.this.count == 0) {
                    return null;
                }
                return new Double(Math.sqrt(StandardDeviationVisitor.this.deviationSquaredSum / (double)StandardDeviationVisitor.this.count));
            }
        };
    }

    public void visit(Feature feature) {
        this.visit((org.opengis.feature.Feature)feature);
    }

    public void visit(org.opengis.feature.Feature feature) {
        double doubleVal;
        Object value = this.expr.evaluate((Object)feature);
        if (value == null) {
            ++this.countNull;
            return;
        }
        if (value instanceof Double && (Double.isNaN(doubleVal = ((Double)value).doubleValue()) || Double.isInfinite(doubleVal))) {
            ++this.countNaN;
            return;
        }
        ++this.count;
        this.deviationSquaredSum += Math.pow(this.average - Double.parseDouble(value.toString()), 2.0);
    }

    public void reset() {
        this.count = 0;
        this.countNull = 0;
        this.countNaN = 0;
        this.deviationSquaredSum = 0.0;
        this.average = 0.0;
    }

    public int getNaNCount() {
        return this.countNaN;
    }

    public int getNullCount() {
        return this.countNull;
    }
}

