/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.helper;

import com.vividsolutions.jts.geom.Point;

public class URLUtils {
    public static final String GOOGLE_MAP_BASE_URL = "https://www.google.fr/maps/preview#!q=";
    public static final String DEFAULT_GOOGLE_MAP_BASE_URL = "https://www.google.fr/maps/preview#";
    public static final String YAHOO_MAP_BASE_URL = "http://maps.yahoo.com/place/?";
    public static final String DEFAULT_YAHOO_MAP_BASE_URL = "http://maps.yahoo.com/";
    public static final String OPENSTREETMAP_MAP_BASE_URL = "http://www.openstreetmap.org/#map=14/";
    public static final String OPENSTREETMAP_MAP_STREET_BASE_URL = "http://www.openstreetmap.org/#map=19/";
    public static final String DEFAULT_OPENSTREETMAP_MAP_BASE_URL = "http://www.openstreetmap.org/";
    public static final String COUNTRY_FLAG_BASE_URL = "/images/flags/";
    public static final String DEFAULT_COUNTRY_FLAG_URL = "/images/flags/default.png";

    public static String createGoogleMapUrl(Point point) {
        if (point == null) {
            return DEFAULT_GOOGLE_MAP_BASE_URL;
        }
        try {
            StringBuffer sb = new StringBuffer(GOOGLE_MAP_BASE_URL);
            sb.append(point.getY() + 0.03).append("+").append(point.getX());
            return sb.toString();
        }
        catch (Exception e) {
            return DEFAULT_GOOGLE_MAP_BASE_URL;
        }
    }

    public static String createYahooMapUrl(Point point) {
        if (point == null) {
            return DEFAULT_YAHOO_MAP_BASE_URL;
        }
        StringBuffer sb = new StringBuffer(YAHOO_MAP_BASE_URL).append("lat=").append(point.getY()).append("&amp;lon=").append(point.getX());
        return sb.toString();
    }

    public static String createOpenstreetmapMapUrl(Point point) {
        if (point == null) {
            return DEFAULT_OPENSTREETMAP_MAP_BASE_URL;
        }
        StringBuffer sb = new StringBuffer(OPENSTREETMAP_MAP_BASE_URL).append(point.getY()).append("/").append(point.getX());
        return sb.toString();
    }

    public static String createOpenstreetmapMapUrlForStreet(Point point) {
        if (point == null) {
            return DEFAULT_OPENSTREETMAP_MAP_BASE_URL;
        }
        StringBuffer sb = new StringBuffer(OPENSTREETMAP_MAP_STREET_BASE_URL).append(point.getY()).append("/").append(point.getX());
        return sb.toString();
    }

    public static String createCountryFlagUrl(String countryCode) {
        if (countryCode == null) {
            return DEFAULT_COUNTRY_FLAG_URL;
        }
        StringBuffer sb = new StringBuffer(COUNTRY_FLAG_BASE_URL);
        sb.append(countryCode.toUpperCase()).append(".png");
        return sb.toString();
    }
}

