/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.addressparser.web;

import com.gisgraphy.addressparser.Address;
import com.gisgraphy.addressparser.AddressQuery;
import com.gisgraphy.addressparser.StructuredAddressQuery;
import com.gisgraphy.addressparser.exception.AddressParserException;
import com.gisgraphy.domain.valueobject.GisgraphyServiceType;
import com.gisgraphy.geoloc.GeolocSearchException;
import com.gisgraphy.helper.GeolocHelper;
import com.gisgraphy.helper.IntrospectionHelper;
import com.gisgraphy.helper.OutputFormatHelper;
import com.gisgraphy.serializer.common.OutputFormat;
import com.vividsolutions.jts.geom.Point;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AddressQueryHttpBuilder {
    private static AddressQueryHttpBuilder instance = new AddressQueryHttpBuilder();
    private static Map<String, String> parameterNameToAddressFields = new HashMap<String, String>(){
        {
            for (String fieldName : IntrospectionHelper.getFieldsAsList(Address.class)) {
                this.put(fieldName.toLowerCase(), fieldName);
            }
        }
    };

    public static AddressQueryHttpBuilder getInstance() {
        return instance;
    }

    public AddressQuery buildFromRequest(HttpServletRequest req) {
        double radius;
        String adressParameter;
        StructuredAddressQuery query = null;
        if (req == null) {
            throw new AddressParserException("could not build address query from a null HTTP request");
        }
        String countryParameter = req.getParameter("country");
        if (countryParameter == null || countryParameter.trim().length() == 0) {
            countryParameter = null;
        }
        if ((adressParameter = req.getParameter("address")) == null) {
            Address address = this.buildAddressFromRequest(req);
            if (address == null) {
                throw new AddressParserException("no structured address, nor address parameter is specified");
            }
            query = new StructuredAddressQuery(address, countryParameter);
        } else {
            if ("".equals(adressParameter.trim())) {
                throw new AddressParserException("'address' could not be empty, please specify a valid parameter or some valid address fields");
            }
            if (adressParameter.length() > 400) {
                throw new AddressParserException("address is limited to 400 characters");
            }
            query = new AddressQuery(adressParameter, countryParameter);
        }
        OutputFormat outputFormat = OutputFormat.getFromString((String)req.getParameter("format"));
        outputFormat = OutputFormatHelper.getDefaultForServiceIfNotSupported(outputFormat, GisgraphyServiceType.ADDRESS_PARSER);
        query.setFormat(outputFormat);
        String callbackParameter = req.getParameter("callback");
        if (callbackParameter != null) {
            query.setCallback(callbackParameter);
        }
        if ("true".equalsIgnoreCase(req.getParameter("indent")) || "on".equalsIgnoreCase(req.getParameter("indent"))) {
            query.setIndent(true);
        }
        if ("true".equalsIgnoreCase(req.getParameter("postal")) || "on".equalsIgnoreCase(req.getParameter("postal"))) {
            query.setPostal(true);
        }
        if ("true".equalsIgnoreCase(req.getParameter("standardize")) || "on".equalsIgnoreCase(req.getParameter("standardize"))) {
            query.setStandardize(true);
        }
        if ("true".equalsIgnoreCase(req.getParameter("fuzzy")) || "on".equalsIgnoreCase(req.getParameter("fuzzy"))) {
            query.withFuzzy(true);
        }
        String apiKey = req.getParameter("apikey");
        query.setApikey(apiKey);
        String parsedParameter = req.getParameter("parsed");
        if (parsedParameter != null) {
            int unlockKey = 0;
            try {
                unlockKey = Integer.parseInt(parsedParameter);
                query.setParsedAddressUnlockKey(unlockKey);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Float latitude = null;
        Float longitude = null;
        try {
            String latParameter = req.getParameter("lat");
            if (latParameter != null && !latParameter.trim().equals("") && ((latitude = GeolocHelper.parseInternationalDouble((String)latParameter)).floatValue() < -90.0f || latitude.floatValue() > 90.0f)) {
                throw new GeolocSearchException("latitude is not correct");
            }
        }
        catch (Exception e) {
            throw new GeolocSearchException("latitude is not correct");
        }
        try {
            String longParameter = req.getParameter("lng");
            if (longParameter != null && !longParameter.trim().equals("")) {
                longitude = GeolocHelper.parseInternationalDouble((String)longParameter);
                if (latitude.floatValue() < -180.0f || latitude.floatValue() > 180.0f) {
                    throw new GeolocSearchException("latitude is not correct");
                }
            }
        }
        catch (Exception e) {
            throw new GeolocSearchException("longitude is not correct ");
        }
        Point point = null;
        try {
            if (latitude != null && longitude != null) {
                point = GeolocHelper.createPoint((Float)longitude, (Float)latitude);
            }
        }
        catch (RuntimeException e1) {
            throw new GeolocSearchException("can not determine Point");
        }
        query.around(point);
        try {
            radius = GeolocHelper.parseInternationalDouble((String)req.getParameter("radius")).floatValue();
        }
        catch (Exception e) {
            radius = 100000.0;
        }
        query.withRadius(radius);
        int limit = 10;
        try {
            String limitParameter = req.getParameter("limitnbresult");
            if (limitParameter != null && !limitParameter.trim().equals("")) {
                limit = Integer.parseInt(limitParameter);
                query.limitNbResult(limit);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return query;
    }

    public Address buildAddressFromRequest(HttpServletRequest req) {
        if (req == null) {
            throw new AddressParserException("could not build an address from a null HTTP request");
        }
        Address address = new Address();
        Map parameterNames = req.getParameterMap();
        boolean atLeastOneSetterFound = false;
        for (Map.Entry parameters : parameterNames.entrySet()) {
            boolean success;
            String parameterValue;
            String parameterNameFromQuery = (String)parameters.getKey();
            String parameterName = this.getFieldNameFromParameter(parameterNameFromQuery);
            if (((String[])parameters.getValue()).length != 1 || "country".equalsIgnoreCase(parameterName) || (parameterValue = ((String[])parameters.getValue())[0]) == null || "".equals(parameterValue.trim()) || !(success = AddressQueryHttpBuilder.setAddressField(address, parameterName, parameterValue))) continue;
            atLeastOneSetterFound = true;
        }
        if (atLeastOneSetterFound) {
            return address;
        }
        return null;
    }

    String getFieldNameFromParameter(String parameterNameFromQuery) {
        if (parameterNameFromQuery == null) {
            return null;
        }
        String fieldName = parameterNameToAddressFields.get(parameterNameFromQuery.toLowerCase());
        return fieldName == null ? parameterNameFromQuery : fieldName;
    }

    protected static boolean setAddressField(Address address, String fieldName, String value) {
        try {
            if (fieldName == null) {
                return false;
            }
            String setter = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                Method method = Address.class.getMethod(setter, String.class);
                method.invoke((Object)address, value);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("exception in setAddressField : " + e.getMessage(), e);
        }
    }
}

