/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.addressparser;

import com.gisgraphy.addressparser.Address;
import com.gisgraphy.addressparser.AddressQuery;
import com.gisgraphy.addressparser.AddressResultsDto;
import com.gisgraphy.addressparser.IAddressParserService;
import com.gisgraphy.addressparser.exception.AddressParserException;
import com.gisgraphy.rest.BeanToRestParameter;
import com.gisgraphy.rest.IRestClient;
import com.gisgraphy.rest.RestClient;
import com.gisgraphy.serializer.common.OutputFormat;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressParserClient
implements IAddressParserService {
    protected OutputFormat PREFERED_FORMAT = OutputFormat.JSON;
    public static Logger logger = LoggerFactory.getLogger(AddressParserClient.class);
    public static final String DEFAULT_ADDRESS_PARSER_BASE_URL = "http://services.gisgraphy.com/addressparser/parse";
    private String baseURL = "http://services.gisgraphy.com/addressparser/parse";
    private RestClient restClient = new RestClient();

    public AddressParserClient() {
    }

    public AddressParserClient(String baseURL) {
        if (baseURL == null) {
            throw new IllegalArgumentException("the address parser client needs an url");
        }
        try {
            new URL(baseURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("the address parser client needs a well formed url");
        }
        this.baseURL = baseURL;
    }

    protected IRestClient getRestClient() {
        return this.restClient;
    }

    public AddressResultsDto execute(AddressQuery addressQuery) throws AddressParserException {
        if (addressQuery == null) {
            throw new AddressParserException("Can not execute a null Adsress query");
        }
        try {
            addressQuery.setFormat(this.PREFERED_FORMAT);
            addressQuery.setCallback(null);
            String url = this.getUrl(addressQuery);
            AddressResultsDto results = this.getRestClient().get(url, AddressResultsDto.class, this.PREFERED_FORMAT);
            Address address = null;
            Long qTime = -1L;
            if (results != null && results.getResult() != null && results.getResult().size() >= 1) {
                address = (Address)results.getResult().get(0);
                qTime = results.getQTime();
            }
            logger.info(addressQuery + " took " + qTime + " ms and returns " + address);
            return results;
        }
        catch (Exception e) {
            throw new AddressParserException((Throwable)e);
        }
    }

    public void executeAndSerialize(AddressQuery addressQuery, OutputStream outputStream) throws AddressParserException {
        if (addressQuery == null) {
            throw new AddressParserException("Can not stream a null Adsress query");
        }
        if (outputStream == null) {
            throw new AddressParserException("Can not serialize in a null stream");
        }
        try {
            String url = this.getUrl(addressQuery);
            this.getRestClient().get(url, outputStream, OutputFormat.JSON);
        }
        catch (Exception e) {
            throw new AddressParserException((Throwable)e);
        }
    }

    public String executeToString(AddressQuery addressQuery) throws AddressParserException {
        if (addressQuery == null) {
            throw new AddressParserException("Can not stream a null Adsress query to string");
        }
        try {
            String url = this.getUrl(addressQuery);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.getRestClient().get(url, outputStream, OutputFormat.JSON);
            return ((Object)outputStream).toString();
        }
        catch (Exception e) {
            throw new AddressParserException((Throwable)e);
        }
    }

    public String getUrl(AddressQuery query) {
        return this.baseURL + BeanToRestParameter.toQueryString(query);
    }

    public String getBaseURL() {
        return this.baseURL;
    }
}

