/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs.authz;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.OperatorOverloader;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeComparator;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.TypedValue;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.taglibs.TagLibConfig;
import org.springframework.security.taglibs.authz.AbstractAuthorizeTag;
import org.springframework.security.web.FilterInvocation;

public class JspAuthorizeTag
extends AbstractAuthorizeTag
implements Tag {
    private Tag parent;
    protected PageContext pageContext;
    protected String id;
    private String var;
    private boolean authorized;

    public int doStartTag() throws JspException {
        try {
            this.authorized = super.authorize();
            if (!this.authorized && TagLibConfig.isUiSecurityDisabled()) {
                this.pageContext.getOut().write(TagLibConfig.getSecuredUiPrefix());
            }
            if (this.var != null) {
                this.pageContext.setAttribute(this.var, (Object)this.authorized, 1);
            }
            return TagLibConfig.evalOrSkip(this.authorized);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    @Override
    protected EvaluationContext createExpressionEvaluationContext(SecurityExpressionHandler<FilterInvocation> handler) {
        return new PageContextVariableLookupEvaluationContext(super.createExpressionEvaluationContext(handler));
    }

    public int doEndTag() throws JspException {
        try {
            if (!this.authorized && TagLibConfig.isUiSecurityDisabled()) {
                this.pageContext.getOut().write(TagLibConfig.getSecuredUiSuffix());
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Tag getParent() {
        return this.parent;
    }

    public void setParent(Tag parent) {
        this.parent = parent;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void release() {
        this.parent = null;
        this.id = null;
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    @Override
    protected ServletRequest getRequest() {
        return this.pageContext.getRequest();
    }

    @Override
    protected ServletResponse getResponse() {
        return this.pageContext.getResponse();
    }

    @Override
    protected ServletContext getServletContext() {
        return this.pageContext.getServletContext();
    }

    private final class PageContextVariableLookupEvaluationContext
    implements EvaluationContext {
        private EvaluationContext delegate;

        private PageContextVariableLookupEvaluationContext(EvaluationContext delegate) {
            this.delegate = delegate;
        }

        public TypedValue getRootObject() {
            return this.delegate.getRootObject();
        }

        public List<ConstructorResolver> getConstructorResolvers() {
            return this.delegate.getConstructorResolvers();
        }

        public List<MethodResolver> getMethodResolvers() {
            return this.delegate.getMethodResolvers();
        }

        public List<PropertyAccessor> getPropertyAccessors() {
            return this.delegate.getPropertyAccessors();
        }

        public TypeLocator getTypeLocator() {
            return this.delegate.getTypeLocator();
        }

        public TypeConverter getTypeConverter() {
            return this.delegate.getTypeConverter();
        }

        public TypeComparator getTypeComparator() {
            return this.delegate.getTypeComparator();
        }

        public OperatorOverloader getOperatorOverloader() {
            return this.delegate.getOperatorOverloader();
        }

        public BeanResolver getBeanResolver() {
            return this.delegate.getBeanResolver();
        }

        public void setVariable(String name, Object value) {
            this.delegate.setVariable(name, value);
        }

        public Object lookupVariable(String name) {
            Object result = this.delegate.lookupVariable(name);
            if (result == null) {
                result = JspAuthorizeTag.this.pageContext.findAttribute(name);
            }
            return result;
        }
    }
}

