/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureType;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class PostPreProcessFilterSplittingVisitor
implements org.opengis.filter.FilterVisitor,
ExpressionVisitor {
    private static final Logger logger = Logger.getLogger("org.geotools.filter");
    private Stack postStack = new Stack();
    private Stack preStack = new Stack();
    private Set changedStack = new HashSet();
    private FilterCapabilities fcs = null;
    private FeatureType parent = null;
    private org.opengis.filter.Filter original = null;
    private ClientTransactionAccessor transactionAccessor;
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    private PostPreProcessFilterSplittingVisitor() {
    }

    public PostPreProcessFilterSplittingVisitor(FilterCapabilities fcs, FeatureType parent, ClientTransactionAccessor transactionAccessor) {
        this.fcs = fcs;
        this.parent = parent;
        this.transactionAccessor = transactionAccessor;
    }

    public org.opengis.filter.Filter getFilterPost() {
        if (!this.changedStack.isEmpty()) {
            return this.original;
        }
        if (this.postStack.size() > 1) {
            logger.warning("Too many post stack items after run: " + this.postStack.size());
        }
        IncludeFilter f = this.postStack.isEmpty() ? org.opengis.filter.Filter.INCLUDE : (org.opengis.filter.Filter)this.postStack.peek();
        return f;
    }

    public org.opengis.filter.Filter getFilterPre() {
        org.opengis.filter.Filter deleteFilter;
        Object f;
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        if (this.preStack.isEmpty()) {
            return org.opengis.filter.Filter.INCLUDE;
        }
        if (this.preStack.size() > 1) {
            logger.warning("Too many pre stack items after run: " + this.preStack.size());
        }
        Object object = f = this.preStack.isEmpty() ? org.opengis.filter.Filter.INCLUDE : (org.opengis.filter.Filter)this.preStack.peek();
        if (this.transactionAccessor != null && f != null && f != org.opengis.filter.Filter.EXCLUDE && (deleteFilter = this.transactionAccessor.getDeleteFilter()) != null) {
            f = deleteFilter == org.opengis.filter.Filter.EXCLUDE ? org.opengis.filter.Filter.EXCLUDE : ff.and((org.opengis.filter.Filter)f, (org.opengis.filter.Filter)ff.not(deleteFilter));
        }
        if (this.changedStack.isEmpty()) {
            return f;
        }
        Iterator iter = this.changedStack.iterator();
        org.opengis.filter.Filter updateFilter = (org.opengis.filter.Filter)iter.next();
        while (iter.hasNext()) {
            org.opengis.filter.Filter next = (org.opengis.filter.Filter)iter.next();
            if (next == org.opengis.filter.Filter.INCLUDE) {
                updateFilter = next;
                break;
            }
            updateFilter = ff.or(updateFilter, next);
        }
        if (updateFilter == org.opengis.filter.Filter.INCLUDE || f == org.opengis.filter.Filter.INCLUDE) {
            return org.opengis.filter.Filter.INCLUDE;
        }
        return ff.or((org.opengis.filter.Filter)f, updateFilter);
    }

    public void visit(IncludeFilter filter) {
    }

    public void visit(ExcludeFilter filter) {
        if (this.fcs.supports((org.opengis.filter.Filter)org.opengis.filter.Filter.EXCLUDE)) {
            this.preStack.push(filter);
        } else {
            this.postStack.push(filter);
        }
    }

    public Object visit(PropertyIsBetween filter, Object extradata) {
        if (this.original == null) {
            this.original = filter;
        }
        if (this.fcs.supports(PropertyIsBetween.class)) {
            int i = this.postStack.size();
            org.opengis.filter.expression.Expression lowerBound = filter.getLowerBoundary();
            org.opengis.filter.expression.Expression expr = filter.getExpression();
            org.opengis.filter.expression.Expression upperBound = filter.getUpperBoundary();
            if (lowerBound == null || upperBound == null || expr == null) {
                this.postStack.push(filter);
                return null;
            }
            lowerBound.accept((ExpressionVisitor)this, null);
            if (i < this.postStack.size()) {
                this.postStack.pop();
                this.postStack.push(filter);
                return null;
            }
            expr.accept((ExpressionVisitor)this, null);
            if (i < this.postStack.size()) {
                this.preStack.pop();
                this.postStack.pop();
                this.postStack.push(filter);
                return null;
            }
            upperBound.accept((ExpressionVisitor)this, null);
            if (i < this.postStack.size()) {
                this.postStack.pop();
                this.preStack.pop();
                this.preStack.pop();
                this.postStack.push(filter);
                return null;
            }
            this.preStack.pop();
            this.preStack.pop();
            this.preStack.pop();
            this.preStack.push(filter);
        } else {
            this.postStack.push(filter);
        }
        return null;
    }

    public Object visit(PropertyIsEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    public Object visit(PropertyIsGreaterThan filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    public Object visit(PropertyIsLessThan filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        return null;
    }

    private void visitBinaryComparisonOperator(BinaryComparisonOperator filter) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS)) {
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        org.opengis.filter.expression.Expression leftValue = filter.getExpression1();
        org.opengis.filter.expression.Expression rightValue = filter.getExpression2();
        if (leftValue == null || rightValue == null) {
            this.postStack.push(filter);
            return;
        }
        leftValue.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        rightValue.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(filter);
    }

    public Object visit(BBOX filter, Object notUsed) {
        if (!this.fcs.supports(BBOX.class)) {
            this.postStack.push(filter);
        } else {
            this.preStack.push(filter);
        }
        return null;
    }

    public Object visit(Beyond filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Contains filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Crosses filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Disjoint filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(DWithin filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Equals filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Intersects filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Overlaps filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Touches filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    public Object visit(Within filter, Object notUsed) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return null;
    }

    private void visitBinarySpatialOperator(BinarySpatialOperator filter) {
        int i;
        if (this.original == null) {
            this.original = filter;
        }
        Class[] spatialOps = new Class[]{Beyond.class, Contains.class, Crosses.class, Disjoint.class, DWithin.class, Equals.class, Intersects.class, Overlaps.class, Touches.class, Within.class};
        for (i = 0; i < spatialOps.length; ++i) {
            if (!spatialOps[i].isAssignableFrom(filter.getClass())) continue;
            if (this.fcs.supports(spatialOps[i])) break;
            this.postStack.push(filter);
            return;
        }
        i = this.postStack.size();
        org.opengis.filter.expression.Expression leftGeometry = filter.getExpression1();
        org.opengis.filter.expression.Expression rightGeometry = filter.getExpression2();
        if (leftGeometry == null || rightGeometry == null) {
            this.postStack.push(filter);
            return;
        }
        leftGeometry.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        rightGeometry.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(filter);
    }

    public Object visit(PropertyIsLike filter, Object notUsed) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(PropertyIsLike.class)) {
            this.postStack.push(filter);
            return null;
        }
        int i = this.postStack.size();
        filter.getExpression().accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return null;
        }
        this.preStack.pop();
        this.preStack.push(filter);
        return null;
    }

    public Object visit(And filter, Object notUsed) {
        this.visitLogicOperator((org.opengis.filter.Filter)filter);
        return null;
    }

    public Object visit(Not filter, Object notUsed) {
        this.visitLogicOperator((org.opengis.filter.Filter)filter);
        return null;
    }

    public Object visit(Or filter, Object notUsed) {
        this.visitLogicOperator((org.opengis.filter.Filter)filter);
        return null;
    }

    private void visitLogicOperator(org.opengis.filter.Filter filter) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!(this.fcs.supports(Not.class) || this.fcs.supports(And.class) || this.fcs.supports(Or.class))) {
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        int j = this.preStack.size();
        if (filter instanceof Not) {
            if (((Not)filter).getFilter() != null) {
                org.opengis.filter.Filter next = ((Not)filter).getFilter();
                next.accept((org.opengis.filter.FilterVisitor)this, null);
                if (i < this.postStack.size()) {
                    this.popToSize(this.postStack, i);
                    this.popToSize(this.preStack, j);
                    this.postStack.push(filter);
                } else {
                    this.popToSize(this.preStack, j);
                    this.preStack.push(filter);
                }
            }
        } else if (filter instanceof Or) {
            try {
                org.opengis.filter.Filter orReplacement = this.translateOr((Or)filter);
                orReplacement.accept((org.opengis.filter.FilterVisitor)this, null);
            }
            catch (IllegalFilterException e) {
                this.popToSize(this.preStack, j);
                this.postStack.push(filter);
                return;
            }
            if (this.postStack.size() > i) {
                this.popToSize(this.postStack, i);
                this.postStack.push(filter);
                return;
            }
            this.preStack.pop();
            this.preStack.push(filter);
        } else {
            for (org.opengis.filter.Filter next : ((And)filter).getChildren()) {
                next.accept((org.opengis.filter.FilterVisitor)this, null);
            }
            if (i < this.postStack.size()) {
                if (filter instanceof And) {
                    org.opengis.filter.Filter f = (org.opengis.filter.Filter)this.postStack.pop();
                    while (this.postStack.size() > i) {
                        f = this.ff.and(f, (org.opengis.filter.Filter)this.postStack.pop());
                    }
                    this.postStack.push(f);
                    if (j < this.preStack.size()) {
                        f = (org.opengis.filter.Filter)this.preStack.pop();
                        while (this.preStack.size() > j) {
                            f = this.ff.and(f, (org.opengis.filter.Filter)this.preStack.pop());
                        }
                        this.preStack.push(f);
                    }
                } else {
                    logger.warning("LogicFilter found which is not 'and, or, not");
                    this.popToSize(this.postStack, i);
                    this.popToSize(this.preStack, j);
                    this.postStack.push(filter);
                }
            } else {
                this.popToSize(this.preStack, j);
                this.preStack.push(filter);
            }
        }
    }

    private void popToSize(Stack stack, int j) {
        while (j < stack.size()) {
            stack.pop();
        }
    }

    public Object visitNullFilter(Object notUsed) {
        return null;
    }

    public Object visit(IncludeFilter filter, Object notUsed) {
        return null;
    }

    public Object visit(ExcludeFilter filter, Object notUsed) {
        if (this.fcs.supports((org.opengis.filter.Filter)org.opengis.filter.Filter.EXCLUDE)) {
            this.preStack.push(filter);
        } else {
            this.postStack.push(filter);
        }
        return null;
    }

    public Object visit(PropertyIsNull filter, Object notUsed) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(PropertyIsNull.class)) {
            this.postStack.push(filter);
            return null;
        }
        int i = this.postStack.size();
        filter.getExpression().accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
        }
        this.preStack.pop();
        this.preStack.push(filter);
        return null;
    }

    public Object visit(Id filter, Object notUsed) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.postStack.isEmpty()) {
            this.postStack.push(filter);
        }
        this.preStack.push(filter);
        return null;
    }

    public Object visit(PropertyName expression, Object notUsed) {
        if (this.parent != null && expression.evaluate((Object)this.parent) == null) {
            throw new IllegalArgumentException("Property '" + expression.getPropertyName() + "' could not be found in " + this.parent.getTypeName());
        }
        if (this.transactionAccessor != null) {
            org.opengis.filter.Filter updateFilter = this.transactionAccessor.getUpdateFilter(expression.getPropertyName());
            if (updateFilter != null) {
                this.changedStack.add(updateFilter);
                this.preStack.push(updateFilter);
            } else {
                this.preStack.push(expression);
            }
        } else {
            this.preStack.push(expression);
        }
        return null;
    }

    public Object visit(Literal expression, Object notUsed) {
        if (expression.getValue() == null) {
            this.postStack.push(expression);
        }
        this.preStack.push(expression);
        return null;
    }

    public Object visit(Add filter, Object notUsed) {
        this.visitMathExpression((BinaryExpression)filter);
        return null;
    }

    public Object visit(Divide filter, Object notUsed) {
        this.visitMathExpression((BinaryExpression)filter);
        return null;
    }

    public Object visit(Multiply filter, Object notUsed) {
        this.visitMathExpression((BinaryExpression)filter);
        return null;
    }

    public Object visit(Subtract filter, Object notUsed) {
        this.visitMathExpression((BinaryExpression)filter);
        return null;
    }

    private void visitMathExpression(BinaryExpression expression) {
        if (!(this.fcs.supports(Add.class) || this.fcs.supports(Subtract.class) || this.fcs.supports(Multiply.class) || this.fcs.supports(Divide.class))) {
            this.postStack.push(expression);
            return;
        }
        int i = this.postStack.size();
        org.opengis.filter.expression.Expression leftValue = expression.getExpression1();
        org.opengis.filter.expression.Expression rightValue = expression.getExpression2();
        if (leftValue == null || rightValue == null) {
            this.postStack.push(expression);
            return;
        }
        leftValue.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(expression);
            return;
        }
        rightValue.accept((ExpressionVisitor)this, null);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(expression);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(expression);
    }

    public Object visit(Function expression, Object notUsed) {
        if (!this.fcs.supports(expression.getClass())) {
            this.postStack.push(expression);
            return null;
        }
        if (expression.getName() == null) {
            this.postStack.push(expression);
            return null;
        }
        int i = this.postStack.size();
        int j = this.preStack.size();
        for (int k = 0; k < expression.getParameters().size(); ++k) {
            ((org.opengis.filter.expression.Expression)expression.getParameters().get(i)).accept((ExpressionVisitor)this, null);
            if (i >= this.postStack.size()) continue;
            while (j < this.preStack.size()) {
                this.preStack.pop();
            }
            this.postStack.pop();
            this.postStack.push(expression);
            return null;
        }
        while (j < this.preStack.size()) {
            this.preStack.pop();
        }
        this.preStack.push(expression);
        return null;
    }

    public Object visit(NilExpression nilExpression, Object notUsed) {
        this.postStack.push(nilExpression);
        return null;
    }

    private org.opengis.filter.Filter translateOr(Or filter) throws IllegalFilterException {
        if (!(filter instanceof Or)) {
            return filter;
        }
        Iterator i = filter.getChildren().iterator();
        And and = this.ff.and(new ArrayList());
        while (i.hasNext()) {
            org.opengis.filter.Filter f = (org.opengis.filter.Filter)i.next();
            if (f instanceof Not) {
                Not logic = (Not)f;
                org.opengis.filter.Filter next = logic.getFilter();
                and = this.ff.and((org.opengis.filter.Filter)and, next);
                continue;
            }
            and = this.ff.and((org.opengis.filter.Filter)and, (org.opengis.filter.Filter)this.ff.not(f));
        }
        return this.ff.not((org.opengis.filter.Filter)and);
    }

    public static class WFSBBoxFilterVisitor
    implements FilterVisitor {
        Envelope maxbbox;

        public WFSBBoxFilterVisitor(Envelope fsd) {
            this.maxbbox = fsd;
        }

        public void visit(Filter filter) {
            if (Filter.NONE == filter) {
                return;
            }
            switch (filter.getFilterType()) {
                case 19: {
                    this.visit((BetweenFilter)filter);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 23: {
                    this.visit((BetweenFilter)filter);
                    break;
                }
                case 22: {
                    this.visit((BetweenFilter)filter);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 24: {
                    this.visit((GeometryFilter)filter);
                    break;
                }
                case 20: {
                    this.visit((LikeFilter)filter);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.visit((LogicFilter)filter);
                    break;
                }
                case 21: {
                    this.visit((NullFilter)filter);
                    break;
                }
            }
        }

        public void visit(BetweenFilter filter) {
            if (filter != null) {
                if (filter.getLeftValue() != null) {
                    filter.getLeftValue().accept((FilterVisitor)this);
                }
                if (filter.getRightValue() != null) {
                    filter.getRightValue().accept((FilterVisitor)this);
                }
                if (filter.getMiddleValue() != null) {
                    filter.getMiddleValue().accept((FilterVisitor)this);
                }
            }
        }

        public void visit(CompareFilter filter) {
            if (filter != null) {
                if (filter.getLeftValue() != null) {
                    filter.getLeftValue().accept((FilterVisitor)this);
                }
                if (filter.getRightValue() != null) {
                    filter.getRightValue().accept((FilterVisitor)this);
                }
            }
        }

        public void visit(GeometryFilter filter) {
            if (filter != null) {
                Expression leftGeometry = filter.getLeftGeometry();
                Expression rightGeometry = filter.getRightGeometry();
                switch (filter.getFilterType()) {
                    case 4: {
                        Envelope bbox = null;
                        LiteralExpression le = null;
                        if (leftGeometry != null && leftGeometry.getType() == 104) {
                            le = (LiteralExpression)leftGeometry;
                            if (le != null && le.getLiteral() != null && le.getLiteral() instanceof Geometry) {
                                bbox = ((Geometry)le.getLiteral()).getEnvelopeInternal();
                            }
                        } else if (rightGeometry != null && rightGeometry.getType() == 104 && (le = (LiteralExpression)rightGeometry) != null && le.getLiteral() != null && le.getLiteral() instanceof Geometry) {
                            Geometry g = (Geometry)le.getLiteral();
                            bbox = g.getEnvelopeInternal();
                        }
                        if (bbox != null) {
                            boolean changed = false;
                            double minx = bbox.getMinX();
                            double miny = bbox.getMinY();
                            double maxx = bbox.getMaxX();
                            double maxy = bbox.getMaxY();
                            if (minx < this.maxbbox.getMinX()) {
                                minx = this.maxbbox.getMinX();
                                changed = true;
                            }
                            if (maxx > this.maxbbox.getMaxX()) {
                                maxx = this.maxbbox.getMaxX();
                                changed = true;
                            }
                            if (miny < this.maxbbox.getMinY()) {
                                miny = this.maxbbox.getMinY();
                                changed = true;
                            }
                            if (maxy > this.maxbbox.getMaxY()) {
                                maxy = this.maxbbox.getMaxY();
                                changed = true;
                            }
                            if (changed) {
                                Envelope tmp = new Envelope(minx, maxx, miny, maxy);
                                try {
                                    le.setLiteral((Object)new GeometryFactory().toGeometry(tmp));
                                }
                                catch (IllegalFilterException e) {
                                    logger.warning(e.toString());
                                }
                            }
                        }
                        return;
                    }
                }
                if (leftGeometry != null) {
                    leftGeometry.accept((FilterVisitor)this);
                }
                if (rightGeometry != null) {
                    rightGeometry.accept((FilterVisitor)this);
                }
            }
        }

        public void visit(LikeFilter filter) {
            if (filter != null && filter.getValue() != null) {
                filter.getValue().accept((FilterVisitor)this);
            }
        }

        public void visit(LogicFilter filter) {
            if (filter != null) {
                Iterator i = filter.getFilterIterator();
                while (i.hasNext()) {
                    Filter tmp = (Filter)i.next();
                    tmp.accept((FilterVisitor)this);
                }
            }
        }

        public void visit(NullFilter filter) {
            if (filter != null && filter.getNullCheckValue() != null) {
                filter.getNullCheckValue().accept((FilterVisitor)this);
            }
        }

        public void visit(FidFilter filter) {
        }

        public void visit(AttributeExpression expression) {
        }

        public void visit(Expression expression) {
        }

        public void visit(LiteralExpression expression) {
        }

        public void visit(MathExpression expression) {
        }

        public void visit(FunctionExpression expression) {
        }
    }
}

