/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.FilterNameTypeMapping;
import org.geotools.filter.Filters;
import org.geotools.filter.LogicFilter;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Expression;

public class FilterCapabilities {
    public static final long NO_OP = 0L;
    public static final long NONE = 0x40000000L;
    public static final long ALL = Integer.MIN_VALUE;
    public static final long SPATIAL_BBOX = 1L;
    public static final long SPATIAL_EQUALS = 2L;
    public static final long SPATIAL_DISJOINT = 4L;
    public static final long SPATIAL_INTERSECT = 8L;
    public static final long SPATIAL_TOUCHES = 16L;
    public static final long SPATIAL_CROSSES = 32L;
    public static final long SPATIAL_WITHIN = 64L;
    public static final long SPATIAL_CONTAINS = 128L;
    public static final long SPATIAL_OVERLAPS = 256L;
    public static final long SPATIAL_BEYOND = 512L;
    public static final long SPATIAL_DWITHIN = 1024L;
    public static final long LIKE = 2048L;
    public static final long BETWEEN = 4096L;
    public static final long NULL_CHECK = 8192L;
    public static final long SIMPLE_ARITHMETIC = 16384L;
    public static final long FUNCTIONS = 32768L;
    public static final long COMPARE_EQUALS = 65536L;
    public static final long COMPARE_GREATER_THAN = 131072L;
    public static final long COMPARE_GREATER_THAN_EQUAL = 262144L;
    public static final long COMPARE_LESS_THAN = 524288L;
    public static final long COMPARE_LESS_THAN_EQUAL = 0x100000L;
    public static final long COMPARE_NOT_EQUALS = 0x200000L;
    public static final long FID = 0x400000L;
    public static final long LOGIC_AND = 0x800000L;
    public static final long LOGIC_NOT = 0x1000000L;
    public static final long LOGIC_OR = 0x2000000L;
    public static final long LOGICAL = 0x3800000L;
    public static final long SIMPLE_COMPARISONS = 0x3F0000L;
    public static final FilterCapabilities SIMPLE_COMPARISONS_OPENGIS = new FilterCapabilities();
    public static final FilterCapabilities LOGICAL_OPENGIS;
    private long ops = 0L;
    private Set functions = new HashSet();

    public FilterCapabilities(long filterCapabilitiesType) {
        this.addType(filterCapabilitiesType);
    }

    public FilterCapabilities() {
        this(0L);
    }

    public FilterCapabilities(Class type) {
        this.addType(type);
    }

    public void addType(long type) {
        this.ops |= type;
    }

    public void addType(Class type) {
        if (Filter.class.isAssignableFrom(type) || Expression.class.isAssignableFrom(type)) {
            this.addType(32768L);
            this.functions.add(type);
        }
    }

    public void addAll(FilterCapabilities capabilities) {
        this.ops = capabilities.ops | this.ops;
        this.functions.addAll(capabilities.functions);
    }

    public void addType(short type) {
        this.addAll(this.convertFilterTypeToMask(type));
    }

    public FilterCapabilities convertFilterTypeToMask(short type) {
        if (type == -12345) {
            return FilterNameTypeMapping.NO_OP_CAPS;
        }
        if (type == 12345) {
            return FilterNameTypeMapping.ALL_CAPS;
        }
        Object object = FilterNameTypeMapping.filterTypeToFilterCapabilitiesMap.get(new Short(type));
        return (FilterCapabilities)object;
    }

    public boolean supports(Filter filter) {
        Iterator ifunc = this.functions.iterator();
        while (ifunc.hasNext()) {
            if (!((Class)ifunc.next()).isAssignableFrom(filter.getClass())) continue;
            return true;
        }
        if (this.functions.contains(filter.getClass())) {
            return true;
        }
        short filterType = Filters.getFilterType(filter);
        return this.supports(filterType);
    }

    public boolean fullySupports(Filter filter) {
        boolean supports = true;
        if (filter == null) {
            throw new IllegalArgumentException("Null filters can not be unpacked, did you mean Filter.INCLUDE?");
        }
        short filterType = Filters.getFilterType(filter);
        if (AbstractFilter.isLogicFilter(filterType)) {
            Iterator filters = ((LogicFilter)filter).getFilterIterator();
            Filter testFilter = null;
            while (filters.hasNext()) {
                testFilter = (Filter)filters.next();
                if (this.fullySupports(testFilter)) continue;
                supports = false;
                break;
            }
        } else {
            supports = this.supports(filter);
        }
        return supports;
    }

    public boolean supports(short type) {
        return this.supports(this.convertFilterTypeToMask(type));
    }

    public boolean supports(long type) {
        return (this.ops & type) == type;
    }

    public boolean supports(FilterCapabilities type) {
        return (this.ops & type.ops) == type.ops && this.functions.containsAll(type.functions);
    }

    public boolean supports(Class type) {
        return this.functions.contains(type);
    }

    public long getScalarOps() {
        return this.ops & 0x3FFF800L;
    }

    public long getSpatialOps() {
        return this.ops & 0x7FFL;
    }

    public static FilterCapabilities findOperation(String name) {
        return FilterNameTypeMapping.findOperation(name);
    }

    public static FilterCapabilities findFunction(String name) {
        return FilterNameTypeMapping.findFunction(name);
    }

    static {
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsEqualTo.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsGreaterThan.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsGreaterThanOrEqualTo.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsLessThanOrEqualTo.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsLessThan.class);
        SIMPLE_COMPARISONS_OPENGIS.addType(PropertyIsNotEqualTo.class);
        LOGICAL_OPENGIS = new FilterCapabilities();
        LOGICAL_OPENGIS.addType(And.class);
        LOGICAL_OPENGIS.addType(Not.class);
        LOGICAL_OPENGIS.addType(Or.class);
    }
}

