/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.feature.Feature;
import org.geotools.filter.Expression;
import org.opengis.feature.Attribute;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;

public abstract class FilterAbstract
implements Filter {
    protected FilterFactory factory;

    protected FilterAbstract(FilterFactory factory) {
        this.factory = factory;
    }

    public boolean evaluate(Feature feature) {
        return this.evaluate(feature);
    }

    public boolean accepts(Feature feature) {
        return this.evaluate(feature);
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return extraData;
    }

    protected Object eval(Expression expression, Feature feature) {
        if (expression == null || feature == null) {
            return null;
        }
        return expression.evaluate(feature);
    }

    protected Object eval(org.opengis.filter.expression.Expression expression, Object object) {
        if (expression == null) {
            return null;
        }
        Object value = expression.evaluate(object);
        if (value instanceof Attribute) {
            value = ((Attribute)value).getValue();
        }
        return value;
    }

    protected Object eval(org.opengis.filter.expression.Expression expression, Object object, Class context) {
        if (expression == null) {
            return null;
        }
        return expression.evaluate(object, context);
    }
}

