/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultFeatureTypeFactory;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionImpl;
import org.geotools.resources.LazySet;
import org.geotools.styling.StyleFactory;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Function;

public final class CommonFactoryFinder {
    private static FactoryRegistry registry;

    private CommonFactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(CommonFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(StyleFactory.class, FilterFactory.class, FeatureLockFactory.class, FileDataStoreFactorySpi.class, FunctionImpl.class, FunctionExpression.class, Function.class, AttributeTypeFactory.class, FeatureCollections.class, FeatureTypeFactory.class));
        }
        return registry;
    }

    private static Hints addDefaultHints(Hints hints) {
        Hints completed = GeoTools.getDefaultHints();
        if (hints != null) {
            completed.add((RenderingHints)hints);
        }
        return completed;
    }

    public static synchronized StyleFactory getStyleFactory(Hints hints) throws FactoryRegistryException {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return (StyleFactory)CommonFactoryFinder.getServiceRegistry().getServiceProvider(StyleFactory.class, null, hints, (Hints.Key)Hints.STYLE_FACTORY);
    }

    public static synchronized Set getStyleFactories(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(StyleFactory.class, null, hints));
    }

    public static synchronized Set getFunctionExpressions(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(Function.class, null, hints));
    }

    public static synchronized Set getFunctions(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FunctionImpl.class, null, hints));
    }

    public static synchronized FeatureLockFactory getFeatureLockFactory(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return (FeatureLockFactory)CommonFactoryFinder.getServiceRegistry().getServiceProvider(FeatureLockFactory.class, null, hints, (Hints.Key)Hints.FEATURE_LOCK_FACTORY);
    }

    public static synchronized Set getFeatureLockFactories(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FeatureLockFactory.class, null, hints));
    }

    public static synchronized Set getFileDataStoreFactories(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FileDataStoreFactorySpi.class, null, hints));
    }

    public static synchronized AttributeTypeFactory getAttributeTypeFactory(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return (AttributeTypeFactory)CommonFactoryFinder.getServiceRegistry().getServiceProvider(AttributeTypeFactory.class, null, hints, (Hints.Key)Hints.ATTRIBUTE_TYPE_FACTORY);
    }

    public static synchronized Set getAttributeTypeFactories(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(AttributeTypeFactory.class, null, hints));
    }

    public static synchronized Set getAttributeFeatureFactories(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FeatureTypeFactory.class, null, hints));
    }

    public static synchronized FeatureTypeFactory getFeatureTypeFactory(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        DefaultFeatureTypeFactory factory = new DefaultFeatureTypeFactory();
        factory.setName((String)hints.get((Object)Hints.FEATURE_TYPE_FACTORY_NAME));
        return factory;
    }

    public static synchronized FeatureCollections getFeatureCollections(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return (FeatureCollections)CommonFactoryFinder.getServiceRegistry().getServiceProvider(FeatureCollections.class, null, hints, (Hints.Key)Hints.FEATURE_COLLECTIONS);
    }

    public static synchronized Set getFeatureCollectionsSet(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FeatureCollections.class, null, hints));
    }

    public static synchronized FilterFactory getFilterFactory(Hints hints) throws FactoryRegistryException {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return (FilterFactory)CommonFactoryFinder.getServiceRegistry().getServiceProvider(FilterFactory.class, null, hints, (Hints.Key)Hints.FILTER_FACTORY);
    }

    public static synchronized Set getFilterFactories(Hints hints) {
        hints = CommonFactoryFinder.addDefaultHints(hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FilterFactory.class, null, hints));
    }

    public static FilterFactory2 getFilterFactory2(Hints hints) throws FactoryRegistryException {
        Object h;
        if (hints == null) {
            hints = GeoTools.getDefaultHints();
        }
        if (!(!((h = hints.get((Object)Hints.FILTER_FACTORY)) instanceof Class) ? h instanceof FilterFactory2 : FilterFactory2.class.isAssignableFrom((Class)h))) {
            hints = new Hints((Map)hints);
            hints.put((Object)Hints.FILTER_FACTORY, FilterFactory2.class);
        }
        return (FilterFactory2)CommonFactoryFinder.getFilterFactory(hints);
    }

    public static synchronized void scanForPlugins() {
        if (registry != null) {
            registry.scanForPlugins();
        }
    }
}

