/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.FilteringIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class FilteringFeatureCollection
extends DecoratingFeatureCollection
implements FeatureCollection {
    FeatureCollection delegate;
    Filter filter;

    public FilteringFeatureCollection(FeatureCollection delegate, Filter filter) {
        super(delegate);
        this.delegate = delegate;
        this.filter = filter;
    }

    public FeatureIterator features() {
        return new DelegateFeatureIterator(this, this.iterator());
    }

    public void close(FeatureIterator close) {
        close.close();
    }

    public Iterator iterator() {
        return new FilteringIterator(this.delegate.iterator(), this.filter);
    }

    public void close(Iterator close) {
        FilteringIterator filtering = (FilteringIterator)close;
        this.delegate.close(filtering.getDelegate());
    }

    public FeatureCollection subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public FeatureCollection sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int count = 0;
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                ++count;
                i.next();
            }
            int n = count;
            return n;
        }
        finally {
            this.close(i);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        ArrayList list = new ArrayList();
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            Object[] objectArray = list.toArray(a);
            return objectArray;
        }
        finally {
            this.close(i);
        }
    }

    public boolean add(Object o) {
        if (!this.filter.evaluate(o)) {
            return false;
        }
        return this.delegate.add(o);
    }

    public boolean contains(Object o) {
        return this.delegate.contains(o) && this.filter.evaluate(o);
    }

    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            changed |= this.add(i.next());
        }
        return changed;
    }

    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public FeatureReader reader() throws IOException {
        return new DelegateFeatureReader(this.getSchema(), this.features());
    }

    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference((Envelope)DataUtilities.bounds(this));
    }
}

