/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.store.ActiveTypeEntry;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.data.store.MaxFeaturesFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractFeatureSource2
implements FeatureSource {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.data");
    protected ActiveTypeEntry entry;

    public AbstractFeatureSource2(ActiveTypeEntry entry) {
        this.entry = entry;
    }

    public DataStore getDataStore() {
        return this.entry.parent;
    }

    public void addFeatureListener(FeatureListener listener) {
        this.entry.listenerManager.addFeatureListener(this, listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.entry.listenerManager.removeFeatureListener(this, listener);
    }

    public FeatureCollection getFeatures(Query query) throws IOException {
        FeatureType featureType = this.entry.getFeatureType();
        Filter filter = query.getFilter();
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.INCLUDE?");
        }
        String[] propertyNames = query.getPropertyNames();
        if (filter == Filter.EXCLUDE || filter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureCollection(featureType);
        }
        Object features = this.getFeatures(filter);
        if (propertyNames != null || query.getCoordinateSystem() != null) {
            try {
                FeatureType target = DataUtilities.createSubType(featureType, propertyNames, query.getCoordinateSystem());
                if (!featureType.equals(target)) {
                    LOGGER.fine("Recasting feature type to subtype by using a ReTypeFeatureReader");
                    features = new ReTypingFeatureCollection((FeatureCollection)features, target);
                }
            }
            catch (SchemaException e) {
                LOGGER.log(Level.FINEST, e.getMessage(), e);
                throw new DataSourceException("Could not create Feature Type for query", (Throwable)e);
            }
        }
        if (query.getCoordinateSystemReproject() != null) {
            features = query.getCoordinateSystem() != null ? this.reproject((FeatureCollection)features, query.getCoordinateSystem(), query.getCoordinateSystemReproject()) : new ReprojectingFeatureCollection((FeatureCollection)features, query.getCoordinateSystemReproject());
        }
        if (query.getMaxFeatures() != Integer.MAX_VALUE) {
            features = new MaxFeaturesFeatureCollection((FeatureCollection)features, query.getMaxFeatures());
        }
        return features;
    }

    public FeatureCollection getFeatures(Filter filter) throws IOException {
        if (filter != null && !filter.equals(Filter.INCLUDE)) {
            return new FilteringFeatureCollection(this.getFeatures(), filter);
        }
        return this.getFeatures();
    }

    public FeatureType getSchema() {
        return this.entry.getFeatureType();
    }

    public Envelope getBounds() throws IOException {
        return this.getFeatures().getBounds();
    }

    public Envelope getBounds(Query query) throws IOException {
        return this.getFeatures(query).getBounds();
    }

    public int getCount(Query query) throws IOException {
        return this.getFeatures(query).size();
    }

    protected FeatureCollection reproject(FeatureCollection features, CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        return new ReprojectingFeatureCollection(features, source, target);
    }

    public Set getSupportedHints() {
        return Collections.EMPTY_SET;
    }
}

