/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.GenericSignatureParser;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.org.objectweb.asm.Attribute;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.AnnotationsForMemberHolder;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.asm.AjASMAttribute;
import org.aspectj.weaver.asm.AsmDelegate;
import org.aspectj.weaver.bcel.BcelGenericSignatureToTypeXConverter;
import org.aspectj.weaver.bcel.Utility;

public class AsmMethod
extends ResolvedMemberImpl {
    private boolean unpackedGenericSignature = false;
    private String genericSignature = null;
    private UnresolvedType genericReturnType = null;
    private UnresolvedType[] genericParameterTypes = null;
    private boolean canBeParameterized = false;
    private AnnotationsForMemberHolder annos;
    private AjAttribute.EffectiveSignatureAttribute esAttribute = null;
    private AjAttribute.MethodDeclarationLineNumberAttribute mdlnAttribute = null;
    private ShadowMunger shadowMunger = null;
    private AsmDelegate classDelegate;
    public List attributes = Collections.EMPTY_LIST;
    private boolean unpackedAspectJAttributes = false;

    public AsmMethod(Member.Kind kind, UnresolvedType declaringType, int modifiers, String name, String signature) {
        super(kind, declaringType, modifiers, name, signature);
    }

    public void setClassDelegate(AsmDelegate del) {
        this.classDelegate = del;
    }

    public void setGenericSignature(String sig) {
        this.genericSignature = sig;
    }

    public boolean canBeParameterized() {
        this.unpackGenericSignature();
        return this.canBeParameterized;
    }

    public UnresolvedType[] getGenericParameterTypes() {
        this.unpackGenericSignature();
        return this.genericParameterTypes;
    }

    public UnresolvedType getGenericReturnType() {
        this.unpackGenericSignature();
        return this.genericReturnType;
    }

    public World getWorld() {
        return this.classDelegate.getWorld();
    }

    private void unpackGenericSignature() {
        if (this.unpackedGenericSignature) {
            return;
        }
        if (!this.getWorld().isInJava5Mode()) {
            this.genericReturnType = this.getReturnType();
            this.genericParameterTypes = this.getParameterTypes();
            return;
        }
        this.unpackedGenericSignature = true;
        String gSig = this.genericSignature;
        if (gSig != null) {
            Signature.MethodTypeSignature mSig = new GenericSignatureParser().parseAsMethodSignature(gSig);
            if (mSig.formalTypeParameters.length > 0) {
                this.canBeParameterized = true;
            }
            Signature.FormalTypeParameter[] parentFormals = this.classDelegate.getAllFormals();
            Signature.FormalTypeParameter[] formals = new Signature.FormalTypeParameter[parentFormals.length + mSig.formalTypeParameters.length];
            System.arraycopy(mSig.formalTypeParameters, 0, formals, 0, mSig.formalTypeParameters.length);
            System.arraycopy(parentFormals, 0, formals, mSig.formalTypeParameters.length, parentFormals.length);
            this.typeVariables = new TypeVariable[mSig.formalTypeParameters.length];
            for (int i = 0; i < this.typeVariables.length; ++i) {
                Signature.FormalTypeParameter methodFtp = mSig.formalTypeParameters[i];
                try {
                    this.typeVariables[i] = BcelGenericSignatureToTypeXConverter.formalTypeParameter2TypeVariable(methodFtp, mSig.formalTypeParameters, this.getWorld());
                    continue;
                }
                catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                    throw new IllegalStateException("While getting the type variables for method " + this.toString() + " with generic signature " + mSig + " the following error condition was detected: " + e.getMessage());
                }
            }
            Signature.TypeSignature returnTypeSignature = mSig.returnType;
            try {
                this.genericReturnType = BcelGenericSignatureToTypeXConverter.typeSignature2TypeX(returnTypeSignature, formals, this.getWorld());
            }
            catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                throw new IllegalStateException("While determing the generic return type of " + this.toString() + " with generic signature " + gSig + " the following error was detected: " + e.getMessage());
            }
            Signature.TypeSignature[] paramTypeSigs = mSig.parameters;
            this.genericParameterTypes = new UnresolvedType[paramTypeSigs.length];
            for (int i = 0; i < paramTypeSigs.length; ++i) {
                try {
                    this.genericParameterTypes[i] = BcelGenericSignatureToTypeXConverter.typeSignature2TypeX(paramTypeSigs[i], formals, this.getWorld());
                }
                catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                    throw new IllegalStateException("While determining the generic parameter types of " + this.toString() + " with generic signature " + gSig + " the following error was detected: " + e.getMessage());
                }
                if (!(paramTypeSigs[i] instanceof Signature.TypeVariableSignature)) continue;
                this.canBeParameterized = true;
            }
        } else {
            this.genericReturnType = this.getReturnType();
            this.genericParameterTypes = this.getParameterTypes();
        }
    }

    public AjAttribute.EffectiveSignatureAttribute getEffectiveSignature() {
        this.unpackAspectJAttributes();
        return this.esAttribute;
    }

    public ShadowMunger getAssociatedShadowMunger() {
        this.unpackAspectJAttributes();
        return this.shadowMunger;
    }

    public int getDeclarationLineNumber() {
        this.unpackAspectJAttributes();
        if (this.mdlnAttribute == null) {
            return -1;
        }
        return this.mdlnAttribute.getLineNumber();
    }

    public boolean isAjSynthetic() {
        this.unpackAspectJAttributes();
        return super.isAjSynthetic();
    }

    private void unpackAspectJAttributes() {
        if (this.unpackedAspectJAttributes) {
            return;
        }
        ArrayList<Attribute> forRemoval = new ArrayList<Attribute>();
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            Attribute element = (Attribute)iter.next();
            if (!(element instanceof AjASMAttribute)) continue;
            if (element.type.equals("org.aspectj.weaver.AjSynthetic")) {
                this.setAjSynthetic(true);
                forRemoval.add(element);
            }
            if (element.type.equals("org.aspectj.weaver.MethodDeclarationLineNumber")) {
                this.mdlnAttribute = (AjAttribute.MethodDeclarationLineNumberAttribute)((AjASMAttribute)element).unpack(this.classDelegate);
                forRemoval.add(element);
            }
            if (element.type.equals("org.aspectj.weaver.Advice")) {
                this.shadowMunger = ((AjAttribute.AdviceAttribute)((AjASMAttribute)element).unpack(this.classDelegate)).reify(this, this.getWorld());
                forRemoval.add(element);
            }
            if (!element.type.equals("org.aspectj.weaver.EffectiveSignature")) continue;
            this.esAttribute = (AjAttribute.EffectiveSignatureAttribute)((AjASMAttribute)element).unpack(this.classDelegate);
            forRemoval.add(element);
        }
        this.attributes.remove(forRemoval);
        this.unpackedAspectJAttributes = true;
    }

    public AjAttribute[] getAttributes(String name) {
        ArrayList<AjAttribute> results = new ArrayList<AjAttribute>();
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            Attribute element = (Attribute)iter.next();
            if (!element.type.equals(name) || !(element instanceof AjASMAttribute)) continue;
            results.add(((AjASMAttribute)element).unpack(this.classDelegate));
        }
        return results.toArray(new AjAttribute[0]);
    }

    public String[] getAttributeNames(boolean onlyIncludeAjOnes) {
        ArrayList<String> strs = new ArrayList<String>();
        boolean i = false;
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            Attribute element = (Attribute)iter.next();
            if (onlyIncludeAjOnes && (!element.type.startsWith("org.aspectj.weaver") || !(element instanceof AjASMAttribute))) continue;
            strs.add(element.type);
        }
        return strs.toArray(new String[0]);
    }

    public String[] getParameterNames() {
        if (super.getParameterNames() == null) {
            this.setParameterNames(Utility.makeArgNames(this.getArity()));
        }
        return super.getParameterNames();
    }

    public ISourceContext getSourceContext() {
        return this.classDelegate.getSourceContext();
    }

    public void addAnAnnotation(AnnotationAJ oneAnnotation) {
        if (this.annos == null) {
            this.annos = new AnnotationsForMemberHolder(this.getWorld());
        }
        this.annos.addAnnotation(oneAnnotation);
    }

    public AnnotationX[] getAnnotations() {
        if (this.annos == null) {
            return AnnotationX.NONE;
        }
        return this.annos.getAnnotations();
    }

    public ResolvedType[] getAnnotationTypes() {
        if (this.annos == null) {
            return ResolvedType.NONE;
        }
        return this.annos.getAnnotationTypes();
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        if (this.annos == null) {
            return false;
        }
        return this.annos.hasAnnotation(ofType);
    }
}

