/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.IClassFile;
import org.aspectj.org.eclipse.jdt.core.ICodeFormatter;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.ToolFactory;
import org.aspectj.org.eclipse.jdt.core.compiler.IScanner;
import org.aspectj.org.eclipse.jdt.core.formatter.CodeFormatter;
import org.aspectj.org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.aspectj.org.eclipse.jdt.core.util.ClassFormatException;
import org.aspectj.org.eclipse.jdt.core.util.IClassFileDisassembler;
import org.aspectj.org.eclipse.jdt.core.util.IClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragment;
import org.aspectj.org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.core.util.Disassembler;
import org.aspectj.org.eclipse.jdt.internal.core.util.PublicScanner;
import org.aspectj.org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class ToolFactory {
    public static ICodeFormatter createCodeFormatter() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = jdtCorePlugin.getDescriptor().getExtensionPoint("codeFormatter");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    try {
                        Object execExt = configElements[j].createExecutableExtension("class");
                        if (execExt instanceof ICodeFormatter) {
                            return (ICodeFormatter)execExt;
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    ++j;
                }
                ++i;
            }
        }
        return ToolFactory.createDefaultCodeFormatter(null);
    }

    public static CodeFormatter createCodeFormatter(Map options) {
        if (options == null) {
            options = JavaCore.getOptions();
        }
        return new DefaultCodeFormatter(options);
    }

    public static ICodeFormatter createDefaultCodeFormatter(Map options) {
        if (options == null) {
            options = JavaCore.getOptions();
        }
        return new org.aspectj.org.eclipse.jdt.internal.formatter.old.CodeFormatter(options);
    }

    public static IClassFileDisassembler createDefaultClassFileDisassembler() {
        class DeprecatedDisassembler
        extends Disassembler
        implements IClassFileDisassembler {
            DeprecatedDisassembler() {
            }
        }
        return new DeprecatedDisassembler();
    }

    public static ClassFileBytesDisassembler createDefaultClassFileBytesDisassembler() {
        return new Disassembler();
    }

    public static IClassFileReader createDefaultClassFileReader(String fileName, int decodingFlag) {
        try {
            return new ClassFileReader(Util.getFileByteContent(new File(fileName)), decodingFlag);
        }
        catch (ClassFormatException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IClassFileReader createDefaultClassFileReader(IClassFile classfile, int decodingFlag) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)classfile.getAncestor(3);
        if (root != null) {
            try {
                if (root instanceof JarPackageFragmentRoot) {
                    String archiveName = null;
                    ZipFile jar = null;
                    try {
                        jar = ((JarPackageFragmentRoot)root).getJar();
                        archiveName = jar.getName();
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        JavaModelManager.getJavaModelManager().closeZipFile(jar);
                        throw throwable;
                    }
                    {
                        Object var5_10 = null;
                        JavaModelManager.getJavaModelManager().closeZipFile(jar);
                    }
                    PackageFragment packageFragment = (PackageFragment)classfile.getParent();
                    String classFileName = classfile.getElementName();
                    String entryName = org.aspectj.org.eclipse.jdt.internal.core.util.Util.concatWith(packageFragment.names, classFileName, '/');
                    return ToolFactory.createDefaultClassFileReader(archiveName, entryName, decodingFlag);
                }
                IPath location = classfile.getResource().getLocation();
                if (location == null) {
                    return null;
                }
                return ToolFactory.createDefaultClassFileReader(location.toOSString(), decodingFlag);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IClassFileReader createDefaultClassFileReader(String zipFileName, String zipEntryName, int decodingFlag) {
        block17: {
            block16: {
                block15: {
                    zipFile = null;
                    try {
                        try {
                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                System.out.println("(" + Thread.currentThread() + ") [ToolFactory.createDefaultClassFileReader()] Creating ZipFile on " + zipFileName);
                            }
                            if ((zipEntry = (zipFile = new ZipFile(zipFileName)).getEntry(zipEntryName)) == null) {
                                var8_7 = null;
                                var6_12 = null;
                                if (zipFile == null) return var8_7;
                                break block15;
                            }
                            if (!zipEntryName.toLowerCase().endsWith(".class")) {
                                var8_8 = null;
                                break block16;
                            }
                            classFileBytes = Util.getZipEntryByteContent(zipEntry, zipFile);
                            var8_9 = new ClassFileReader(classFileBytes, decodingFlag);
                            break block17;
                        }
                        catch (ClassFormatException e) {
                            var8_10 = null;
                            var6_15 = null;
                            if (zipFile == null) return var8_10;
                            try {
                                zipFile.close();
                                return var8_10;
                            }
                            catch (IOException var9_21) {
                                // empty catch block
                            }
                            return var8_10;
                        }
                        catch (IOException e) {
                            var8_11 = null;
                            var6_16 = null;
                            if (zipFile == null) return var8_11;
                            ** try [egrp 2[TRYBLOCK] [7 : 155->162)] { 
lbl37:
                            // 1 sources

                            zipFile.close();
                            return var8_11;
lbl39:
                            // 1 sources

                            catch (IOException var9_22) {
                                // empty catch block
                            }
                            return var8_11;
                        }
                    }
                    catch (Throwable var7_25) {
                        var6_17 = null;
                        if (zipFile == null) throw var7_25;
                        try {}
                        catch (IOException var9_23) {
                            throw var7_25;
                        }
                        zipFile.close();
                        throw var7_25;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [7 : 155->162)] { 
lbl53:
                // 1 sources

                zipFile.close();
                return var8_7;
lbl55:
                // 1 sources

                catch (IOException var9_18) {
                    // empty catch block
                }
                return var8_7;
            }
            var6_13 = null;
            if (zipFile == null) return var8_8;
            ** try [egrp 2[TRYBLOCK] [7 : 155->162)] { 
lbl62:
            // 1 sources

            zipFile.close();
            return var8_8;
lbl64:
            // 1 sources

            catch (IOException var9_19) {
                // empty catch block
            }
            return var8_8;
        }
        var6_14 = null;
        if (zipFile == null) return var8_9;
        ** try [egrp 2[TRYBLOCK] [7 : 155->162)] { 
lbl71:
        // 1 sources

        zipFile.close();
        return var8_9;
lbl73:
        // 1 sources

        catch (IOException var9_20) {
            // empty catch block
        }
        return var8_9;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean assertMode, boolean recordLineSeparator) {
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, assertMode ? 0x300000L : 0x2F0000L, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel) {
        PublicScanner scanner = null;
        long level = CompilerOptions.versionToJdkLevel(sourceLevel);
        if (level == 0L) {
            level = 0x2F0000L;
        }
        scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, level, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel, String complianceLevel) {
        long complianceLevelValue;
        PublicScanner scanner = null;
        long sourceLevelValue = CompilerOptions.versionToJdkLevel(sourceLevel);
        if (sourceLevelValue == 0L) {
            sourceLevelValue = 0x2F0000L;
        }
        if ((complianceLevelValue = CompilerOptions.versionToJdkLevel(complianceLevel)) == 0L) {
            complianceLevelValue = 0x2F0000L;
        }
        scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, sourceLevelValue, complianceLevelValue, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }
}

