/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import javax.units.BaseUnit;
import javax.units.Unit;
import javax.units.UnitFormat;

public final class SI {
    public static final BaseUnit AMPERE;
    public static final BaseUnit CANDELA;
    public static final BaseUnit KELVIN;
    public static final BaseUnit KILOGRAM;
    public static final BaseUnit METER;
    public static final BaseUnit MOLE;
    public static final BaseUnit SECOND;
    public static final Unit GRAM;
    public static final Unit RADIAN;
    public static final Unit STERADIAN;
    public static final Unit BIT;
    public static final Unit HERTZ;
    public static final Unit NEWTON;
    public static final Unit PASCAL;
    public static final Unit JOULE;
    public static final Unit WATT;
    public static final Unit COULOMB;
    public static final Unit VOLT;
    public static final Unit FARAD;
    public static final Unit OHM;
    public static final Unit SIEMENS;
    public static final Unit WEBER;
    public static final Unit TESLA;
    public static final Unit HENRY;
    public static final Unit CELSIUS;
    public static final Unit LUMEN;
    public static final Unit LUX;
    public static final Unit BECQUEREL;
    public static final Unit GRAY;
    public static final Unit SIEVERT;
    public static final Unit KATAL;
    private static final Unit[] SI_UNITS;
    private static final String[] PREFIXES;
    private static final double[] FACTORS;

    private SI() {
    }

    public static Unit YOTTA(Unit unit) {
        return unit.multiply(1.0E24);
    }

    public static Unit ZETTA(Unit unit) {
        return unit.multiply(1.0E21);
    }

    public static Unit EXA(Unit unit) {
        return unit.multiply(1.0E18);
    }

    public static Unit PETA(Unit unit) {
        return unit.multiply(1.0E15);
    }

    public static Unit TERA(Unit unit) {
        return unit.multiply(1.0E12);
    }

    public static Unit GIGA(Unit unit) {
        return unit.multiply(1.0E9);
    }

    public static Unit MEGA(Unit unit) {
        return unit.multiply(1000000.0);
    }

    public static Unit KILO(Unit unit) {
        return unit.multiply(1000.0);
    }

    public static Unit HECTO(Unit unit) {
        return unit.multiply(100.0);
    }

    public static Unit DEKA(Unit unit) {
        return unit.multiply(10.0);
    }

    public static Unit DECI(Unit unit) {
        return unit.multiply(0.1);
    }

    public static Unit CENTI(Unit unit) {
        return unit.multiply(0.01);
    }

    public static Unit MILLI(Unit unit) {
        return unit.multiply(0.001);
    }

    public static Unit MICRO(Unit unit) {
        return unit.multiply(1.0E-6);
    }

    public static Unit NANO(Unit unit) {
        return unit.multiply(1.0E-9);
    }

    public static Unit PICO(Unit unit) {
        return unit.multiply(1.0E-12);
    }

    public static Unit FEMTO(Unit unit) {
        return unit.multiply(1.0E-15);
    }

    public static Unit ATTO(Unit unit) {
        return unit.multiply(1.0E-18);
    }

    public static Unit ZEPTO(Unit unit) {
        return unit.multiply(1.0E-21);
    }

    public static Unit YOCTO(Unit unit) {
        return unit.multiply(1.0E-24);
    }

    static {
        int i;
        AMPERE = BaseUnit.getInstance("A");
        CANDELA = BaseUnit.getInstance("cd");
        KELVIN = BaseUnit.getInstance("K");
        KILOGRAM = BaseUnit.getInstance("kg");
        METER = BaseUnit.getInstance("m");
        MOLE = BaseUnit.getInstance("mol");
        SECOND = BaseUnit.getInstance("s");
        GRAM = KILOGRAM.multiply(0.001);
        RADIAN = Unit.ONE.alternate("rad");
        STERADIAN = Unit.ONE.alternate("sr");
        BIT = Unit.ONE.alternate("bit");
        HERTZ = Unit.ONE.divide(SECOND).alternate("Hz");
        NEWTON = METER.multiply(KILOGRAM).divide(SECOND.pow(2)).alternate("N");
        PASCAL = NEWTON.divide(METER.pow(2)).alternate("Pa");
        JOULE = NEWTON.multiply(METER).alternate("J");
        WATT = JOULE.divide(SECOND).alternate("W");
        COULOMB = SECOND.multiply(AMPERE).alternate("C");
        VOLT = WATT.divide(AMPERE).alternate("V");
        FARAD = COULOMB.divide(VOLT).alternate("F");
        OHM = VOLT.divide(AMPERE).alternate("\u03a9");
        SIEMENS = AMPERE.divide(VOLT).alternate("S");
        WEBER = VOLT.multiply(SECOND).alternate("Wb");
        TESLA = WEBER.divide(METER.pow(2)).alternate("T");
        HENRY = WEBER.divide(AMPERE).alternate("H");
        CELSIUS = KELVIN.add(273.15);
        LUMEN = CANDELA.multiply(STERADIAN).alternate("lm");
        LUX = LUMEN.divide(METER.pow(2)).alternate("lx");
        BECQUEREL = Unit.ONE.divide(SECOND).alternate("Bq");
        GRAY = JOULE.divide(KILOGRAM).alternate("Gy");
        SIEVERT = JOULE.divide(KILOGRAM).alternate("Sv");
        KATAL = MOLE.divide(SECOND).alternate("kat");
        SI_UNITS = new Unit[]{AMPERE, BECQUEREL, CANDELA, COULOMB, FARAD, GRAY, HENRY, HERTZ, JOULE, KATAL, KELVIN, LUMEN, LUX, METER, MOLE, NEWTON, OHM, PASCAL, RADIAN, SECOND, SIEMENS, SIEVERT, STERADIAN, TESLA, VOLT, WATT, WEBER};
        PREFIXES = new String[]{"Y", "Z", "E", "P", "T", "G", "M", "k", "h", "da", "d", "c", "m", "\u00b5", "n", "p", "f", "a", "z", "y"};
        FACTORS = new double[]{1.0E24, 1.0E21, 1.0E18, 1.0E15, 1.0E12, 1.0E9, 1000000.0, 1000.0, 100.0, 10.0, 0.1, 0.01, 0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15, 1.0E-18, 1.0E-21, 1.0E-24};
        for (i = 0; i < SI_UNITS.length; ++i) {
            for (int j = 0; j < PREFIXES.length; ++j) {
                Unit u = SI_UNITS[i].multiply(FACTORS[j]);
                UnitFormat.label(u, PREFIXES[j] + SI.SI_UNITS[i]._symbol);
            }
        }
        UnitFormat.label(GRAM, "g");
        for (i = 0; i < PREFIXES.length; ++i) {
            if (FACTORS[i] == 1000.0) continue;
            UnitFormat.label(KILOGRAM.multiply(FACTORS[i] * 0.001), PREFIXES[i] + "g");
        }
        UnitFormat.label(CELSIUS, "\u00b0C");
        for (i = 0; i < PREFIXES.length; ++i) {
            UnitFormat.label(CELSIUS.multiply(FACTORS[i]), PREFIXES[i] + "\u00b0C");
        }
    }
}

