/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import javax.media.jai.util.Range;
import org.geotools.resources.ClassChanger;
import org.geotools.resources.XMath;

public class NumberRange
extends Range {
    private static final long serialVersionUID = -818167965963008231L;

    public NumberRange(byte minimum, byte maximum) {
        this(minimum, true, maximum, true);
    }

    public NumberRange(byte minimum, boolean isMinIncluded, byte maximum, boolean isMaxIncluded) {
        super(Byte.class, (Comparable)new Byte(minimum), isMinIncluded, (Comparable)new Byte(maximum), isMaxIncluded);
    }

    public NumberRange(short minimum, short maximum) {
        this(minimum, true, maximum, true);
    }

    public NumberRange(short minimum, boolean isMinIncluded, short maximum, boolean isMaxIncluded) {
        super(Short.class, (Comparable)new Short(minimum), isMinIncluded, (Comparable)new Short(maximum), isMaxIncluded);
    }

    public NumberRange(int minimum, int maximum) {
        this(minimum, true, maximum, true);
    }

    public NumberRange(int minimum, boolean isMinIncluded, int maximum, boolean isMaxIncluded) {
        super(Integer.class, (Comparable)new Integer(minimum), isMinIncluded, (Comparable)new Integer(maximum), isMaxIncluded);
    }

    public NumberRange(long minimum, long maximum) {
        this(minimum, true, maximum, true);
    }

    public NumberRange(long minimum, boolean isMinIncluded, long maximum, boolean isMaxIncluded) {
        super(Long.class, (Comparable)new Long(minimum), isMinIncluded, (Comparable)new Long(maximum), isMaxIncluded);
    }

    public NumberRange(float minimum, float maximum) {
        this(minimum, true, maximum, true);
    }

    public NumberRange(float minimum, boolean isMinIncluded, float maximum, boolean isMaxIncluded) {
        super(Float.class, (Comparable)new Float(minimum), isMinIncluded, (Comparable)new Float(maximum), isMaxIncluded);
    }

    public NumberRange(double minimum, double maximum) {
        this(minimum, true, maximum, true);
    }

    public NumberRange(double minimum, boolean isMinIncluded, double maximum, boolean isMaxIncluded) {
        super(Double.class, (Comparable)new Double(minimum), isMinIncluded, (Comparable)new Double(maximum), isMaxIncluded);
    }

    NumberRange(Class type, Comparable minimum, Comparable maximum) {
        super(type, minimum, maximum);
    }

    public NumberRange(Class type, Number minimum, Number maximum) {
        super(type, (Comparable)((Object)minimum), (Comparable)((Object)maximum));
    }

    public NumberRange(Class type, Number minimum, boolean isMinIncluded, Number maximum, boolean isMaxIncluded) {
        super(type, (Comparable)((Object)minimum), isMinIncluded, (Comparable)((Object)maximum), isMaxIncluded);
    }

    NumberRange(Class type, Range range) throws ClassCastException {
        this(type, ClassChanger.cast((Number)((Object)range.getMinValue()), type), range.isMinIncluded(), ClassChanger.cast((Number)((Object)range.getMaxValue()), type), range.isMaxIncluded());
    }

    public NumberRange(Range range) throws ClassCastException {
        this(range.getElementClass(), (Number)((Object)range.getMinValue()), range.isMinIncluded(), (Number)((Object)range.getMaxValue()), range.isMaxIncluded());
    }

    public static NumberRange wrap(Range range) {
        if (range instanceof NumberRange) {
            return (NumberRange)range;
        }
        return new NumberRange(range);
    }

    NumberRange convertAndCast(Range range, Class type) {
        if (type.equals(range.getElementClass())) {
            return NumberRange.wrap(range);
        }
        return new NumberRange(type, range);
    }

    public NumberRange castTo(Class type) {
        return this.convertAndCast(this, type);
    }

    public boolean contains(Comparable value) {
        return this.contains((Number)((Object)value));
    }

    public boolean contains(Number value) {
        Class type = ClassChanger.getWidestClass(this.getElementClass(), value.getClass());
        return this.castTo(type)._contains(ClassChanger.cast(value, type));
    }

    private boolean _contains(Number value) {
        return super.contains((Comparable)((Object)value));
    }

    public boolean contains(Range range) {
        Class type = ClassChanger.getWidestClass(this.getElementClass(), range.getElementClass());
        return this.castTo(type)._contains(this.convertAndCast(range, type));
    }

    private boolean _contains(Range range) {
        return super.contains(range);
    }

    public boolean intersects(Range range) {
        Class type = ClassChanger.getWidestClass(this.getElementClass(), range.getElementClass());
        return this.castTo(type)._intersects(this.convertAndCast(range, type));
    }

    private boolean _intersects(Range range) {
        return super.intersects(range);
    }

    public Range union(Range range) {
        Class type = ClassChanger.getWidestClass(this.getElementClass(), range.getElementClass());
        return NumberRange.wrap(this.castTo(type)._union(this.convertAndCast(range, type)));
    }

    private Range _union(Range range) {
        return super.union(range);
    }

    public Range intersect(Range range) {
        Class type = ClassChanger.getWidestClass(this.getElementClass(), range.getElementClass());
        Range result = this.castTo(type)._intersect(this.convertAndCast(range, type));
        type = ClassChanger.getFinestClass(this.getElementClass(), range.getElementClass());
        return this.convertAndCast(result, ClassChanger.getWidestClass(type, ClassChanger.getWidestClass(ClassChanger.getFinestClass(((Number)((Object)result.getMinValue())).doubleValue()), ClassChanger.getFinestClass(((Number)((Object)result.getMaxValue())).doubleValue()))));
    }

    private Range _intersect(Range range) {
        return super.intersect(range);
    }

    public Range[] subtract(Range range) {
        Class type = ClassChanger.getWidestClass(this.getElementClass(), range.getElementClass());
        Range[] result = this.castTo(type)._subtract(this.convertAndCast(range, type));
        if (result != null) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = NumberRange.wrap(result[i]);
            }
        }
        return result;
    }

    private Range[] _subtract(Range range) {
        return super.subtract(range);
    }

    public double getMinimum() {
        Number value = (Number)((Object)this.getMinValue());
        return value != null ? value.doubleValue() : Double.NEGATIVE_INFINITY;
    }

    public double getMinimum(boolean inclusive) {
        double value = this.getMinimum();
        if (inclusive != this.isMinIncluded()) {
            value = XMath.rool(this.getElementClass(), value, inclusive ? 1 : -1);
        }
        return value;
    }

    public double getMaximum() {
        Number value = (Number)((Object)this.getMaxValue());
        return value != null ? value.doubleValue() : Double.POSITIVE_INFINITY;
    }

    public double getMaximum(boolean inclusive) {
        double value = this.getMaximum();
        if (inclusive != this.isMaxIncluded()) {
            value = XMath.rool(this.getElementClass(), value, inclusive ? -1 : 1);
        }
        return value;
    }
}

