/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.Factories;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryIteratorProvider;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.factory.RecursiveSearchException;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;

public class FactoryRegistry
extends ServiceRegistry {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.factory");
    private static final Level DEBUG_LEVEL = Level.FINEST;
    private final Factories globalConfiguration = new Factories();
    private final Set scanningCategories = new HashSet();
    private final Set testingAvailability = new HashSet();
    private final Set testingHints = new HashSet();

    public FactoryRegistry(Collection categories) {
        super(categories.iterator());
    }

    public Iterator getServiceProviders(Class category) {
        return this.getServiceProviders(category, null, null);
    }

    public Iterator getServiceProviders(final Class category, final ServiceRegistry.Filter filter, final Hints hints) {
        if (this.scanningCategories.contains(category)) {
            throw new RecursiveSearchException(category);
        }
        ServiceRegistry.Filter hintsFilter = new ServiceRegistry.Filter(){

            public boolean filter(Object provider) {
                return FactoryRegistry.this.isAcceptable(provider, category, hints, filter);
            }
        };
        this.synchronizeIteratorProviders();
        Iterator iterator = this.getServiceProviders(category, hintsFilter, true);
        if (!iterator.hasNext()) {
            this.scanForPlugins(this.getClassLoaders(), category);
            iterator = this.getServiceProviders(category, hintsFilter, true);
        }
        return iterator;
    }

    final Iterator getUnfilteredProviders(Class category) {
        if (!this.scanningCategories.isEmpty() && this.scanningCategories.contains(category)) {
            throw new RecursiveSearchException(category);
        }
        Iterator iterator = this.getServiceProviders(category, true);
        if (!iterator.hasNext()) {
            this.scanForPlugins(this.getClassLoaders(), category);
            iterator = this.getServiceProviders(category, true);
        }
        return iterator;
    }

    public Object getServiceProvider(Class category, ServiceRegistry.Filter filter, Hints hints, Hints.Key key) throws FactoryRegistryException {
        Object candidate;
        this.synchronizeIteratorProviders();
        boolean debug = LOGGER.isLoggable(DEBUG_LEVEL);
        if (debug) {
            FactoryRegistry.debug("ENTRY", category, key, null, null);
        }
        Class implementation = null;
        if (key != null) {
            Object hint;
            Class valueClass = key.getValueClass();
            if (!category.isAssignableFrom(valueClass)) {
                if (debug) {
                    FactoryRegistry.debug("THROW", category, key, "unexpected type:", valueClass);
                }
                throw new IllegalArgumentException(Errors.format(190, key));
            }
            if (hints != null && (hint = hints.get(key)) != null) {
                if (debug) {
                    FactoryRegistry.debug("CHECK", category, key, "user provided a", hint.getClass());
                }
                if (category.isInstance(hint)) {
                    if (debug) {
                        FactoryRegistry.debug("RETURN", category, key, "return hint as provided.", null);
                    }
                    return hint;
                }
                if ((hints = new Hints((Map)hints)).remove(key) != hint) {
                    throw new AssertionError(key);
                }
                if (hint instanceof Class[]) {
                    Class[] types = (Class[])hint;
                    int length = types.length;
                    for (int i = 0; i < length - 1; ++i) {
                        Object candidate2;
                        Class type = types[i];
                        if (debug) {
                            FactoryRegistry.debug("CHECK", category, key, "consider hint[" + i + ']', type);
                        }
                        if ((candidate2 = this.getServiceImplementation(category, type, filter, hints)) == null) continue;
                        if (debug) {
                            FactoryRegistry.debug("RETURN", category, key, "found implementation", candidate2.getClass());
                        }
                        return candidate2;
                    }
                    if (length != 0) {
                        implementation = types[length - 1];
                    }
                } else {
                    implementation = (Class)hint;
                }
            }
        }
        if (debug && implementation != null) {
            FactoryRegistry.debug("CHECK", category, key, "consider hint[last]", implementation);
        }
        if ((candidate = this.getServiceImplementation(category, implementation, filter, hints)) != null) {
            if (debug) {
                FactoryRegistry.debug("RETURN", category, key, "found implementation", candidate.getClass());
            }
            return candidate;
        }
        if (debug) {
            FactoryRegistry.debug("THROW", category, key, "could not find implementation.", null);
        }
        throw new FactoryNotFoundException(Errors.format(189, Utilities.getShortName(implementation != null ? implementation : category)));
    }

    private static void debug(String status, Class category, Hints.Key key, String message, Class type) {
        StringBuffer buffer = new StringBuffer(status);
        buffer.append(Utilities.spaces(Math.max(1, 7 - status.length()))).append('(').append(Utilities.getShortName(category));
        if (key != null) {
            buffer.append(", ").append(key);
        }
        buffer.append(')');
        if (message != null) {
            buffer.append(": ").append(message);
        }
        if (type != null) {
            buffer.append(' ').append(Utilities.getShortName(type)).append('.');
        }
        LogRecord record = new LogRecord(DEBUG_LEVEL, buffer.toString());
        record.setSourceClassName(FactoryRegistry.class.getName());
        record.setSourceMethodName("getServiceProvider");
        LOGGER.log(record);
    }

    private Object getServiceImplementation(Class category, Class implementation, ServiceRegistry.Filter filter, Hints hints) {
        Iterator it = this.getUnfilteredProviders(category);
        while (it.hasNext()) {
            Object candidate = it.next();
            if (implementation != null && !implementation.isInstance(candidate) || !this.isAcceptable(candidate, category, hints, filter)) continue;
            return candidate;
        }
        List cached = this.getCachedProviders(category);
        if (cached != null) {
            Iterator it2 = cached.iterator();
            while (it2.hasNext()) {
                Object candidate = ((Reference)it2.next()).get();
                if (candidate == null) {
                    it2.remove();
                    continue;
                }
                if (implementation != null && !implementation.isInstance(candidate) || !this.isAcceptable(candidate, category, hints, filter)) continue;
                return candidate;
            }
        }
        return null;
    }

    List getCachedProviders(Class category) {
        return null;
    }

    final boolean isAcceptable(Object candidate, Class category, Hints hints, ServiceRegistry.Filter filter) {
        if (filter != null && !filter.filter(candidate)) {
            return false;
        }
        if (!this.isAvailable(candidate)) {
            return false;
        }
        if (hints != null && candidate instanceof Factory && !this.usesAcceptableHints((Factory)candidate, category, hints, null)) {
            return false;
        }
        return this.isAcceptable(candidate, category, hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean usesAcceptableHints(Factory factory, Class category, Hints hints, Set alreadyDone) {
        Map implementationHints;
        if (!this.testingHints.add(factory)) {
            return false;
        }
        try {
            implementationHints = Hints.stripNonKeys(factory.getImplementationHints());
        }
        finally {
            if (!this.testingHints.remove(factory)) {
                throw new AssertionError(factory);
            }
        }
        if (implementationHints == null) {
            return true;
        }
        Hints remaining = null;
        for (Map.Entry entry : implementationHints.entrySet()) {
            Class type;
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object expected = hints.get(key);
            if (expected != null) {
                if (expected instanceof Class) {
                    if (!((Class)expected).isInstance(value)) {
                        return false;
                    }
                } else if (expected instanceof Class[]) {
                    Class[] types = (Class[])expected;
                    int i = 0;
                    do {
                        if (i < types.length) continue;
                        return false;
                    } while (!types[i++].isInstance(value));
                } else if (!expected.equals(value)) {
                    return false;
                }
            }
            if (!this.isAcceptable(value, category, hints)) {
                return false;
            }
            if (!(value instanceof Factory)) continue;
            Factory dependency = (Factory)value;
            if (alreadyDone == null) {
                alreadyDone = new HashSet<Factory>();
            }
            if (alreadyDone.contains(dependency)) continue;
            alreadyDone.add(factory);
            if (remaining == null) {
                remaining = new Hints((Map)hints);
                remaining.keySet().removeAll(implementationHints.keySet());
            }
            if (this.usesAcceptableHints(dependency, type = key instanceof Hints.Key ? ((Hints.Key)key).getValueClass() : Factory.class, remaining, alreadyDone)) continue;
            return false;
        }
        return true;
    }

    protected boolean isAcceptable(Object provider, Class category, Hints hints) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAvailable(Object provider) {
        if (!(provider instanceof OptionalFactory)) {
            return true;
        }
        OptionalFactory factory = (OptionalFactory)provider;
        Class<?> type = factory.getClass();
        if (!this.testingAvailability.add(type)) {
            throw new RecursiveSearchException(type);
        }
        try {
            boolean bl = factory.isAvailable();
            return bl;
        }
        finally {
            if (!this.testingAvailability.remove(type)) {
                throw new AssertionError(type);
            }
        }
    }

    public final Set getClassLoaders() {
        HashSet<ClassLoader> loaders = new HashSet<ClassLoader>();
        for (int i = 0; i < 4; ++i) {
            ClassLoader loader;
            try {
                switch (i) {
                    case 0: {
                        loader = this.getClass().getClassLoader();
                        break;
                    }
                    case 1: {
                        loader = FactoryRegistry.class.getClassLoader();
                        break;
                    }
                    case 2: {
                        loader = Thread.currentThread().getContextClassLoader();
                        break;
                    }
                    case 3: {
                        loader = ClassLoader.getSystemClassLoader();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
            }
            catch (SecurityException exception) {
                continue;
            }
            loaders.add(loader);
        }
        loaders.remove(null);
        for (ClassLoader loader : loaders.toArray(new ClassLoader[loaders.size()])) {
            try {
                while ((loader = loader.getParent()) != null) {
                    loaders.remove(loader);
                }
            }
            catch (SecurityException exception) {
                // empty catch block
            }
        }
        if (loaders.isEmpty()) {
            LOGGER.warning("No class loaders available");
        }
        return loaders;
    }

    public void scanForPlugins() {
        Set loaders = this.getClassLoaders();
        Iterator<Class<?>> categories = this.getCategories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            this.scanForPlugins(loaders, category);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForPlugins(Collection loaders, Class category) {
        if (!this.scanningCategories.add(category)) {
            throw new RecursiveSearchException(category);
        }
        try {
            StringBuffer message = FactoryRegistry.getLogHeader(category);
            boolean newServices = false;
            for (ClassLoader loader : loaders) {
                newServices |= this.register(FactoryRegistry.lookupProviders(category, loader), category, message);
                newServices |= this.registerFromSystemProperty(loader, category, message);
            }
            FactoryIteratorProvider[] fip = Factories.getIteratorProviders();
            for (int i = 0; i < fip.length; ++i) {
                Iterator it = fip[i].iterator(category);
                if (it == null) continue;
                newServices |= this.register(it, category, message);
            }
            if (newServices) {
                FactoryRegistry.log("scanForPlugins", message);
            }
        }
        finally {
            if (!this.scanningCategories.remove(category)) {
                throw new AssertionError(category);
            }
        }
    }

    private boolean register(Iterator factories, Class category, StringBuffer message) {
        boolean newServices = false;
        String lineSeparator = System.getProperty("line.separator", "\n");
        while (factories.hasNext()) {
            Object factory;
            try {
                factory = factories.next();
            }
            catch (OutOfMemoryError error) {
                throw error;
            }
            catch (NoClassDefFoundError error) {
                FactoryRegistry.loadingFailure(category, error, false);
                continue;
            }
            catch (ExceptionInInitializerError error) {
                Throwable cause = error.getCause();
                if (cause != null) {
                    FactoryRegistry.loadingFailure(category, cause, true);
                }
                throw error;
            }
            catch (Error error) {
                if (!Utilities.getShortClassName(error).equals("ServiceConfigurationError")) {
                    throw error;
                }
                FactoryRegistry.loadingFailure(category, error, true);
                continue;
            }
            Class<?> factoryClass = factory.getClass();
            Object replacement = this.getServiceProviderByClass(factoryClass);
            if (replacement != null) {
                factory = replacement;
            }
            if (!this.registerServiceProvider(factory, category)) continue;
            message.append(lineSeparator);
            message.append("  ");
            message.append(factoryClass.getName());
            newServices = true;
        }
        return newServices;
    }

    private boolean registerFromSystemProperty(ClassLoader loader, Class category, StringBuffer message) {
        boolean newServices;
        block10: {
            newServices = false;
            try {
                String classname = System.getProperty(category.getName());
                if (classname == null) break block10;
                try {
                    Class<?> factoryClass = loader.loadClass(classname);
                    Object factory = this.getServiceProviderByClass(factoryClass);
                    if (factory == null) {
                        try {
                            factory = factoryClass.newInstance();
                            if (this.registerServiceProvider(factory, category)) {
                                message.append(System.getProperty("line.separator", "\n"));
                                message.append("  ");
                                message.append(factoryClass.getName());
                                newServices = true;
                            }
                        }
                        catch (IllegalAccessException exception) {
                            throw new FactoryRegistryException(Errors.format(184, classname), exception);
                        }
                        catch (InstantiationException exception) {
                            throw new FactoryRegistryException(Errors.format(184, classname), exception);
                        }
                    }
                    Iterator it = this.getServiceProviders(category, false);
                    while (it.hasNext()) {
                        Object other = it.next();
                        if (other == factory) continue;
                        this.setOrdering(category, factory, other);
                    }
                }
                catch (ClassNotFoundException exception) {
                }
            }
            catch (SecurityException exception) {
                // empty catch block
            }
        }
        return newServices;
    }

    private static void loadingFailure(Class category, Throwable error, boolean showStackTrace) {
        String name = Utilities.getShortName(category);
        StringBuffer cause = new StringBuffer(Utilities.getShortClassName(error));
        String message = error.getLocalizedMessage();
        if (message != null) {
            cause.append(": ");
            cause.append(message);
        }
        LogRecord record = Logging.format(Level.WARNING, 30, name, cause.toString());
        if (showStackTrace) {
            record.setThrown(error);
        }
        record.setSourceClassName(FactoryRegistry.class.getName());
        record.setSourceMethodName("scanForPlugins");
        LOGGER.log(record);
    }

    private static StringBuffer getLogHeader(Class category) {
        return new StringBuffer(Logging.getResources(null).getString(32, Utilities.getShortName(category)));
    }

    private static void log(String method, StringBuffer message) {
        LogRecord record = new LogRecord(Level.CONFIG, message.toString());
        record.setSourceClassName(FactoryRegistry.class.getName());
        record.setSourceMethodName(method);
        LOGGER.log(record);
    }

    private void synchronizeIteratorProviders() {
        FactoryIteratorProvider[] newProviders = this.globalConfiguration.synchronizeIteratorProviders();
        if (newProviders == null) {
            return;
        }
        Iterator<Class<?>> categories = this.getCategories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            if (!this.getServiceProviders(category, false).hasNext()) continue;
            for (int i = 0; i < newProviders.length; ++i) {
                StringBuffer message;
                FactoryIteratorProvider provider = newProviders[i];
                Iterator it = provider.iterator(category);
                if (it == null || !this.register(it, category, message = FactoryRegistry.getLogHeader(category))) continue;
                FactoryRegistry.log("synchronizeIteratorProviders", message);
            }
        }
    }

    public boolean setOrdering(Class category, Comparator comparator) {
        boolean set = false;
        ArrayList previous = new ArrayList();
        Iterator it = this.getServiceProviders(category, false);
        while (it.hasNext()) {
            Object f1 = it.next();
            int i = previous.size();
            while (--i >= 0) {
                int c;
                Object f2 = previous.get(i);
                try {
                    c = comparator.compare(f1, f2);
                }
                catch (ClassCastException exception) {
                    continue;
                }
                if (c > 0) {
                    set |= this.setOrdering(category, f1, f2);
                    continue;
                }
                if (c >= 0) continue;
                set |= this.setOrdering(category, f2, f1);
            }
            previous.add(f1);
        }
        return set;
    }

    public boolean setOrdering(Class base, boolean set, ServiceRegistry.Filter service1, ServiceRegistry.Filter service2) {
        boolean done = false;
        Iterator<Class<?>> categories = this.getCategories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            if (!base.isAssignableFrom(category)) continue;
            Object impl1 = null;
            Object impl2 = null;
            Iterator<?> it = this.getServiceProviders(category, false);
            while (it.hasNext()) {
                Object factory = it.next();
                if (service1.filter(factory)) {
                    impl1 = factory;
                }
                if (service2.filter(factory)) {
                    impl2 = factory;
                }
                if (impl1 == null || impl2 == null || impl1 == impl2) continue;
                if (set) {
                    done |= this.setOrdering(category, impl1, impl2);
                    continue;
                }
                done |= this.unsetOrdering(category, impl1, impl2);
            }
        }
        return done;
    }
}

