/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.lib.tracing;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.SourceLocation;
import org.aspectj.lib.tracing.TraceJoinPointsBase;

public abstract class TraceJoinPoints
extends TraceJoinPointsBase {
    PrintStream out;
    int logs = 0;
    int depth = 0;
    boolean terminal = false;

    public void message(String s) {
        this.out.println("<message>" + this.prepareMessage(s) + "</message>");
    }

    protected void startLog() {
        this.makeLogStream();
    }

    protected void completeLog() {
        this.closeLogStream();
    }

    protected void logEnter(JoinPoint.StaticPart jp) {
        if (this.terminal) {
            this.out.println(">");
        }
        this.indent(this.depth);
        this.out.print("<" + jp.getKind());
        this.writeSig(jp);
        this.writePos(jp);
        ++this.depth;
        this.terminal = true;
    }

    protected void logExit(JoinPoint.StaticPart jp) {
        --this.depth;
        if (this.terminal) {
            this.getOut().println("/>");
        } else {
            this.indent(this.depth);
            this.getOut().println("</" + jp.getKind() + ">");
        }
        this.terminal = false;
    }

    protected PrintStream getOut() {
        if (this.out == null) {
            String m = "not in the control flow of entry()";
            throw new IllegalStateException(m);
        }
        return this.out;
    }

    protected void makeLogStream() {
        try {
            String name = "log" + this.logs++ + ".xml";
            this.out = new PrintStream(new FileOutputStream(name));
        }
        catch (IOException iOException) {
            this.out = System.err;
        }
    }

    protected void closeLogStream() {
        PrintStream out = this.out;
        if (out != null) {
            out.close();
        }
    }

    protected String prepareMessage(String s) {
        return s;
    }

    void message(String sink, String s) {
        if (sink == null) {
            this.message(s);
        } else {
            this.getOut().println("<message sink=" + this.quoteXml(sink) + " >" + this.prepareMessage(s) + "</message>");
        }
    }

    void writeSig(JoinPoint.StaticPart jp) {
        PrintStream out = this.getOut();
        out.print(" sig=");
        out.print(this.quoteXml(jp.getSignature().toShortString()));
    }

    void writePos(JoinPoint.StaticPart jp) {
        SourceLocation loc = jp.getSourceLocation();
        if (loc == null) {
            return;
        }
        PrintStream out = this.getOut();
        out.print(" pos=");
        out.print(this.quoteXml(String.valueOf(loc.getFileName()) + ":" + loc.getLine() + ":" + loc.getColumn()));
    }

    protected String quoteXml(String s) {
        return "\"" + s.replace('<', '_').replace('>', '_') + "\"";
    }

    protected void indent(int i) {
        PrintStream out = this.getOut();
        while (i-- > 0) {
            out.print("  ");
        }
    }
}

