/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;

public class ForwardedHeaderFilter
extends OncePerRequestFilter {
    private static final Set<String> FORWARDED_HEADER_NAMES = Collections.newSetFromMap(new LinkedCaseInsensitiveMap(5, Locale.ENGLISH));
    private final UrlPathHelper pathHelper = new UrlPathHelper();

    @Override
    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!FORWARDED_HEADER_NAMES.contains(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    @Override
    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        ForwardedHeaderRequestWrapper wrappedRequest = new ForwardedHeaderRequestWrapper(request, this.pathHelper);
        ForwardedHeaderResponseWrapper wrappedResponse = new ForwardedHeaderResponseWrapper(response, (HttpServletRequest)wrappedRequest);
        filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
    }

    static {
        FORWARDED_HEADER_NAMES.add("Forwarded");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Host");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Port");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Proto");
        FORWARDED_HEADER_NAMES.add("X-Forwarded-Prefix");
    }

    private static class ForwardedHeaderResponseWrapper
    extends HttpServletResponseWrapper {
        private static final String FOLDER_SEPARATOR = "/";
        private final HttpServletRequest request;

        public ForwardedHeaderResponseWrapper(HttpServletResponse response, HttpServletRequest request) {
            super(response);
            this.request = request;
        }

        public void sendRedirect(String location) throws IOException {
            UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(location);
            if (builder.build().getScheme() != null) {
                super.sendRedirect(location);
                return;
            }
            if (location.startsWith("//")) {
                String scheme = this.request.getScheme();
                super.sendRedirect(builder.scheme(scheme).toUriString());
                return;
            }
            String path = location.startsWith(FOLDER_SEPARATOR) ? this.request.getContextPath() + location : StringUtils.applyRelativePath((String)this.request.getRequestURI(), (String)location);
            String result = UriComponentsBuilder.fromHttpRequest(new ServletServerHttpRequest(this.request)).replacePath(path).build().normalize().toUriString();
            super.sendRedirect(result);
        }
    }

    private static class ForwardedHeaderRequestWrapper
    extends HttpServletRequestWrapper {
        private final String scheme;
        private final boolean secure;
        private final String host;
        private final int port;
        private final String contextPath;
        private final String requestUri;
        private final StringBuffer requestUrl;
        private final Map<String, List<String>> headers;

        public ForwardedHeaderRequestWrapper(HttpServletRequest request, UrlPathHelper pathHelper) {
            super(request);
            ServletServerHttpRequest httpRequest = new ServletServerHttpRequest(request);
            UriComponents uriComponents = UriComponentsBuilder.fromHttpRequest(httpRequest).build();
            int port = uriComponents.getPort();
            this.scheme = uriComponents.getScheme();
            this.secure = "https".equals(this.scheme);
            this.host = uriComponents.getHost();
            this.port = port == -1 ? (this.secure ? 443 : 80) : port;
            String prefix = ForwardedHeaderRequestWrapper.getForwardedPrefix(request);
            this.contextPath = prefix != null ? prefix : request.getContextPath();
            this.requestUri = this.contextPath + pathHelper.getPathWithinApplication(request);
            this.requestUrl = new StringBuffer(this.scheme + "://" + this.host + (port == -1 ? "" : ":" + port) + this.requestUri);
            this.headers = ForwardedHeaderRequestWrapper.initHeaders(request);
        }

        private static String getForwardedPrefix(HttpServletRequest request) {
            String prefix = null;
            Enumeration names = request.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!"X-Forwarded-Prefix".equalsIgnoreCase(name)) continue;
                prefix = request.getHeader(name);
            }
            if (prefix != null) {
                while (prefix.endsWith("/")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                }
            }
            return prefix;
        }

        private static Map<String, List<String>> initHeaders(HttpServletRequest request) {
            LinkedCaseInsensitiveMap headers = new LinkedCaseInsensitiveMap(Locale.ENGLISH);
            Enumeration names = request.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (FORWARDED_HEADER_NAMES.contains(name)) continue;
                headers.put(name, Collections.list(request.getHeaders(name)));
            }
            return headers;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getServerName() {
            return this.host;
        }

        public int getServerPort() {
            return this.port;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getRequestURI() {
            return this.requestUri;
        }

        public StringBuffer getRequestURL() {
            return this.requestUrl;
        }

        public String getHeader(String name) {
            List<String> value = this.headers.get(name);
            return CollectionUtils.isEmpty(value) ? null : value.get(0);
        }

        public Enumeration<String> getHeaders(String name) {
            List<String> value = this.headers.get(name);
            return Collections.enumeration(value != null ? value : Collections.emptySet());
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(this.headers.keySet());
        }
    }
}

