/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.serializer;

import com.gisgraphy.serializer.common.AbstractSerializer;
import com.gisgraphy.serializer.common.OutputFormat;
import com.gisgraphy.serializer.common.SerializerException;
import com.gisgraphy.serializer.json.JsonSerializer;
import com.gisgraphy.serializer.php.PhpSerializer;
import com.gisgraphy.serializer.python.PythonSerializer;
import com.gisgraphy.serializer.ruby.RubySerializer;
import com.gisgraphy.serializer.xml.JaxbXmlSerializer;
import com.gisgraphy.serializer.yaml.YamlSerializer;

public class UniversalSerializerStrategy {
    private JaxbXmlSerializer xmlSerializer = new JaxbXmlSerializer();
    private JsonSerializer jsonSerializer = new JsonSerializer();
    private PhpSerializer phpSerializer = new PhpSerializer();
    private PythonSerializer pythonSerializer = new PythonSerializer();
    private RubySerializer rubySerializer = new RubySerializer();
    private YamlSerializer yamlSerializer = new YamlSerializer();

    public AbstractSerializer getSerializerFromFormat(OutputFormat format) {
        if (format == OutputFormat.XML) {
            return this.xmlSerializer;
        }
        if (format == OutputFormat.JSON) {
            return this.jsonSerializer;
        }
        if (format == OutputFormat.PHP) {
            return this.phpSerializer;
        }
        if (format == OutputFormat.PYTHON) {
            return this.pythonSerializer;
        }
        if (format == OutputFormat.RUBY) {
            return this.rubySerializer;
        }
        if (format == OutputFormat.YAML) {
            return this.yamlSerializer;
        }
        throw new SerializerException(format + " is not supported");
    }
}

