/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.tools.view.DataInfo;
import org.apache.velocity.tools.view.ToolInfo;
import org.apache.velocity.tools.view.ToolboxManager;
import org.apache.velocity.tools.view.ViewToolInfo;
import org.apache.velocity.tools.view.context.ToolboxContext;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public abstract class XMLToolboxManager
implements ToolboxManager {
    public static final String BASE_NODE = "toolbox";
    public static final String ELEMENT_TOOL = "tool";
    public static final String ELEMENT_DATA = "data";
    public static final String ELEMENT_KEY = "key";
    public static final String ELEMENT_CLASS = "class";
    public static final String ELEMENT_VALUE = "value";
    public static final String ATTRIBUTE_TYPE = "type";
    private List toolinfo = new ArrayList();

    public void addTool(ToolInfo info) {
        this.toolinfo.add(info);
    }

    public ToolboxContext getToolboxContext(Object initData) {
        HashMap<String, Object> toolbox = new HashMap<String, Object>();
        Iterator i = this.toolinfo.iterator();
        while (i.hasNext()) {
            ToolInfo info = (ToolInfo)i.next();
            toolbox.put(info.getKey(), info.getInstance(initData));
        }
        return new ToolboxContext(toolbox);
    }

    protected void log(String s) {
        Velocity.info((Object)("XMLToolboxManager - " + s));
    }

    public void load(InputStream input) throws Exception {
        this.log("Loading toolbox...");
        Document document = new SAXReader().read(input);
        List elements = document.selectNodes("//toolbox/*");
        int elementsRead = 0;
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!this.readElement(e)) continue;
            ++elementsRead;
        }
        this.log("Toolbox loaded.  Read " + elementsRead + " elements.");
    }

    protected boolean readElement(Element e) throws Exception {
        String name = e.getName();
        ToolInfo info = null;
        if (name.equalsIgnoreCase(ELEMENT_TOOL)) {
            info = this.readToolInfo(e);
        } else if (name.equalsIgnoreCase(ELEMENT_DATA)) {
            info = this.readDataInfo(e);
        } else {
            this.log("Could not read element: " + name);
            return false;
        }
        this.addTool(info);
        this.log("Added " + info.getClassname() + " as " + info.getKey());
        return true;
    }

    protected ToolInfo readToolInfo(Element e) throws Exception {
        Node n = e.selectSingleNode(ELEMENT_KEY);
        String key = n.getText();
        n = e.selectSingleNode(ELEMENT_CLASS);
        String classname = n.getText();
        return new ViewToolInfo(key, classname);
    }

    protected ToolInfo readDataInfo(Element e) throws Exception {
        Node n = e.selectSingleNode(ELEMENT_KEY);
        String key = n.getText();
        n = e.selectSingleNode(ELEMENT_VALUE);
        String value = n.getText();
        String type = e.attributeValue(ATTRIBUTE_TYPE, DataInfo.TYPE_STRING);
        return new DataInfo(key, type, value);
    }
}

