/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.UConverterAliasDataReader;
import com.ibm.icu.impl.ICUData;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class UConverterAlias {
    static final int UNNORMALIZED = 0;
    static final int STD_NORMALIZED = 1;
    static final int AMBIGUOUS_ALIAS_MAP_BIT = 32768;
    static final int CONTAINS_OPTION_BIT = 16384;
    static final int CONVERTER_INDEX_MASK = 4095;
    static final int NUM_RESERVED_TAGS = 2;
    static final int NUM_HIDDEN_TAGS = 1;
    static int[] gConverterList = null;
    static int[] gTagList = null;
    static int[] gAliasList = null;
    static int[] gUntaggedConvArray = null;
    static int[] gTaggedAliasArray = null;
    static int[] gTaggedAliasLists = null;
    static int[] gOptionTable = null;
    static byte[] gStringTable = null;
    static byte[] gNormalizedStringTable = null;
    static final int tocLengthIndex = 0;
    private static final int converterListIndex = 1;
    private static final int tagListIndex = 2;
    private static final int aliasListIndex = 3;
    private static final int untaggedConvArrayIndex = 4;
    private static final int taggedAliasArrayIndex = 5;
    private static final int taggedAliasListsIndex = 6;
    private static final int optionTableIndex = 7;
    private static final int stringTableIndex = 8;
    private static final int normalizedStringTableIndex = 9;
    private static final int minTocLength = 9;
    private static final int offsetsCount = 10;
    static ByteBuffer gAliasData = null;
    private static final String CNVALIAS_DATA_FILE_NAME = "data/icudt38b/cnvalias.icu";
    private static final int CNVALIAS_DATA_BUFFER_SIZE = 25000;
    private static final byte IGNORE = 0;
    private static final byte ZERO = 1;
    private static final byte NONZERO = 2;
    static final byte MINLETTER = 3;
    static final byte[] asciiTypes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 0, 0, 0, 0, 0, 0, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 0, 0, 0, 0, 0};
    static String[] gAvailableConverters = null;
    static int gAvailableConverterCount = 0;
    static byte[] gDefaultConverterNameBuffer;
    static String gDefaultConverterName;

    UConverterAlias() {
    }

    static final String GET_STRING(int idx) {
        return new String(gStringTable, 2 * idx, UConverterAlias.strlen(gStringTable, 2 * idx));
    }

    private static final String GET_NORMALIZED_STRING(int idx) {
        return new String(gNormalizedStringTable, 2 * idx, UConverterAlias.strlen(gNormalizedStringTable, 2 * idx));
    }

    public static final int strlen(byte[] sArray, int sBegin) {
        int i = sBegin;
        while (i < sArray.length && sArray[i++] != 0) {
        }
        return i - sBegin - 1;
    }

    private static final boolean isAlias(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("Alias param is null!");
        }
        return alias.length() != 0;
    }

    private static final synchronized boolean haveAliasData() throws IOException {
        boolean needInit;
        boolean bl = needInit = gAliasData == null;
        if (needInit) {
            ByteBuffer data = null;
            int[] tableArray = null;
            InputStream i = ICUData.getRequiredStream((String)CNVALIAS_DATA_FILE_NAME);
            BufferedInputStream b = new BufferedInputStream(i, 25000);
            UConverterAliasDataReader reader = new UConverterAliasDataReader(b);
            tableArray = reader.readToc(10);
            int tableStart = tableArray[0];
            if (tableStart < 9) {
                throw new IOException("Invalid data format.");
            }
            gConverterList = new int[tableArray[1]];
            gTagList = new int[tableArray[2]];
            gAliasList = new int[tableArray[3]];
            gUntaggedConvArray = new int[tableArray[4]];
            gTaggedAliasArray = new int[tableArray[5]];
            gTaggedAliasLists = new int[tableArray[6]];
            gOptionTable = new int[tableArray[7]];
            gStringTable = new byte[tableArray[8] * 2];
            gNormalizedStringTable = new byte[tableArray[9] * 2];
            reader.read(gConverterList, gTagList, gAliasList, gUntaggedConvArray, gTaggedAliasArray, gTaggedAliasLists, gOptionTable, gStringTable, gNormalizedStringTable);
            data = ByteBuffer.allocate(0);
            if (gOptionTable[0] != 1) {
                throw new IOException("Unsupported alias normalization");
            }
            if (gAliasData == null) {
                gAliasData = data;
                data = null;
            }
            if (data != null) {
                // empty if block
            }
        }
        return true;
    }

    private static final int findConverter(String alias, boolean[] isAmbigous) {
        int limit;
        StringBuffer strippedName = new StringBuffer();
        UConverterAlias.stripForCompare(strippedName, alias);
        alias = strippedName.toString();
        int start = 0;
        int mid = limit = gUntaggedConvArray.length;
        int lastMid = Integer.MAX_VALUE;
        while (lastMid != (mid = (start + limit) / 2)) {
            lastMid = mid;
            String aliasToCompare = UConverterAlias.GET_NORMALIZED_STRING(gAliasList[mid]);
            int result = alias.compareTo(aliasToCompare);
            if (result < 0) {
                limit = mid;
                continue;
            }
            if (result > 0) {
                start = mid;
                continue;
            }
            if ((gUntaggedConvArray[mid] & 0x8000) != 0) {
                isAmbigous[0] = true;
            }
            return gUntaggedConvArray[mid] & 0xFFF;
        }
        return Integer.MAX_VALUE;
    }

    public static final StringBuffer stripForCompare(StringBuffer dst, String name) {
        return UConverterAlias.io_stripASCIIForCompare(dst, name);
    }

    private static final char GET_CHAR_TYPE(char c) {
        return (char)(c < asciiTypes.length ? asciiTypes[c] : (byte)0);
    }

    private static final StringBuffer io_stripASCIIForCompare(StringBuffer dst, String name) {
        int nameIndex = 0;
        boolean afterDigit = false;
        block5: while (nameIndex < name.length()) {
            char c1 = name.charAt(nameIndex++);
            char type = UConverterAlias.GET_CHAR_TYPE(c1);
            switch (type) {
                case '\u0000': {
                    afterDigit = false;
                    continue block5;
                }
                case '\u0001': {
                    char nextType;
                    if (afterDigit || nameIndex >= name.length() || (nextType = UConverterAlias.GET_CHAR_TYPE(name.charAt(nameIndex))) != '\u0001' && nextType != '\u0002') break;
                    continue block5;
                }
                case '\u0002': {
                    afterDigit = true;
                    break;
                }
                default: {
                    c1 = type;
                    afterDigit = false;
                }
            }
            dst.append(c1);
        }
        return dst;
    }

    static int compareNames(String name1, String name2) {
        int rc;
        int name1Index = 0;
        int name2Index = 0;
        char c1 = '\u0000';
        char c2 = '\u0000';
        boolean afterDigit1 = false;
        boolean afterDigit2 = false;
        block10: while (true) {
            char nextType;
            char type;
            if (name1Index < name1.length()) {
                c1 = name1.charAt(name1Index++);
                type = UConverterAlias.GET_CHAR_TYPE(c1);
                switch (type) {
                    case '\u0000': {
                        afterDigit1 = false;
                        continue block10;
                    }
                    case '\u0001': {
                        if (afterDigit1 || name1Index >= name1.length() || (nextType = UConverterAlias.GET_CHAR_TYPE(name1.charAt(name1Index))) != '\u0001' && nextType != '\u0002') break;
                        continue block10;
                    }
                    case '\u0002': {
                        afterDigit1 = true;
                        break;
                    }
                    default: {
                        c1 = type;
                        afterDigit1 = false;
                        break;
                    }
                }
            }
            block11: while (name2Index < name2.length()) {
                c2 = name2.charAt(name2Index++);
                type = UConverterAlias.GET_CHAR_TYPE(c2);
                switch (type) {
                    case '\u0000': {
                        afterDigit2 = false;
                        continue block11;
                    }
                    case '\u0001': {
                        if (afterDigit2 || name1Index >= name1.length() || (nextType = UConverterAlias.GET_CHAR_TYPE(name2.charAt(name2Index))) != '\u0001' && nextType != '\u0002') break block11;
                        continue block11;
                    }
                    case '\u0002': {
                        afterDigit2 = true;
                        break block11;
                    }
                    default: {
                        c2 = type;
                        afterDigit2 = false;
                        break block11;
                    }
                }
            }
            if (name1Index >= name1.length() && name2Index >= name2.length()) {
                return 0;
            }
            rc = c1 - c2;
            if (rc != 0) break;
        }
        return rc;
    }

    static int io_countAliases(String alias) throws IOException {
        int listOffset;
        boolean[] isAmbigous;
        int convNum;
        if (UConverterAlias.haveAliasData() && UConverterAlias.isAlias(alias) && (convNum = UConverterAlias.findConverter(alias, isAmbigous = new boolean[1])) < gConverterList.length && (listOffset = gTaggedAliasArray[(gTagList.length - 1) * gConverterList.length + convNum]) != 0) {
            return gTaggedAliasLists[listOffset];
        }
        return 0;
    }

    static String io_getAlias(String alias, int n) throws IOException {
        int listOffset;
        boolean[] isAmbigous;
        int convNum;
        if (UConverterAlias.haveAliasData() && UConverterAlias.isAlias(alias) && (convNum = UConverterAlias.findConverter(alias, isAmbigous = new boolean[1])) < gConverterList.length && (listOffset = gTaggedAliasArray[(gTagList.length - 1) * gConverterList.length + convNum]) != 0) {
            int[] currListArray = gTaggedAliasLists;
            int currListArrayIndex = listOffset + 1;
            return UConverterAlias.GET_STRING(currListArray[currListArrayIndex + n]);
        }
        return null;
    }

    static final String getStandardName(String alias, String standard) throws IOException {
        int listOffset;
        if (UConverterAlias.haveAliasData() && UConverterAlias.isAlias(alias) && 0 < (listOffset = UConverterAlias.findTaggedAliasListsOffset(alias, standard)) && listOffset < gTaggedAliasLists.length) {
            int[] currListArray = gTaggedAliasLists;
            int currListArrayIndex = listOffset + 1;
            if (currListArray[0] != 0) {
                return UConverterAlias.GET_STRING(currListArray[currListArrayIndex]);
            }
        }
        return null;
    }

    static int countAliases(String alias) throws IOException {
        return UConverterAlias.io_countAliases(alias);
    }

    static String getAlias(String alias, int n) throws IOException {
        return UConverterAlias.io_getAlias(alias, n);
    }

    static String getAvailableName(int n) {
        try {
            if (0 <= n && n <= 65535) {
                String name = UConverterAlias.bld_getAvailableConverter(n);
                return name;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static String getCanonicalName(String alias, String standard) throws IOException {
        int convNum;
        if (UConverterAlias.haveAliasData() && UConverterAlias.isAlias(alias) && (convNum = UConverterAlias.findTaggedConverterNum(alias, standard)) < gConverterList.length) {
            return UConverterAlias.GET_STRING(gConverterList[convNum]);
        }
        return null;
    }

    static int countAvailable() {
        try {
            return UConverterAlias.bld_countAvailableConverters();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private static int getTagNumber(String tagName) {
        if (gTagList != null) {
            for (int tagNum = 0; tagNum < gTagList.length; ++tagNum) {
                if (!tagName.equals(UConverterAlias.GET_STRING(gTagList[tagNum]))) continue;
                return tagNum;
            }
        }
        return Integer.MAX_VALUE;
    }

    private static int findTaggedAliasListsOffset(String alias, String standard) {
        int tagNum = UConverterAlias.getTagNumber(standard);
        boolean[] isAmbigous = new boolean[1];
        int convNum = UConverterAlias.findConverter(alias, isAmbigous);
        if (tagNum < gTagList.length - 1 && convNum < gConverterList.length) {
            int listOffset = gTaggedAliasArray[tagNum * gConverterList.length + convNum];
            if (listOffset != 0 && gTaggedAliasLists[listOffset + 1] != 0) {
                return listOffset;
            }
            if (isAmbigous[0]) {
                for (int idx = 0; idx < gTaggedAliasArray.length; ++idx) {
                    int currTagNum;
                    int currConvNum;
                    int tempListOffset;
                    listOffset = gTaggedAliasArray[idx];
                    if (listOffset == 0 || !UConverterAlias.isAliasInList(alias, listOffset) || (tempListOffset = gTaggedAliasArray[tagNum * gConverterList.length + (currConvNum = idx - (currTagNum = idx / gConverterList.length) * gConverterList.length)]) == 0 || gTaggedAliasLists[tempListOffset + 1] == 0) continue;
                    return tempListOffset;
                }
            }
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    private static int findTaggedConverterNum(String alias, String standard) {
        int tagNum = UConverterAlias.getTagNumber(standard);
        boolean[] isAmbigous = new boolean[1];
        int convNum = UConverterAlias.findConverter(alias, isAmbigous);
        if (tagNum < gTagList.length - 1 && convNum < gConverterList.length) {
            int listOffset = gTaggedAliasArray[tagNum * gConverterList.length + convNum];
            if (listOffset != 0 && UConverterAlias.isAliasInList(alias, listOffset)) {
                return convNum;
            }
            if (isAmbigous[0]) {
                int convStart = tagNum * gConverterList.length;
                int convLimit = (tagNum + 1) * gConverterList.length;
                for (int idx = convStart; idx < convLimit; ++idx) {
                    listOffset = gTaggedAliasArray[idx];
                    if (listOffset == 0 || !UConverterAlias.isAliasInList(alias, listOffset)) continue;
                    return idx - convStart;
                }
            }
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isAliasInList(String alias, int listOffset) {
        if (listOffset != 0) {
            int listCount = gTaggedAliasLists[listOffset];
            int[] currList = gTaggedAliasLists;
            int currListArrayIndex = listOffset + 1;
            for (int currAlias = 0; currAlias < listCount; ++currAlias) {
                if (currList[currAlias + currListArrayIndex] == 0 || UConverterAlias.compareNames(alias, UConverterAlias.GET_STRING(currList[currAlias + currListArrayIndex])) != 0) continue;
                return true;
            }
        }
        return false;
    }

    static boolean haveAvailableConverterList() throws IOException {
        if (gAvailableConverters == null) {
            if (!UConverterAlias.haveAliasData()) {
                return false;
            }
            String[] localConverterList = new String[gConverterList.length];
            int localConverterCount = 0;
            for (int idx = 0; idx < gConverterList.length; ++idx) {
                String converterName = UConverterAlias.GET_STRING(gConverterList[idx]);
                localConverterList[localConverterCount++] = converterName;
            }
            if (gAvailableConverters == null) {
                gAvailableConverters = localConverterList;
                gAvailableConverterCount = localConverterCount;
            }
        }
        return true;
    }

    static int bld_countAvailableConverters() throws IOException {
        if (UConverterAlias.haveAvailableConverterList()) {
            return gAvailableConverterCount;
        }
        return 0;
    }

    static String bld_getAvailableConverter(int n) throws IOException {
        if (UConverterAlias.haveAvailableConverterList() && n < gAvailableConverterCount) {
            return gAvailableConverters[n];
        }
        return null;
    }

    static {
        gDefaultConverterName = null;
    }
}

