/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.service;

import com.gisgraphy.domain.valueobject.Output;
import com.gisgraphy.domain.valueobject.Pagination;
import com.gisgraphy.serializer.common.OutputFormat;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class AbstractGisQuery {
    private String callback;
    private String apikey;
    private static Pattern callbackValidationPattern = Pattern.compile("\\w+");
    private static Logger logger = Logger.getLogger(AbstractGisQuery.class);
    public static final int DEFAULT_NB_RESULTS = 10;
    protected Pagination pagination = Pagination.DEFAULT_PAGINATION;
    protected Output output = Output.DEFAULT_OUTPUT;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.output == null ? 0 : this.output.hashCode());
        result = 31 * result + (this.pagination == null ? 0 : this.pagination.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGisQuery other = (AbstractGisQuery)obj;
        if (this.output == null ? other.output != null : !this.output.equals(other.output)) {
            return false;
        }
        return !(this.pagination == null ? other.pagination != null : !this.pagination.equals(other.pagination));
    }

    public AbstractGisQuery(Pagination pagination, Output output) {
        this.withPagination(pagination);
        this.withOutput(output);
    }

    public AbstractGisQuery() {
    }

    public int getMaxLimitResult() {
        return 10;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public AbstractGisQuery withPagination(Pagination pagination) {
        this.pagination = pagination == null ? Pagination.DEFAULT_PAGINATION : pagination;
        return this;
    }

    public Output getOutput() {
        return this.output;
    }

    public AbstractGisQuery withOutput(Output output) {
        this.output = output == null ? Output.DEFAULT_OUTPUT : output;
        return this;
    }

    public AbstractGisQuery withCallback(String callback) {
        if (callback != null && callbackValidationPattern.matcher(callback).matches()) {
            this.callback = callback;
        } else if (callback == null) {
            this.callback = null;
        } else {
            logger.warn((Object)("wrong callback specify : " + callback + ", callback method sould be alphanumeric"));
        }
        return this;
    }

    public Output.OutputStyle getOutputStyle() {
        return this.output.getStyle();
    }

    public int getFirstPaginationIndex() {
        return this.pagination.getFrom();
    }

    public int getLastPaginationIndex() {
        return this.pagination.getTo();
    }

    public int getMaxNumberOfResults() {
        return this.pagination.getMaxNumberOfResults();
    }

    public OutputFormat getOutputFormat() {
        return this.output.getFormat();
    }

    public String getOutputLanguage() {
        return this.output.getLanguageCode();
    }

    public String toString() {
        String asString = this.getClass().getSimpleName() + " with " + this.getOutput() + " and " + this.pagination + " and callback=" + this.callback;
        return asString;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getApikey() {
        return this.apikey;
    }

    public void setApikey(String apikey) {
        this.apikey = apikey;
    }
}

