/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.MismatchedSizeException;
import org.geotools.referencing.operation.builder.AffineTransformBuilder;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.builder.MathTransformBuilder;
import org.geotools.referencing.operation.builder.algorithm.MapTriangulationFactory;
import org.geotools.referencing.operation.builder.algorithm.Quadrilateral;
import org.geotools.referencing.operation.builder.algorithm.RubberSheetTransform;
import org.geotools.referencing.operation.builder.algorithm.TINTriangle;
import org.geotools.referencing.operation.builder.algorithm.TriangulationException;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class RubberSheetBuilder
extends MathTransformBuilder {
    private HashMap trianglesMap;
    private HashMap trianglesToKeysMap;

    public RubberSheetBuilder(List vectors, Quadrilateral quad) throws MismatchedSizeException, MismatchedDimensionException, MismatchedReferenceSystemException, TriangulationException {
        super.setMappedPositions(vectors);
        this.checkQuad(quad);
        MapTriangulationFactory trianglemap = new MapTriangulationFactory(quad, vectors);
        this.trianglesMap = (HashMap)trianglemap.getTriangleMap();
        this.trianglesToKeysMap = this.mapTrianglesToKey();
    }

    public int getMinimumPointCount() {
        return 1;
    }

    private void checkQuad(Quadrilateral quad) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem crs;
        try {
            crs = this.getSourceCRS();
        }
        catch (FactoryException e) {
            crs = quad.p0.getCoordinateReferenceSystem();
        }
        if (quad.p0.getCoordinateReferenceSystem() != crs || quad.p1.getCoordinateReferenceSystem() != crs || quad.p2.getCoordinateReferenceSystem() != crs || quad.p3.getCoordinateReferenceSystem() != crs) {
            throw new MismatchedReferenceSystemException("Wrong Coordinate Reference System of the quad.");
        }
    }

    public HashMap getMapTriangulation() {
        return this.trianglesMap;
    }

    private HashMap mapTrianglesToKey() {
        HashMap trianglesToKeysMap = (HashMap)this.trianglesMap.clone();
        for (Map.Entry entry : trianglesToKeysMap.entrySet()) {
            ArrayList<MappedPosition> pts = new ArrayList<MappedPosition>();
            for (int i = 1; i <= 3; ++i) {
                pts.add(new MappedPosition(((TINTriangle)entry.getKey()).getPoints()[i], ((TINTriangle)entry.getValue()).getPoints()[i]));
            }
            try {
                AffineTransformBuilder calculator = new AffineTransformBuilder(pts);
                entry.setValue(calculator.getMathTransform());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return trianglesToKeysMap;
    }

    protected MathTransform computeMathTransform() throws FactoryException {
        return new RubberSheetTransform(this.trianglesToKeysMap);
    }
}

