/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Map;
import javax.units.NonSI;
import javax.units.Unit;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.PrimeMeridian;

public class DefaultPrimeMeridian
extends AbstractIdentifiedObject
implements PrimeMeridian {
    private static final long serialVersionUID = 541978454643213305L;
    public static final DefaultPrimeMeridian GREENWICH = new DefaultPrimeMeridian("Greenwich", 0.0, NonSI.DEGREE_ANGLE);
    private final double greenwichLongitude;
    private final Unit angularUnit;

    public DefaultPrimeMeridian(PrimeMeridian meridian) {
        super((IdentifiedObject)meridian);
        this.greenwichLongitude = meridian.getGreenwichLongitude();
        this.angularUnit = meridian.getAngularUnit();
    }

    public DefaultPrimeMeridian(String name, double greenwichLongitude) {
        this(name, greenwichLongitude, NonSI.DEGREE_ANGLE);
    }

    public DefaultPrimeMeridian(String name, double greenwichLongitude, Unit angularUnit) {
        this(Collections.singletonMap("name", name), greenwichLongitude, angularUnit);
    }

    public DefaultPrimeMeridian(Map properties, double greenwichLongitude, Unit angularUnit) {
        super(properties);
        this.greenwichLongitude = greenwichLongitude;
        this.angularUnit = angularUnit;
        DefaultPrimeMeridian.ensureAngularUnit(angularUnit);
    }

    public double getGreenwichLongitude() {
        return this.greenwichLongitude;
    }

    public double getGreenwichLongitude(Unit targetUnit) {
        return this.getAngularUnit().getConverterTo(targetUnit).convert(this.getGreenwichLongitude());
    }

    public Unit getAngularUnit() {
        return this.angularUnit;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultPrimeMeridian that = (DefaultPrimeMeridian)object;
            if (compareMetadata) {
                return Double.doubleToLongBits(this.greenwichLongitude) == Double.doubleToLongBits(that.greenwichLongitude) && Utilities.equals(this.angularUnit, that.angularUnit);
            }
            return Double.doubleToLongBits(this.getGreenwichLongitude(NonSI.DEGREE_ANGLE)) == Double.doubleToLongBits(that.getGreenwichLongitude(NonSI.DEGREE_ANGLE));
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.greenwichLongitude);
        return (int)(code >>> 32) ^ (int)code ^ 0x70EC83F9;
    }

    protected String formatWKT(Formatter formatter) {
        Unit context = formatter.getAngularUnit();
        if (context == null) {
            context = NonSI.DEGREE_ANGLE;
        }
        formatter.append(this.getGreenwichLongitude(context));
        return "PRIMEM";
    }
}

