/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.net.URI;
import javax.units.Unit;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.Parameter;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public class FloatParameter
extends AbstractParameter
implements ParameterValue {
    private static final long serialVersionUID = 9027797654033417816L;
    private double value;

    public FloatParameter(ParameterDescriptor descriptor) {
        super((GeneralParameterDescriptor)descriptor);
        Class type = descriptor.getValueClass();
        Class<Double> expected = Double.class;
        if (!expected.equals((Object)type) && !Double.TYPE.equals(type)) {
            throw new IllegalArgumentException(Errors.format(45, Utilities.getShortName(type), Utilities.getShortName(expected)));
        }
        Number value = (Number)descriptor.getDefaultValue();
        this.value = value != null ? value.doubleValue() : Double.NaN;
    }

    public FloatParameter(ParameterDescriptor descriptor, double value) {
        this(descriptor);
        this.setValue(value);
    }

    public Unit getUnit() {
        return ((ParameterDescriptor)this.descriptor).getUnit();
    }

    public double doubleValue(Unit unit) throws IllegalArgumentException {
        FloatParameter.ensureNonNull("unit", unit);
        Unit thisUnit = this.getUnit();
        if (thisUnit == null) {
            throw FloatParameter.unitlessParameter(this.descriptor);
        }
        int expectedID = Parameter.getUnitMessageID(thisUnit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        return thisUnit.getConverterTo(unit).convert(this.value);
    }

    public double doubleValue() {
        return this.value;
    }

    public int intValue() {
        return (int)Math.round(this.value);
    }

    public boolean booleanValue() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public String stringValue() {
        return String.valueOf(this.value);
    }

    public double[] doubleValueList(Unit unit) throws IllegalArgumentException {
        return new double[]{this.doubleValue(unit)};
    }

    public double[] doubleValueList() {
        return new double[]{this.doubleValue()};
    }

    public int[] intValueList() {
        return new int[]{this.intValue()};
    }

    public URI valueFile() throws InvalidParameterTypeException {
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), Parameter.getName(this.descriptor));
    }

    private static String getClassTypeError() {
        return Errors.format(51, "Double");
    }

    public Object getValue() {
        return new Double(this.value);
    }

    public void setValue(double value, Unit unit) throws InvalidParameterValueException {
        FloatParameter.ensureNonNull("unit", unit);
        Unit thisUnit = ((ParameterDescriptor)this.descriptor).getUnit();
        if (thisUnit == null) {
            throw FloatParameter.unitlessParameter(this.descriptor);
        }
        int expectedID = Parameter.getUnitMessageID(thisUnit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        value = unit.getConverterTo(thisUnit).convert(value);
        Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, new Double(value));
        this.value = value;
    }

    public void setValue(double value) throws InvalidParameterValueException {
        Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, new Double(value));
        this.value = value;
    }

    public void setValue(int value) throws InvalidParameterValueException {
        this.setValue((double)value);
    }

    public void setValue(boolean value) throws InvalidParameterValueException {
        this.setValue(value ? 1.0 : 0.0);
    }

    public void setValue(Object value) throws InvalidParameterValueException {
        Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, value);
        this.value = ((Number)value).doubleValue();
    }

    public void setValue(double[] values, Unit unit) throws InvalidParameterValueException {
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), Parameter.getName(this.descriptor));
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            FloatParameter that = (FloatParameter)object;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value);
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.value);
        return (int)code ^ (int)(code >>> 32) + super.hashCode() * 37;
    }
}

