/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractDirectPosition
implements DirectPosition {
    protected AbstractDirectPosition() {
    }

    public DirectPosition getPosition() {
        return this;
    }

    public double[] getCoordinates() {
        double[] ordinates = new double[this.getDimension()];
        for (int i = 0; i < ordinates.length; ++i) {
            ordinates[i] = this.getOrdinate(i);
        }
        return ordinates;
    }

    static void checkCoordinateReferenceSystemDimension(CoordinateReferenceSystem crs, int expected) throws MismatchedDimensionException {
        int dimension;
        if (crs != null && (dimension = crs.getCoordinateSystem().getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format(69, crs.getName().getCode(), new Integer(dimension), new Integer(expected)));
        }
    }

    static void ensureDimensionMatch(String name, int dimension, int expectedDimension) throws MismatchedDimensionException {
        if (dimension != expectedDimension) {
            throw new MismatchedDimensionException(Errors.format(69, name, new Integer(dimension), new Integer(expectedDimension)));
        }
    }

    public String toString() {
        return AbstractDirectPosition.toString(this);
    }

    static String toString(DirectPosition position) {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(position)).append('[');
        int dimension = position.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(position.getOrdinate(i));
        }
        return buffer.append(']').toString();
    }

    public int hashCode() {
        int dimension = this.getDimension();
        int code = 1;
        for (int i = 0; i < dimension; ++i) {
            long bits = Double.doubleToLongBits(this.getOrdinate(i));
            code = 31 * code + ((int)bits ^ (int)(bits >>> 32));
        }
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        if (crs != null) {
            code += crs.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object instanceof DirectPosition) {
            DirectPosition that = (DirectPosition)object;
            int dimension = this.getDimension();
            if (dimension == that.getDimension()) {
                for (int i = 0; i < dimension; ++i) {
                    if (Double.doubleToLongBits(this.getOrdinate(i)) == Double.doubleToLongBits(that.getOrdinate(i))) continue;
                    return false;
                }
                if (Utilities.equals(this.getCoordinateReferenceSystem(), that.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == that.hashCode()) : this;
                    return true;
                }
            }
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

