/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.directwebremoting.dwrp.ObjectOutboundVariable;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;
import org.directwebremoting.util.Messages;

public class MapConverter
implements Converter {
    private static boolean sentNonStringWarning = false;
    private ConverterManager config = null;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$convert$MapConverter == null ? (class$org$directwebremoting$convert$MapConverter = MapConverter.class$("org.directwebremoting.convert.MapConverter")) : class$org$directwebremoting$convert$MapConverter);
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$directwebremoting$convert$MapConverter;

    public void setConverterManager(ConverterManager newConfig) {
        this.config = newConfig;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws MarshallException {
        String value = iv.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{")) {
            throw new IllegalArgumentException(Messages.getString("MapConverter.FormatError", "{"));
        }
        if (!value.endsWith("}")) {
            throw new IllegalArgumentException(Messages.getString("MapConverter.FormatError", "}"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Map map = !paramType.isInterface() && !Modifier.isAbstract(paramType.getModifiers()) ? (Map)paramType.newInstance() : new HashMap();
            TypeHintContext thc = inctx.getCurrentTypeHintContext();
            TypeHintContext keyThc = thc.createChildContext(0);
            Class keyType = keyThc.getExtraTypeInfo();
            TypeHintContext valThc = thc.createChildContext(1);
            Class valType = valThc.getExtraTypeInfo();
            inctx.addConverted(iv, paramType, map);
            InboundContext incx = iv.getLookup();
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            for (int i = 0; i < size; ++i) {
                String token = st.nextToken();
                if (token.trim().length() == 0) continue;
                int colonpos = token.indexOf(":");
                if (colonpos == -1) {
                    throw new MarshallException(paramType, Messages.getString("MapConverter.MissingSeparator", ":", token));
                }
                String valStr = token.substring(colonpos + 1).trim();
                String[] splitIv = ParseUtil.splitInbound(valStr);
                String splitIvValue = splitIv[1];
                String splitIvType = splitIv[0];
                InboundVariable valIv = new InboundVariable(incx, null, splitIvType, splitIvValue);
                Object val = this.config.convertInbound(valType, valIv, inctx, valThc);
                String keyStr = token.substring(0, colonpos).trim();
                InboundVariable keyIv = new InboundVariable(incx, null, "string", keyStr);
                Object key = this.config.convertInbound(keyType, keyIv, inctx, keyThc);
                map.put(key, val);
            }
            return map;
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(paramType, (Throwable)ex);
        }
    }

    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        HashMap<String, OutboundVariable> ovs = (HashMap<String, OutboundVariable>)LocalUtil.classNewInstance("OrderedConvertOutbound", "java.util.LinkedHashMap", class$java$util$Map == null ? (class$java$util$Map = MapConverter.class$("java.util.Map")) : class$java$util$Map);
        if (ovs == null) {
            ovs = new HashMap<String, OutboundVariable>();
        }
        ObjectOutboundVariable ov = new ObjectOutboundVariable(outctx);
        outctx.put(data, ov);
        Map map = (Map)data;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String) && !sentNonStringWarning) {
                log.warn("--Javascript does not support non string keys. Converting '" + key.getClass().getName() + "' using toString()");
                sentNonStringWarning = true;
            }
            String outkey = JavascriptUtil.escapeJavaScript(key.toString());
            OutboundVariable nested = this.config.convertOutbound(value, outctx);
            ovs.put(outkey, nested);
        }
        ov.init(ovs, null);
        return ov;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

